/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.floatingruins;

import bspkrs.floatingruins.FRLog;
import bspkrs.floatingruins.FloatingRuins;
import bspkrs.floatingruins.WorldGenFloatingIslandRuin;
import bspkrs.util.CommonUtils;
import bspkrs.util.Coord;
import cpw.mods.fml.common.registry.GameData;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenFloatingIsland
extends WorldGenerator {
    private boolean isLavaNearby;
    public static final int SPHEROID = 0;
    public static final int CONE = 1;
    public static final int JETSONS = 2;
    public static final int STALACTITE = 3;
    private Coord srcOrigin;
    private Coord tgtOrigin;
    private final int depth;
    public final int radius;
    public final int yGround;
    private final int islandType;
    private Random random;

    public WorldGenFloatingIsland(int radius, int depth, int yGround, int islandType) {
        this.radius = radius;
        this.depth = depth;
        this.yGround = yGround;
        this.islandType = islandType == 2 && depth < 30 ? 1 : islandType;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        boolean ran = false;
        this.random = FloatingRuins.getRandom(world, x, z);
        if (this.yGround == 0) {
            return false;
        }
        this.srcOrigin = new Coord(x, this.yGround, z);
        this.tgtOrigin = new Coord(x, y, z);
        this.isLavaNearby = false;
        if (this.isTgtSuitableForGeneration(world, this.tgtOrigin) && (ran = this.genIsland(world, this.radius, x, y, z)) && random.nextInt(FloatingRuins.rarityDungeon) == 0) {
            new WorldGenFloatingIslandRuin(this.isLavaNearby).func_76484_a(world, random, x, y, z);
        }
        return ran;
    }

    public boolean isTgtSuitableForGeneration(World world, Coord tgtOrigin) {
        FRLog.debug("Checking target area for generation suitability...", new Object[0]);
        for (int y = 40; y >= -this.depth; --y) {
            for (int x = -this.radius - 4; x <= this.radius + 4; ++x) {
                for (int z = -this.radius - 4; z <= this.radius + 4; ++z) {
                    Coord delta;
                    Coord tgt;
                    if (y != 40 && y != -this.depth && Math.abs(x) != this.radius && Math.abs(z) != this.radius && Math.abs(x) != this.radius + 4 && Math.abs(z) != this.radius + 4 || this.isTgtCoordReplaceable(world, tgt = tgtOrigin.add(delta = new Coord(x, y, z)), y < tgtOrigin.y)) continue;
                    FRLog.debug("Target coord is not replaceable: %s", tgt.toString());
                    return false;
                }
            }
        }
        FRLog.debug("Target area found to be suitable.", new Object[0]);
        return true;
    }

    public boolean isTgtCoordReplaceable(World world, Coord tgt, boolean allowNonAirSpecialBlocks) {
        return tgt.chunkExists(world) && (tgt.isAirBlock(world) || allowNonAirSpecialBlocks && tgt.getBlock(world).equals(Blocks.field_150355_j) || allowNonAirSpecialBlocks && !tgt.isBlockOpaqueCube(world) || allowNonAirSpecialBlocks && tgt.isWood(world) || allowNonAirSpecialBlocks && tgt.isLeaves(world));
    }

    private boolean genIsland(World world, int radius, int xIn, int yIn, int zIn) {
        Block block;
        Coord delta;
        int z;
        int blocksMoved = 0;
        int groundBlocksMoved = 0;
        int blockNotifications = 0;
        String debug = "Floating Island: ";
        debug = this.islandType == 1 ? debug + "Cone " : (this.islandType == 2 ? debug + "Jetsons " : debug + "Spheroid ");
        debug = debug + String.format("r(%d) d(%d) @%d,%d,%d ", radius, this.depth, xIn, yIn, zIn);
        Block specialOre = this.getSpecialOre();
        for (int y = 40; y >= -this.depth; --y) {
            float range;
            if (y >= 0) {
                range = radius;
            } else {
                switch (this.islandType) {
                    case 1: {
                        if (y >= -1) {
                            range = (float)((double)radius + (y > 9 ? 3.5 : (y > 5 ? 2.5 : (y > 1 ? 1.5 : 0.0))));
                            break;
                        }
                        range = (1.0f - Math.abs(((float)y + 1.0f) / ((float)this.depth - 1.0f))) * (float)radius;
                        break;
                    }
                    case 2: {
                        float jetDist = (float)this.depth / (float)Math.abs(y) - 1.0f;
                        if (y >= -1) {
                            range = radius;
                            break;
                        }
                        if (y == -2) {
                            range = (int)Math.round(Math.min(Math.ceil((float)radius * 0.9f), (double)jetDist));
                            break;
                        }
                        if (y == -3) {
                            range = (int)Math.round(Math.min(Math.ceil((float)radius * 0.8f), (double)jetDist));
                            break;
                        }
                        range = Math.round(jetDist);
                        break;
                    }
                    default: {
                        range = Math.round(Math.sqrt((float)CommonUtils.sqr((int)radius) * (1.0f - (float)CommonUtils.sqr((int)y) / (float)CommonUtils.sqr((int)this.depth))));
                    }
                }
            }
            if (range <= 0.0f) {
                range = -4.0f;
            }
            int x = (int)(-range - 4.0f);
            while ((float)x <= range + 4.0f) {
                z = (int)(-range - 4.0f);
                while ((float)z <= range + 4.0f) {
                    delta = new Coord(x, y, z);
                    Coord src = this.srcOrigin.add(delta);
                    if (!src.isAirBlock(world) && this.isBlockInRange(this.islandType, world, delta, this.depth, radius)) {
                        block = src.getBlock(world);
                        int metadata = src.getBlockMetadata(world);
                        if (!(y > 0 && (block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150358_i)) || CommonUtils.isIDInList((String)GameData.getBlockRegistry().func_148750_c((Object)block), (int)metadata, (String)FloatingRuins.blockIDBlacklist))) {
                            Coord tgt = this.tgtOrigin.add(delta);
                            if (block.equals(Blocks.field_150474_ac)) {
                                debug = debug + "+S(" + tgt + ") ";
                            } else if (block.equals(Blocks.field_150486_ae)) {
                                debug = debug + "+C(" + tgt + ") ";
                            } else if (y >= -8 && !this.isLavaNearby && (block.equals(Blocks.field_150353_l) || block.equals(Blocks.field_150356_k))) {
                                this.isLavaNearby = true;
                                debug = debug + "+L ";
                            }
                            if (!(y < 0 && this.isBlockInRange(this.islandType, world, delta.getAdjacentCoord(ForgeDirection.DOWN), this.depth, radius) && this.isBlockInRange(this.islandType, world, delta.getAdjacentCoord(ForgeDirection.NORTH), this.depth, radius) && this.isBlockInRange(this.islandType, world, delta.getAdjacentCoord(ForgeDirection.SOUTH), this.depth, radius) && this.isBlockInRange(this.islandType, world, delta.getAdjacentCoord(ForgeDirection.EAST), this.depth, radius) && this.isBlockInRange(this.islandType, world, delta.getAdjacentCoord(ForgeDirection.WEST), this.depth, radius))) {
                                Coord.moveBlock((World)world, (Coord)src, (Coord)tgt, (boolean)true);
                                ++blockNotifications;
                            } else {
                                Coord.moveBlock((World)world, (Coord)src, (Coord)tgt, (boolean)true, (int)0);
                            }
                            if (y <= 0) {
                                ++groundBlocksMoved;
                            }
                            ++blocksMoved;
                        }
                        if (this.random.nextInt(3) == 0 && block.equals(Blocks.field_150348_b) && Math.abs(x) <= 1 && Math.abs(z) <= 1 && Math.abs(y + this.depth / 4) <= 2) {
                            world.func_147465_d(x + xIn, y + yIn, z + zIn, specialOre, 0, 0);
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int y = 5; y >= -this.depth; --y) {
                for (z = -radius; z <= radius; ++z) {
                    delta = new Coord(x, y, z);
                    Coord tgt = this.tgtOrigin.add(delta);
                    block = tgt.getBlock(world);
                    if (tgt.isAirBlock(world) || !tgt.getAdjacentCoord(ForgeDirection.DOWN).isAirBlock(world)) continue;
                    if (block.equals(Blocks.field_150351_n)) {
                        world.func_147465_d(tgt.x, tgt.y, tgt.z, Blocks.field_150348_b, 0, 3);
                        continue;
                    }
                    if (!block.equals(Blocks.field_150354_m)) continue;
                    if (tgt.getBlockMetadata(world) == 1) {
                        world.func_147465_d(tgt.x, tgt.y, tgt.z, Blocks.field_150405_ch, 0, 3);
                        continue;
                    }
                    world.func_147465_d(tgt.x, tgt.y, tgt.z, Blocks.field_150322_A, 0, 3);
                }
            }
        }
        debug = debug + "Blocks Moved: " + blocksMoved + " (" + groundBlocksMoved + " at or below origin, " + blockNotifications + " block notifications)";
        FloatingRuins.debug(debug, new Object[0]);
        return true;
    }

    private boolean isBlockInRange(int islandType, World world, Coord delta, int depth, int radius) {
        float depthRatio = (float)depth / (float)radius;
        float distToCenterColumn = Math.round(Math.sqrt(CommonUtils.sqr((int)delta.x) + CommonUtils.sqr((int)delta.z)));
        float distToOrigin = Math.round(Math.sqrt((double)(CommonUtils.sqr((int)delta.x) + CommonUtils.sqr((int)delta.z)) + (delta.y > 10 ? -2.0 : (delta.y > 5 ? -1.0 : (delta.y > 0 ? 0.0 : (double)CommonUtils.sqr((float)((float)delta.y / depthRatio)))))));
        if (islandType == 1) {
            if (delta.y >= -1) {
                return (double)distToCenterColumn <= (double)radius + (delta.y > 9 ? 3.5 : (delta.y > 5 ? 2.5 : (delta.y > 1 ? 1.5 : 0.0)));
            }
            return distToCenterColumn <= (1.0f - Math.abs(((float)delta.y + 1.0f) / ((float)depth - 1.0f))) * (float)radius;
        }
        if (islandType == 2) {
            float jetDist = (float)depth / (float)Math.abs(delta.y) - 1.0f;
            return (double)distToCenterColumn <= (delta.y >= -1 ? (double)radius : (delta.y == -2 ? Math.min(Math.ceil((float)radius * 0.9f), (double)jetDist) : (delta.y == -3 ? Math.min(Math.ceil((float)radius * 0.8f), (double)jetDist) : (double)jetDist)));
        }
        if (islandType == 3) {
            if (delta.y >= -2) {
                return distToCenterColumn <= (float)radius;
            }
            if ((float)Math.abs(delta.y) <= (float)depth * 0.4f) {
                return distToOrigin <= (float)radius;
            }
            if (new Random((delta.x + delta.z) / (delta.z == 0 ? 1 : delta.z)).nextInt(Math.abs(delta.x * delta.z)) == 0) {
                return distToOrigin <= (float)radius;
            }
            return false;
        }
        return distToOrigin <= (float)radius;
    }

    private Block getSpecialOre() {
        switch (this.random.nextInt(8)) {
            case 0: {
                return Blocks.field_150482_ag;
            }
            case 1: {
                return Blocks.field_150352_o;
            }
            case 2: {
                return Blocks.field_150366_p;
            }
            case 3: {
                return Blocks.field_150369_x;
            }
            case 4: {
                return Blocks.field_150450_ax;
            }
            case 5: {
                return Blocks.field_150412_bA;
            }
            case 6: {
                return Blocks.field_150366_p;
            }
        }
        return Blocks.field_150365_q;
    }
}

