/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.blockitem;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityEngine
extends TileEntity
implements IInventory {
    ItemStack[] itemstacks = new ItemStack[this.func_70302_i_()];
    private int burnTime = 0;
    private boolean running = false;
    public float enginePower;
    public int engineFuelConsumption;

    public TileEntityEngine() {
    }

    public TileEntityEngine(float power, int fuelconsumption) {
        this();
        this.enginePower = power;
        this.engineFuelConsumption = fuelconsumption;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.burnTime = compound.func_74762_e("burn");
        this.engineFuelConsumption = compound.func_74765_d("fuelCons");
        this.enginePower = compound.func_74760_g("power");
        NBTTagList list = compound.func_150295_c("inv", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound comp = list.func_150305_b(i);
            byte j = comp.func_74771_c("i");
            this.itemstacks[j] = ItemStack.func_77949_a((NBTTagCompound)comp);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("burn", this.burnTime);
        compound.func_74777_a("fuelCons", (short)this.engineFuelConsumption);
        compound.func_74776_a("power", this.enginePower);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.itemstacks[i] == null) continue;
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74774_a("i", (byte)i);
            this.itemstacks[i].func_77955_b(comp);
            list.func_74742_a((NBTBase)comp);
        }
        compound.func_74782_a("inv", (NBTBase)list);
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void updateRunning() {
        this.running = this.consumeFuel(this.engineFuelConsumption);
    }

    public boolean consumeFuel(int f) {
        if (this.burnTime >= f) {
            this.burnTime -= f;
            return true;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack is = this.func_70298_a(i, 1);
            if (is == null || is.field_77994_a <= 0) continue;
            this.burnTime += TileEntityFurnace.func_145952_a((ItemStack)is);
            return this.consumeFuel(f);
        }
        return false;
    }

    public boolean canUpdate() {
        return false;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        return i >= 0 && i < 4 ? this.itemstacks[i] : null;
    }

    public ItemStack func_70298_a(int i, int n) {
        if (this.itemstacks[i] != null) {
            if (this.itemstacks[i].field_77994_a <= n) {
                ItemStack itemstack = this.itemstacks[i];
                this.itemstacks[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.itemstacks[i].func_77979_a(n);
            if (this.itemstacks[i].field_77994_a <= 0) {
                this.itemstacks[i] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack is) {
        if (i >= 0 && i < 4) {
            this.itemstacks[i] = is;
        }
    }

    public String func_145825_b() {
        return "Engine Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return i >= 0 && i < 4 && TileEntityFurnace.func_145954_b((ItemStack)is);
    }
}

