/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.event;

import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;

public class MobTalkerEvent
extends Event {
    private final IInteractionAdapter _adapter;

    public static boolean queryReqestInteraction(IInteractionAdapter adapter, EntityPlayer player) {
        return !MinecraftForge.EVENT_BUS.post((Event)new MobTalkerRequestInteractionEvent(adapter, player));
    }

    public static void notifyStartInteraction(IInteractionAdapter adapter) {
        MinecraftForge.EVENT_BUS.post((Event)new MobTalkerStartInteractionEvent(adapter));
    }

    public static void notifyEndInteraction(IInteractionAdapter adapter) {
        MinecraftForge.EVENT_BUS.post((Event)new MobTalkerEndInteractionEvent(adapter));
    }

    public MobTalkerEvent(IInteractionAdapter adapter) {
        this._adapter = adapter;
    }

    public IInteractionAdapter getAdapter() {
        return this._adapter;
    }

    @Cancelable
    public static class MobTalkerEndInteractionEvent
    extends MobTalkerEvent {
        public MobTalkerEndInteractionEvent(IInteractionAdapter adapter) {
            super(adapter);
        }
    }

    public static class MobTalkerStartInteractionEvent
    extends MobTalkerEvent {
        public MobTalkerStartInteractionEvent(IInteractionAdapter adapter) {
            super(adapter);
        }
    }

    @Cancelable
    public static class MobTalkerRequestInteractionEvent
    extends MobTalkerEvent {
        private final EntityPlayer _requester;

        public MobTalkerRequestInteractionEvent(IInteractionAdapter adapter, EntityPlayer requester) {
            super(adapter);
            this._requester = requester;
        }

        public EntityPlayer getRequester() {
            return this._requester;
        }

        public boolean isCancelable() {
            return true;
        }
    }
}

