/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.network;

import com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.mobtalker.mobtalker2.common.network.ClientToServerMessage;

class RemoteCallResult
implements Future<ClientToServerMessage> {
    private final Lock _lock = new ReentrantLock();
    private final Condition _doneCondition = this._lock.newCondition();
    private boolean _isDone;
    private boolean _isCancelled;
    private ClientToServerMessage _result;
    private ExecutionException _exception;
    private final Class<? extends ClientToServerMessage> _responseType;

    public RemoteCallResult(Class<? extends ClientToServerMessage> responseType) {
        this._responseType = responseType;
    }

    public Class<? extends ClientToServerMessage> getResponseType() {
        return this._responseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        this._lock.lock();
        try {
            boolean bl = this._isCancelled;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        this._lock.lock();
        try {
            boolean bl = this._isDone;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(ClientToServerMessage result, Exception ex) {
        this._lock.lock();
        try {
            Preconditions.checkState((!this._isDone ? 1 : 0) != 0, (Object)"result is already set");
            this._result = result;
            this._exception = ex != null ? new ExecutionException(ex) : null;
            this._isDone = true;
            this._doneCondition.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientToServerMessage get() throws InterruptedException, ExecutionException {
        this._lock.lock();
        try {
            while (!this._isDone) {
                this._doneCondition.await();
            }
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            if (this._exception != null) {
                throw this._exception;
            }
            ClientToServerMessage clientToServerMessage = this._result;
            return clientToServerMessage;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientToServerMessage get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this._lock.lock();
        try {
            if (!this._isDone) {
                this._doneCondition.await(timeout, unit);
            }
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            if (this._exception != null) {
                throw this._exception;
            }
            ClientToServerMessage clientToServerMessage = this._result;
            return clientToServerMessage;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!mayInterruptIfRunning) {
            return false;
        }
        this._lock.lock();
        try {
            if (this.isDone()) {
                boolean bl = false;
                return bl;
            }
            if (this.isCancelled()) {
                boolean bl = true;
                return bl;
            }
            this._isCancelled = true;
            this._isDone = true;
            this._doneCondition.signalAll();
            boolean bl = true;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }
}

