/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.script;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;
import net.mobtalker.mobtalker2.server.script.serialization.MtsToNbtSerializer;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptPackEntry;
import net.mobtalker.mobtalkerscript.v2.value.MtsClosure;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;

public class InteractionScript
implements Runnable {
    private final IScriptPackEntry _scriptPackEntry;
    private final IInteractionAdapter _adapter;
    private final MtsTable _env;
    private final List<MtsClosure> _scripts;
    private final Map<UUID, MtsTable> _perPlayerSaves;

    public InteractionScript(IScriptPackEntry scriptPackEntry, IInteractionAdapter adapter, MtsTable env, List<MtsClosure> scripts) {
        Preconditions.checkNotNull((Object)scriptPackEntry, (Object)"scriptPackEntry cannot be null");
        Preconditions.checkNotNull((Object)adapter, (Object)"adapter cannot be null");
        Preconditions.checkNotNull((Object)env, (Object)"script environment is null");
        Preconditions.checkNotNull(scripts, (Object)"scripts is null");
        Preconditions.checkArgument((!scripts.isEmpty() ? 1 : 0) != 0, (Object)"scripts is empty");
        this._scriptPackEntry = scriptPackEntry;
        this._adapter = adapter;
        this._env = env;
        this._scripts = scripts;
        this._perPlayerSaves = Maps.newHashMap();
    }

    public IInteractionAdapter getAdapter() {
        return this._adapter;
    }

    public MtsTable getEnvironment() {
        return this._env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.deserializePlayer();
        try {
            for (MtsClosure script : this._scripts) {
                script.call();
            }
        }
        finally {
            this.serializePlayer();
        }
    }

    public NBTTagCompound serialize() {
        NBTTagCompound store = new NBTTagCompound();
        MtsTable table = this.getVariables(this._scriptPackEntry.getSavedVariables());
        NBTTagList tag = MtsToNbtSerializer.serialize(table);
        store.func_74782_a("Global", (NBTBase)tag);
        for (Map.Entry<UUID, MtsTable> entry : this._perPlayerSaves.entrySet()) {
            UUID uuid = entry.getKey();
            MtsTable table2 = entry.getValue();
            if (table2.isEmpty()) continue;
            NBTTagList tag2 = MtsToNbtSerializer.serialize(table2);
            store.func_74782_a(uuid.toString(), (NBTBase)tag2);
        }
        return store;
    }

    public void serializePlayer() {
        UUID playerUUID = this._adapter.getPlayer().func_110124_au();
        MtsTable table = this.getVariables(this._scriptPackEntry.getSavedVariablesPerPlayer());
        this._perPlayerSaves.put(playerUUID, table);
    }

    private MtsTable getVariables(Set<String> variables) {
        MtsTable result = new MtsTable(0, variables.size());
        for (String variable : variables) {
            MtsValue value = this._env.get(variable);
            if (value.isNil()) continue;
            result.set(variable, value);
        }
        return result;
    }

    public void deserialize(NBTTagCompound store) {
        this._perPlayerSaves.clear();
        Set keys = store.func_150296_c();
        for (String key : keys) {
            NBTTagList tag = (NBTTagList)store.func_74781_a(key);
            MtsTable table = MtsToNbtSerializer.deserialize(tag);
            if (key.equals("Global")) {
                this.setVariables(this._scriptPackEntry.getSavedVariables(), table);
                continue;
            }
            UUID uuid = UUID.fromString(key);
            this._perPlayerSaves.put(uuid, table);
        }
    }

    private void deserializePlayer() {
        UUID playerUUID = this._adapter.getPlayer().func_110124_au();
        MtsTable table = this._perPlayerSaves.get(playerUUID);
        if (table == null) {
            return;
        }
        this.setVariables(this._scriptPackEntry.getSavedVariablesPerPlayer(), table);
    }

    private void setVariables(Set<String> variables, MtsTable source) {
        for (String variable : variables) {
            MtsValue value = source.get(variable);
            this._env.set(variable, value);
        }
    }
}

