/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.script;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.mobtalker.mobtalker2.MobTalker2;
import net.mobtalker.mobtalker2.common.MobTalkerConfig;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;
import net.mobtalker.mobtalker2.server.script.InteractionScript;
import net.mobtalker.mobtalker2.server.script.MissingScriptException;
import net.mobtalker.mobtalker2.server.script.lib.InteractionCommandLib;
import net.mobtalker.mobtalker2.server.script.lib.InteractionEntityLib;
import net.mobtalker.mobtalker2.server.script.lib.InteractionPlayerLib;
import net.mobtalker.mobtalker2.server.script.lib.InteractionWorldLib;
import net.mobtalker.mobtalker2.server.script.lib.MinecraftCommandLib;
import net.mobtalker.mobtalker2.server.script.lib.ScoreboardLib;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptFile;
import net.mobtalker.mobtalker2.server.scriptpack.IScriptPackEntry;
import net.mobtalker.mobtalker2.server.scriptpack.ScriptPackRepository;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;
import net.mobtalker.mobtalkerscript.util.logging.MtsLog;
import net.mobtalker.mobtalkerscript.v2.MtsFunctionPrototype;
import net.mobtalker.mobtalkerscript.v2.MtsGlobals;
import net.mobtalker.mobtalkerscript.v2.compiler.MtsCompiler;
import net.mobtalker.mobtalkerscript.v2.compiler.MtsSyntaxError;
import net.mobtalker.mobtalkerscript.v2.value.MtsClosure;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNatives;

public class InteractionScriptFactory {
    private static final String LOG_TAG = "InteractionScriptFactory";
    private static InteractionScriptFactory instance;
    private final Map<IScriptPackEntry, MtsSyntaxError> _syntaxErrors = Maps.newHashMap();
    private final Map<IScriptFile, MtsFunctionPrototype> _compiledScripts = Maps.newHashMap();
    private final MtsGlobals _globals = InteractionScriptFactory.createGlobals();
    private final MtsTable _metatable = InteractionScriptFactory.createMetatable(this._globals);

    public static InteractionScriptFactory instance() {
        Preconditions.checkState((boolean)InteractionScriptFactory.isLoaded(), (Object)"No InteractionScriptFactory is currently loaded");
        return instance;
    }

    public static void load() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Already loaded");
        MobTalkerLog.debug(LOG_TAG, "Loading");
        try {
            Files.createDirectories(MobTalker2.getMobtalkerPath("logs"), new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create logging directory", ex);
        }
        try {
            Logger logger = Logger.getLogger("MobTalkerScript");
            MtsLog.setLogger(logger, false);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to setup MobTalkerScript logging", ex);
        }
        try {
            MobTalkerLog.debug(LOG_TAG, "Initializing script compiler");
            MtsCompiler.loadString(";", "");
        }
        catch (Exception ex) {
            MobTalkerLog.fatal(LOG_TAG, "Could not initialize compiler", ex);
            throw Throwables.propagate((Throwable)ex);
        }
        instance = new InteractionScriptFactory();
    }

    public static void unload() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Already unloaded");
        MobTalkerLog.debug(LOG_TAG, "Unloading");
        instance = null;
    }

    public static boolean isLoaded() {
        Preconditions.checkState((boolean)MobTalker2.isServer());
        return instance != null;
    }

    public static void precompileScripts() {
        Preconditions.checkState((boolean)InteractionScriptFactory.isLoaded(), (Object)"No InteractionScriptFactory is currently loaded");
        Preconditions.checkState((boolean)ScriptPackRepository.isLoaded(), (Object)"Script pack repository is not loaded");
        MobTalkerLog.debug(LOG_TAG, "Precompiling interaction scripts");
        for (IScriptPackEntry entry : ScriptPackRepository.instance().getActiveScripts().values()) {
            try {
                instance.getPrototypesFor(entry);
            }
            catch (MtsSyntaxError ex) {
                MobTalkerLog.warn(LOG_TAG, "A script contains syntax errors\n" + ex.getMessage());
            }
            catch (IOException ex) {
                MobTalkerLog.error(LOG_TAG, "IOException while precompiling a script", ex);
            }
        }
    }

    private InteractionScriptFactory() {
    }

    private static MtsGlobals createGlobals() {
        MtsGlobals G = new MtsGlobals();
        G.set("Scoreboard", (MtsValue)MtsNatives.createLibrary(new ScoreboardLib()), false);
        return G;
    }

    private static MtsTable createMetatable(MtsGlobals globals) {
        MtsTable t = new MtsTable();
        t.set(MtsValue.__INDEX, (MtsValue)globals);
        t.set(MtsValue.__METATABLE, (MtsValue)MtsValue.TRUE);
        return t;
    }

    private MtsTable createScriptEnvironment(IInteractionAdapter adapter) {
        MtsTable env = new MtsTable();
        env.setMetaTable(this._metatable);
        env.set("_G", (MtsValue)env, false);
        MtsNatives.createLibrary(new InteractionCommandLib(adapter), env);
        env.set("Command", (MtsValue)MtsNatives.createLibrary(new MinecraftCommandLib(adapter)), false);
        env.set("Entity", (MtsValue)MtsNatives.createLibrary(new InteractionEntityLib(adapter)), false);
        env.set("Player", (MtsValue)MtsNatives.createLibrary(new InteractionPlayerLib(adapter)), false);
        env.set("World", (MtsValue)MtsNatives.createLibrary(new InteractionWorldLib(adapter)), false);
        return env;
    }

    private List<MtsFunctionPrototype> getPrototypesFor(IScriptPackEntry entry) throws IOException {
        this.rethrowIfSyntaxError(entry);
        ArrayList prototypes = Lists.newArrayList();
        try {
            List<IScriptFile> files = entry.getFiles();
            assert (!files.isEmpty());
            for (IScriptFile file : files) {
                MtsFunctionPrototype prototype = this._compiledScripts.get(file);
                if (prototype == null) {
                    prototype = MtsCompiler.load(file.getStream());
                    this._compiledScripts.put(file, prototype);
                }
                prototypes.add(prototype);
            }
        }
        catch (MtsSyntaxError ex) {
            this._syntaxErrors.put(entry, ex);
            throw ex;
        }
        return prototypes;
    }

    public InteractionScript createInstanceFor(IInteractionAdapter adapter) throws IOException {
        String entity = adapter.getDefaultEntityName();
        if (!ScriptPackRepository.instance().hasScriptFor(entity)) {
            throw new MissingScriptException(entity);
        }
        IScriptPackEntry entry = ScriptPackRepository.instance().getScriptFor(entity);
        List<MtsFunctionPrototype> prototypes = this.getPrototypesFor(entry);
        MtsTable env = this.createScriptEnvironment(adapter);
        ImmutableList<MtsClosure> closures = InteractionScriptFactory.createClosures(prototypes, env);
        return new InteractionScript(entry, adapter, env, (List<MtsClosure>)closures);
    }

    public void writeDebugOutput(String scriptName) throws IOException {
        if (!ScriptPackRepository.instance().hasScriptFor(scriptName)) {
            throw new MissingScriptException(scriptName);
        }
        IScriptPackEntry entry = ScriptPackRepository.instance().getScriptFor(scriptName);
        List<MtsFunctionPrototype> prototypes = this.getPrototypesFor(entry);
        Path dirPath = MobTalker2.getMobtalkerPath("debug");
        Files.createDirectories(dirPath, new FileAttribute[0]);
        Path filePath = dirPath.resolve(scriptName + ".debug");
        try (BufferedWriter writer = Files.newBufferedWriter(filePath, MobTalkerConfig.CHARSET, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            for (MtsFunctionPrototype prototype : prototypes) {
                writer.write(prototype.toString(true, true));
                writer.write("\n\n");
            }
        }
    }

    private static ImmutableList<MtsClosure> createClosures(List<MtsFunctionPrototype> prototypes, MtsTable env) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MtsFunctionPrototype prototype : prototypes) {
            builder.add((Object)new MtsClosure(prototype, env));
        }
        return builder.build();
    }

    private void rethrowIfSyntaxError(IScriptPackEntry entry) {
        if (this._syntaxErrors.containsKey(entry)) {
            throw this._syntaxErrors.get(entry);
        }
    }

    public Map<IScriptPackEntry, MtsSyntaxError> getSyntaxErrors() {
        return Collections.unmodifiableMap(this._syntaxErrors);
    }
}

