/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.script.lib;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import net.minecraft.scoreboard.IScoreObjectiveCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;
import net.mobtalker.mobtalker2.util.ChatFormattingUtil;
import net.mobtalker.mobtalkerscript.util.MtsCheck;
import net.mobtalker.mobtalkerscript.v2.BadArgumentException;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;

public class ScoreboardLib {
    private Scoreboard getScoreboard() {
        return MinecraftServer.func_71276_C().func_71218_a(0).func_96441_U();
    }

    private ScoreObjective getObjective(String name, boolean throwOnReadonly) {
        ScoreObjective objective = this.getScoreboard().func_96518_b(name);
        if (objective == null) {
            throw new BadArgumentException("unknown objective '%s'", name);
        }
        if (throwOnReadonly && objective.func_96680_c().func_96637_b()) {
            throw new BadArgumentException("objective '%s' is read-only", name);
        }
        return objective;
    }

    @MtsNativeFunction
    public void setDisplayedObjective(MtsValue argSlotName, MtsValue argObjectiveName) {
        String slotName = MtsCheck.checkString(argSlotName, 0);
        Scoreboard scoreboard = this.getScoreboard();
        int slot = Scoreboard.func_96537_j((String)slotName);
        if (slot < 0) {
            throw new BadArgumentException(0, "unknown display slot '%s'", slotName);
        }
        String objectiveName = MtsCheck.checkString(argObjectiveName, 1);
        ScoreObjective objective = this.getObjective(objectiveName, false);
        scoreboard.func_96530_a(slot, objective);
    }

    @MtsNativeFunction
    public void clearDisplayedObjective(MtsValue argSlotName) {
        String slotName = MtsCheck.checkString(argSlotName, 0);
        Scoreboard scoreboard = this.getScoreboard();
        int slot = Scoreboard.func_96537_j((String)slotName);
        if (slot < 0) {
            throw new BadArgumentException(0, "unknown display slot '%s'", slotName);
        }
        scoreboard.func_96530_a(slot, null);
    }

    @MtsNativeFunction
    public MtsTable getObjectives() {
        Collection objectives = this.getScoreboard().func_96514_c();
        MtsTable result = new MtsTable(0, objectives.size());
        for (ScoreObjective objective : objectives) {
            String name = objective.func_96679_b();
            String criteria = objective.func_96680_c().func_96636_a();
            result.set(MtsValue.valueOf(name), (MtsValue)MtsValue.valueOf(criteria));
        }
        return result;
    }

    @MtsNativeFunction
    public MtsBoolean hasObjective(MtsValue argName) {
        String name = MtsCheck.checkString(argName, 0);
        return MtsValue.valueOf(this.getScoreboard().func_96518_b(name) != null);
    }

    @MtsNativeFunction
    public void addObjective(MtsValue argName, MtsValue argCriteraName, MtsValue argDisplayName) {
        String name = MtsCheck.checkString(argName, 0);
        String criteriaName = MtsCheck.checkString(argCriteraName, 1);
        Scoreboard scoreboard = this.getScoreboard();
        if (Strings.isNullOrEmpty((String)name)) {
            throw new BadArgumentException("name is empty", new Object[0]);
        }
        if (name.length() > 16) {
            throw new BadArgumentException("name must be no longer than 16 characters", new Object[0]);
        }
        if (scoreboard.func_96518_b(name) != null) {
            throw new BadArgumentException("objective '%s' already exists", name);
        }
        IScoreObjectiveCriteria criteria = (IScoreObjectiveCriteria)IScoreObjectiveCriteria.field_96643_a.get(criteriaName);
        if (criteria == null) {
            throw new BadArgumentException("unknown criteria '%s'", criteriaName);
        }
        String displayName = MtsCheck.checkString(argDisplayName, 2, null);
        if (!Strings.isNullOrEmpty((String)displayName)) {
            if (displayName.length() > 32) {
                throw new BadArgumentException("display name must be no longer than 32 characters", new Object[0]);
            }
            scoreboard.func_96535_a(name, criteria).func_96681_a(displayName);
        } else {
            scoreboard.func_96535_a(name, criteria);
        }
    }

    @MtsNativeFunction
    public void removeObjective(MtsValue argName) {
        String name = MtsCheck.checkString(argName, 0);
        Scoreboard scoreboard = this.getScoreboard();
        ScoreObjective objective = this.getObjective(name, false);
        if (objective == null) {
            throw new BadArgumentException("unknown objective '%s'", name);
        }
        scoreboard.func_96519_k(objective);
    }

    @MtsNativeFunction
    public MtsTable getPlayers() {
        Collection playerNames = this.getScoreboard().func_96526_d();
        MtsTable result = new MtsTable(playerNames.size(), 0);
        for (String name : playerNames) {
            result.add(MtsValue.valueOf(name));
        }
        return result;
    }

    @MtsNativeFunction
    public MtsTable getScores(MtsValue argPlayerName) {
        String playerName = MtsCheck.checkString(argPlayerName, 0);
        Map scores = this.getScoreboard().func_96510_d(playerName);
        MtsTable result = new MtsTable(0, scores.size());
        for (Map.Entry entry : scores.entrySet()) {
            ScoreObjective objective = (ScoreObjective)entry.getKey();
            Score score = (Score)entry.getValue();
            result.set(MtsValue.valueOf(objective.func_96679_b()), (MtsValue)MtsValue.valueOf(score.func_96652_c()));
        }
        return result;
    }

    private Score getScoreForPlayer(String playerName, String objectiveName) {
        Scoreboard scoreboard = this.getScoreboard();
        ScoreObjective objective = this.getObjective(objectiveName, false);
        if (objective == null) {
            throw new BadArgumentException("unknown objective '%s'", objectiveName);
        }
        Score score = scoreboard.func_96529_a(playerName, objective);
        return score;
    }

    @MtsNativeFunction
    public MtsNumber getScore(MtsValue argPlayerName, MtsValue argObjectiveName) {
        String playerName = MtsCheck.checkString(argPlayerName, 0);
        String objectiveName = MtsCheck.checkString(argObjectiveName, 1);
        Score score = this.getScoreForPlayer(playerName, objectiveName);
        return MtsValue.valueOf(score.func_96652_c());
    }

    @MtsNativeFunction
    public void setScore(MtsValue argPlayerName, MtsValue argObjectiveName, MtsValue argValue) {
        String playerName = MtsCheck.checkString(argPlayerName, 0);
        String objectiveName = MtsCheck.checkString(argObjectiveName, 1);
        int value = MtsCheck.checkInteger(argValue, 2);
        Score score = this.getScoreForPlayer(playerName, objectiveName);
        score.func_96647_c(value);
    }

    @MtsNativeFunction
    public MtsNumber increaseScore(MtsValue argPlayerName, MtsValue argObjectiveName, MtsValue argValue) {
        String playerName = MtsCheck.checkString(argPlayerName, 0);
        String objectiveName = MtsCheck.checkString(argObjectiveName, 1);
        int value = MtsCheck.checkIntegerWithMinimum(argValue, 2, 0);
        Score score = this.getScoreForPlayer(playerName, objectiveName);
        score.func_96649_a(value);
        return MtsValue.valueOf(score.func_96652_c());
    }

    @MtsNativeFunction
    public MtsNumber decreaseScore(MtsValue argPlayerName, MtsValue argObjectiveName, MtsValue argValue) {
        String playerName = MtsCheck.checkString(argPlayerName, 0);
        String objectiveName = MtsCheck.checkString(argObjectiveName, 1);
        int value = MtsCheck.checkIntegerWithMinimum(argValue, 2, 0);
        Score score = this.getScoreForPlayer(playerName, objectiveName);
        score.func_96646_b(value);
        return MtsValue.valueOf(score.func_96652_c());
    }

    @MtsNativeFunction
    public MtsTable getTeams() {
        Collection teams = this.getScoreboard().func_96525_g();
        MtsTable result = new MtsTable(0, teams.size());
        for (ScorePlayerTeam team : teams) {
            String name = team.func_96661_b();
            EnumChatFormatting color = ChatFormattingUtil.fromPrefix(team.func_96668_e());
            boolean friendlyFire = team.func_96665_g();
            boolean seeFriendlyInvisibles = team.func_98297_h();
            MtsTable options = new MtsTable(0, 0);
            options.set("color", (MtsValue)MtsValue.valueOf(color.func_96297_d()));
            options.set("friendlyfire", (MtsValue)MtsValue.valueOf(friendlyFire));
            options.set("seeFriendlyInvisibles", (MtsValue)MtsValue.valueOf(seeFriendlyInvisibles));
            result.set(name, (MtsValue)options);
        }
        return result;
    }

    @MtsNativeFunction
    public MtsTable getTeamMembers(MtsValue argTeamName) {
        String teamName = MtsCheck.checkString(argTeamName, 0);
        ScorePlayerTeam team = this.getScoreboard().func_96508_e(teamName);
        if (team == null) {
            throw new BadArgumentException("unknown team '%s'", teamName);
        }
        Collection members = team.func_96670_d();
        MtsTable result = new MtsTable(members.size(), 0);
        for (String member : members) {
            result.add(MtsValue.valueOf(member));
        }
        return result;
    }

    @MtsNativeFunction
    public void addTeam(MtsValue argTeamName, MtsValue argDisplayName) {
        String teamName = MtsCheck.checkString(argTeamName, 0);
        String displayName = MtsCheck.checkString(argDisplayName, 1, null);
        Scoreboard scoreboard = this.getScoreboard();
        if (scoreboard.func_96508_e(teamName) != null) {
            throw new BadArgumentException("team '%s' already exists", teamName);
        }
        if (Strings.isNullOrEmpty((String)teamName)) {
            throw new BadArgumentException("empty team name", new Object[0]);
        }
        if (teamName.length() > 16) {
            throw new BadArgumentException("team name is too long", teamName);
        }
        if (displayName != null && displayName.length() > 32) {
            throw new BadArgumentException("display name is too long", displayName);
        }
        ScorePlayerTeam team = scoreboard.func_96527_f(teamName);
        if (displayName != null && !displayName.isEmpty()) {
            team.func_96664_a(displayName);
        }
    }

    @MtsNativeFunction
    public void removeTeam(MtsValue argTeamName) {
        String teamName = MtsCheck.checkString(argTeamName, 0);
        Scoreboard scoreboard = this.getScoreboard();
        ScorePlayerTeam team = scoreboard.func_96508_e(teamName);
        if (team == null) {
            throw new BadArgumentException("unknown team '%s'", teamName);
        }
        scoreboard.func_96511_d(team);
    }

    @MtsNativeFunction
    public void addTeamMember(MtsValue argTeamName, MtsValue argPlayerName) {
        String teamName = MtsCheck.checkString(argTeamName, 0);
        String playerName = MtsCheck.checkString(argPlayerName, 1);
        Scoreboard scoreboard = this.getScoreboard();
        ScorePlayerTeam team = scoreboard.func_96508_e(teamName);
        if (team == null) {
            throw new BadArgumentException("unknown team '%s'", teamName);
        }
        scoreboard.func_151392_a(playerName, teamName);
    }

    public void removeTeamMember(MtsValue argTeamName, MtsValue argPlayerName) {
        String teamName = MtsCheck.checkString(argTeamName, 0);
        String playerName = MtsCheck.checkString(argPlayerName, 1);
        Scoreboard scoreboard = this.getScoreboard();
        ScorePlayerTeam team = scoreboard.func_96508_e(teamName);
        if (team == null) {
            throw new BadArgumentException("unknown team '%s'", teamName);
        }
        scoreboard.func_96512_b(playerName, team);
    }
}

