/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.script.serialization;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;

public class MtsToNbtSerializer {
    public static NBTBase serialize(MtsValue value) {
        return MtsToNbtSerializer.serialize(null, value);
    }

    public static NBTBase serialize(String name, MtsValue value) {
        if (value.isBoolean()) {
            return MtsToNbtSerializer.serialize(value.asBoolean());
        }
        if (value.isInteger()) {
            return MtsToNbtSerializer.serialize(value.asNumber());
        }
        if (value.isNumber()) {
            return MtsToNbtSerializer.serialize(value.asNumber());
        }
        if (value.isString()) {
            return MtsToNbtSerializer.serialize(value.asString());
        }
        if (value.isTable()) {
            return MtsToNbtSerializer.serialize(value.asTable());
        }
        throw new IllegalArgumentException("Unserializeable value: " + value.getType().getName());
    }

    public static NBTTagByte serialize(MtsBoolean value) {
        return new NBTTagByte((byte)(value.isTrue() ? 1 : 0));
    }

    public static NBTBase.NBTPrimitive serialize(MtsNumber value) {
        if (value.isInteger()) {
            return new NBTTagInt(value.asJavaInt());
        }
        return new NBTTagDouble(value.asJavaDouble());
    }

    public static NBTTagString serialize(MtsString value) {
        return new NBTTagString(value.asJavaString());
    }

    public static NBTTagList serialize(MtsTable table) {
        NBTTagList tag = new NBTTagList();
        int i = 0;
        for (MtsValue value : table.listView()) {
            NBTTagCompound listEntry = new NBTTagCompound();
            listEntry.func_74782_a("k", (NBTBase)new NBTTagInt(++i));
            listEntry.func_74782_a("v", MtsToNbtSerializer.serialize(value));
            tag.func_74742_a((NBTBase)listEntry);
        }
        for (MtsTable.Entry entry : table.entryView()) {
            if (!MtsToNbtSerializer.isSerializeableTableKey(entry.getKey())) continue;
            NBTTagCompound listEntry = new NBTTagCompound();
            listEntry.func_74782_a("k", MtsToNbtSerializer.serialize(entry.getKey()));
            listEntry.func_74782_a("v", MtsToNbtSerializer.serialize(entry.getValue()));
            tag.func_74742_a((NBTBase)listEntry);
        }
        return tag;
    }

    private static boolean isSerializeableTableKey(MtsValue key) {
        return key.isNumber() || key.isString() || key.isBoolean();
    }

    public static MtsValue deserialize(NBTBase tag) {
        if (tag instanceof NBTTagInt) {
            return MtsToNbtSerializer.deserialize((NBTTagInt)tag);
        }
        if (tag instanceof NBTTagDouble) {
            return MtsToNbtSerializer.deserialize((NBTTagDouble)tag);
        }
        if (tag instanceof NBTTagByte) {
            return MtsToNbtSerializer.deserialize((NBTTagByte)tag);
        }
        if (tag instanceof NBTTagString) {
            return MtsToNbtSerializer.deserialize((NBTTagString)tag);
        }
        if (tag instanceof NBTTagList) {
            return MtsToNbtSerializer.deserialize((NBTTagList)tag);
        }
        throw new IllegalArgumentException("Unknown tag type: " + tag.getClass());
    }

    public static MtsBoolean deserialize(NBTTagByte tag) {
        return MtsValue.valueOf(tag.func_150287_d() != 0);
    }

    public static MtsNumber deserialize(NBTTagInt tag) {
        return MtsValue.valueOf(tag.func_150287_d());
    }

    public static MtsNumber deserialize(NBTTagDouble tag) {
        return MtsValue.valueOf(tag.func_150286_g());
    }

    public static MtsString deserialize(NBTTagString tag) {
        return MtsValue.valueOf(tag.func_150285_a_());
    }

    public static MtsTable deserialize(NBTTagList list) {
        MtsTable t = new MtsTable();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            MtsValue key = MtsToNbtSerializer.deserialize(entry.func_74781_a("k"));
            MtsValue value = MtsToNbtSerializer.deserialize(entry.func_74781_a("v"));
            t.set(key, value);
        }
        return t;
    }

    private MtsToNbtSerializer() {
    }
}

