/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;

public class EntityUtil {
    private static Map<Class<? extends EntityLiving>, Function<EntityLiving, String>> _nameFunctions = Maps.newHashMap();
    private static Map<Class<? extends EntityLiving>, Predicate<EntityLiving>> _childPredicates = Maps.newHashMap();
    private static Map<Integer, Function<EntityVillager, String>> _professionFunctions = Maps.newHashMap();

    public static void registerNameFunction(Class<? extends EntityLiving> entityType, Function<EntityLiving, String> function) {
        _nameFunctions.put(entityType, function);
    }

    public static String getName(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return EntityUtil.getName((EntityPlayer)entity);
        }
        if (entity instanceof EntityLiving) {
            return EntityUtil.getName((EntityLiving)entity);
        }
        throw new IllegalArgumentException("unknown entity type '" + entity.getClass() + "'");
    }

    public static String getName(EntityPlayer player) {
        return player.getDisplayName();
    }

    public static String getName(EntityLiving entity) {
        Class<?> entityType = entity.getClass();
        Function<EntityLiving, String> function = _nameFunctions.get(entityType);
        return function != null ? (String)function.apply((Object)entity) : EntityList.func_75621_b((Entity)entity);
    }

    public static void registerChildPredicate(Class<? extends EntityLiving> entityType, Predicate<EntityLiving> predicate) {
        _childPredicates.put(entityType, predicate);
    }

    public static boolean isChild(EntityLiving entity) {
        Class<?> entityType = entity.getClass();
        Predicate<EntityLiving> predicate = _childPredicates.get(entityType);
        return predicate != null && predicate.apply((Object)entity);
    }

    public static void registerProfessionFunction(int profession, Function<EntityVillager, String> function) {
        _professionFunctions.put(profession, function);
    }

    public static String getProfession(EntityLiving entity) {
        EntityVillager villager = (EntityVillager)entity;
        int profession = villager.func_70946_n();
        Function<EntityVillager, String> function = _professionFunctions.get(profession);
        return function != null ? (String)function.apply((Object)villager) : null;
    }

    static {
        EntityUtil.registerNameFunction(EntitySkeleton.class, new SkeletonNameFunction());
        EntityUtil.registerNameFunction(EntityZombie.class, new ZombieNameFunction());
        EntityUtil.registerChildPredicate(EntityZombie.class, new ZombieChildPredicate());
        EntityUtil.registerChildPredicate(EntityVillager.class, new VillagerChildPredicate());
        VanillaVillagerProfessionFunction f = new VanillaVillagerProfessionFunction();
        EntityUtil.registerProfessionFunction(0, f);
        EntityUtil.registerProfessionFunction(1, f);
        EntityUtil.registerProfessionFunction(2, f);
        EntityUtil.registerProfessionFunction(3, f);
        EntityUtil.registerProfessionFunction(4, f);
    }

    private static class VanillaVillagerProfessionFunction
    implements Function<EntityVillager, String> {
        private static final String[] names = new String[]{"Farmer", "Librarian", "Priest", "Blacksmith", "Butcher"};

        private VanillaVillagerProfessionFunction() {
        }

        public String apply(EntityVillager villager) {
            return names[villager.func_70946_n()];
        }
    }

    private static final class VillagerChildPredicate
    implements Predicate<EntityLiving> {
        private VillagerChildPredicate() {
        }

        public boolean apply(EntityLiving entity) {
            return ((EntityVillager)entity).func_70631_g_();
        }
    }

    private static final class ZombieChildPredicate
    implements Predicate<EntityLiving> {
        private ZombieChildPredicate() {
        }

        public boolean apply(EntityLiving entity) {
            return ((EntityZombie)entity).func_70631_g_();
        }
    }

    private static final class ZombieNameFunction
    implements Function<EntityLiving, String> {
        private ZombieNameFunction() {
        }

        public String apply(EntityLiving entity) {
            EntityZombie zombie = (EntityZombie)entity;
            return zombie.func_82231_m() ? "Zombie Villager" : "Zombie";
        }
    }

    private static class SkeletonNameFunction
    implements Function<EntityLiving, String> {
        private SkeletonNameFunction() {
        }

        public String apply(EntityLiving entity) {
            EntitySkeleton skeleton = (EntitySkeleton)entity;
            return skeleton.func_82202_m() == 1 ? "Wither Skeleton" : "Skeleton";
        }
    }
}

