/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.util.logging;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Objects;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.mobtalker.mobtalker2.util.logging.AbstractMobTalkerLog;

public class FileLogger
extends AbstractMobTalkerLog {
    private final Logger _log;
    private final Handler _fileHandler;

    public FileLogger(String name, File logFile) {
        this._log = Logger.getLogger(name);
        this._log.setUseParentHandlers(false);
        try {
            logFile.getParentFile().mkdirs();
            this._fileHandler = new TheHandler(logFile.getPath(), 0, 1);
            this._fileHandler.setEncoding("UTF-8");
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        this._fileHandler.setFormatter(new TheFormatter());
        this._log.addHandler(this._fileHandler);
    }

    public void setLevel(String level) {
        Level levelObj = Level.parse(level);
        this._log.setLevel(levelObj);
        this._fileHandler.setLevel(levelObj);
    }

    @Override
    public boolean isTraceEnabled() {
        return this._log.isLoggable(Level.FINER);
    }

    @Override
    public boolean isDebugEnabled() {
        return this._log.isLoggable(Level.FINE);
    }

    private void log(Level level, String tag, Object obj) {
        this._log.log(level, "[" + tag + "] " + Objects.toString(obj));
    }

    private void log(Level level, String tag, Object obj, Throwable ex) {
        this._log.log(level, "[" + tag + "] " + Objects.toString(obj), ex);
    }

    @Override
    public void fatal(String tag, Object obj) {
        this.log(Level.SEVERE, tag, obj);
    }

    @Override
    public void fatal(String tag, String msg, Throwable ex) {
        this.log(Level.SEVERE, tag, msg, ex);
    }

    @Override
    public void error(String tag, Object obj) {
        this.log(Level.SEVERE, tag, obj);
    }

    @Override
    public void error(String tag, String msg, Throwable ex) {
        this.log(Level.SEVERE, tag, msg, ex);
    }

    @Override
    public void warn(String tag, Object obj) {
        this.log(Level.WARNING, tag, obj);
    }

    @Override
    public void warn(String tag, String msg, Throwable ex) {
        this.log(Level.WARNING, tag, msg, ex);
    }

    @Override
    public void info(String tag, Object obj) {
        this.log(Level.INFO, tag, obj);
    }

    @Override
    public void info(String tag, String msg, Throwable ex) {
        this.log(Level.INFO, tag, msg, ex);
    }

    @Override
    public void debug(String tag, Object obj) {
        this.log(Level.FINE, tag, obj);
    }

    @Override
    public void debug(String tag, String msg, Throwable ex) {
        this.log(Level.FINE, tag, msg, ex);
    }

    @Override
    public void trace(String tag, Object obj) {
        this.log(Level.FINER, tag, obj);
    }

    @Override
    public void trace(String tag, String msg, Throwable ex) {
        this.log(Level.FINER, tag, msg, ex);
    }

    private static final class TheFormatter
    extends Formatter {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");

        private TheFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder msg = new StringBuilder();
            msg.append(dateFormat.format(record.getMillis()));
            Level lvl = record.getLevel();
            String lvlName = lvl.getLocalizedName();
            if (lvlName == null) {
                lvlName = lvl.getName();
            }
            if (lvlName != null && lvlName.length() > 0) {
                msg.append(" [").append(lvlName).append("] ");
            } else {
                msg.append(" ");
            }
            msg.append(this.formatMessage(record));
            msg.append(LINE_SEPARATOR);
            Throwable thr = record.getThrown();
            if (thr != null) {
                StringWriter thrDump = new StringWriter();
                thr.printStackTrace(new PrintWriter(thrDump));
                msg.append(thrDump.toString());
            }
            return msg.toString();
        }
    }

    private static final class TheHandler
    extends FileHandler {
        public TheHandler(String pattern, int limit, int count) throws IOException, SecurityException {
            super(pattern, limit, count);
        }

        @Override
        public synchronized void close() throws SecurityException {
        }
    }
}

