/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.util.mgt;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.mobtalker.mobtalker2.util.mgt.AlignmentX;
import net.mobtalker.mobtalker2.util.mgt.MGComponent;

@SideOnly(value=Side.CLIENT)
public class MGTextArea
extends MGComponent {
    public static final String lorum = "Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex ea commodo consequat.";
    protected int _lineCount;
    protected int _lineHeight;
    protected int _lineSpacing;
    protected boolean _dropShadow;
    protected String _text;
    protected final List<String> _lines;
    protected AlignmentX _textAlignment;
    protected boolean _enableScrolling;
    protected int _scrollingSpeed;
    protected boolean _isScrolling;
    protected int _scrollingRow;
    protected int _scrollingCol;

    public MGTextArea(int id) {
        super(id);
        this.setWidth(100);
        this._lines = new ArrayList<String>(1);
        this.setLineCount(1);
        this.setLineSpacing(2);
        this._dropShadow = false;
        this._textAlignment = AlignmentX.LEFT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doDraw() {
        int yOffset = 0;
        int linesToDisplay = this._isScrolling ? this._scrollingRow : this._lines.size();
        FontRenderer renderer = MGTextArea.getFontRenderer();
        for (int i = 0; i < linesToDisplay; ++i) {
            int left;
            String line = this._lines.get(i);
            if (this._textAlignment != AlignmentX.LEFT) {
                int lineWidth = renderer.func_78256_a(line);
                if (this._textAlignment == AlignmentX.CENTER) {
                    left = this.getBounds().getLeft() + (this.getBounds().getWidth() - lineWidth) / 2;
                } else {
                    if (this._textAlignment != AlignmentX.RIGHT) throw new AssertionError();
                    left = this.getBounds().getRight() - lineWidth;
                }
            } else {
                left = this.getBounds().getLeft();
            }
            if (this._isScrolling && i == linesToDisplay - 1) {
                line = line.substring(0, this._scrollingCol);
            }
            renderer.func_85187_a(line, left, this.getBounds().getTop() + yOffset, -1, this._dropShadow);
            yOffset += this._lineHeight;
        }
    }

    @Override
    public void update() {
        if (!this._isScrolling) {
            return;
        }
        this._scrollingCol += this._scrollingSpeed;
        if (this._scrollingCol > this._lines.get(this._scrollingRow - 1).length()) {
            ++this._scrollingRow;
            this._scrollingCol = 1;
        }
        if (this._scrollingRow > this._lines.size()) {
            this._isScrolling = false;
        }
    }

    public AlignmentX getTextAlignment() {
        return this._textAlignment;
    }

    public String getText() {
        return this._text;
    }

    public int getLineCount() {
        return this._lineCount;
    }

    public int getLineSpacing() {
        return this._lineSpacing;
    }

    public int getLineHeight() {
        return this._lineHeight;
    }

    public boolean getDropShadow() {
        return this._dropShadow;
    }

    public boolean isScrollingEnabled() {
        return this._enableScrolling;
    }

    public int getScrollingSpeed() {
        return this._scrollingSpeed;
    }

    public void setTextAlignment(AlignmentX textAlignment) {
        this._textAlignment = textAlignment;
    }

    public void setText(String text) {
        this._text = text;
        this._lines.clear();
        if (text != null && !text.isEmpty()) {
            List formattedLines = MGTextArea.getFontRenderer().func_78271_c(text, this.getBounds().getWidth());
            int lineCount = Math.min(this._lineCount, formattedLines.size());
            for (int i = 0; i < lineCount; ++i) {
                this._lines.add((String)formattedLines.get(i));
            }
            if (this._enableScrolling) {
                this._scrollingRow = 1;
                this._scrollingCol = 1;
                this._isScrolling = true;
            }
        }
    }

    public void setLineCount(int count) {
        this._lineCount = count;
        super.setHeight(this._lineCount * this._lineHeight - this._lineSpacing);
        if (this._text != null) {
            this.setText(this._text);
        }
    }

    public void setLineSpacing(int spacing) {
        this._lineSpacing = spacing;
        this._lineHeight = MGTextArea.getFontRenderer().field_78288_b + this._lineSpacing;
        super.setHeight(this._lineCount * this._lineHeight - this._lineSpacing);
    }

    public void setDropShadow(boolean dropShadow) {
        this._dropShadow = dropShadow;
    }

    @Override
    public void setHeight(int height) {
        throw new UnsupportedOperationException("Cannot set the height of an text area directly. Use setLineCount and setLineSpacing instead.");
    }

    public void setScrolling(boolean enableScrolling) {
        this._enableScrolling = enableScrolling;
        if (!this._enableScrolling) {
            this._isScrolling = false;
        }
    }

    public void setScrollingSpeed(int speed) {
        this._scrollingSpeed = speed;
    }
}

