/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.util.mgt;

import com.google.common.math.DoubleMath;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.RoundingMode;

@SideOnly(value=Side.CLIENT)
public class Rectangle {
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected int width;
    protected int height;

    public Rectangle(int left, int right, int top, int bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.width = right - left;
        this.height = bottom - top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getCenterX() {
        return this.left + DoubleMath.roundToInt((double)((double)this.width / 2.0), (RoundingMode)RoundingMode.CEILING);
    }

    public int getCenterY() {
        return this.top + DoubleMath.roundToInt((double)((double)this.height / 2.0), (RoundingMode)RoundingMode.CEILING);
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRight() {
        return this.right;
    }

    public boolean contains(int x, int y) {
        return this.left <= x && x <= this.right && this.top <= y && y <= this.bottom;
    }

    public String toString() {
        return String.format("Rectangle [Left=%s, Right=%s, Top=%s, Bottom=%s, Width=%s, Height=%s]", this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getWidth(), this.getHeight());
    }
}

