/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.compiler;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.mobtalker.mobtalkerscript.v2.LocalDescription;
import net.mobtalker.mobtalkerscript.v2.ScriptParserException;

public class BlockScope {
    private final BlockScope _parent;
    private final List<LocalDescription> _locals = Lists.newArrayList();

    public BlockScope() {
        this(null);
    }

    public BlockScope(BlockScope blockScope) {
        this._parent = blockScope;
    }

    public BlockScope getParent() {
        return this._parent;
    }

    private boolean contains(String string) {
        Iterator<LocalDescription> iterator = this._locals.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean canDeclare(String string) {
        return !this.contains(string);
    }

    public void declare(LocalDescription localDescription) {
        if (!this.canDeclare(localDescription.getName())) {
            throw new ScriptParserException("Tried to declare local variable '%s' twice", localDescription.getName());
        }
        this._locals.add(localDescription);
    }

    public boolean isLocal(String string) {
        return this.contains(string) || this._parent != null && this._parent.isLocal(string);
    }

    public LocalDescription getLocal(String string) {
        for (LocalDescription localDescription : this._locals) {
            if (!localDescription.getName().equals(string)) continue;
            return localDescription;
        }
        if (this._parent == null) {
            throw new IllegalArgumentException();
        }
        return this._parent.getLocal(string);
    }

    public int getIndex(String string) {
        for (LocalDescription localDescription : this._locals) {
            if (!localDescription.getName().equals(string)) continue;
            return localDescription.getIndex();
        }
        if (this._parent == null) {
            throw new IllegalArgumentException();
        }
        return this._parent.getIndex(string);
    }
}

