/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.compiler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.mobtalker.mobtalkerscript.util.Stack;
import net.mobtalker.mobtalkerscript.v2.ExternalDescription;
import net.mobtalker.mobtalkerscript.v2.LocalDescription;
import net.mobtalker.mobtalkerscript.v2.MtsFunctionPrototype;
import net.mobtalker.mobtalkerscript.v2.compiler.BlockScope;
import net.mobtalker.mobtalkerscript.v2.compiler.CompilerLabel;
import net.mobtalker.mobtalkerscript.v2.compiler.ConditionalState;
import net.mobtalker.mobtalkerscript.v2.compiler.LoopState;
import net.mobtalker.mobtalkerscript.v2.compiler.PendingJump;
import net.mobtalker.mobtalkerscript.v2.compiler.SourcePosition;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrJump;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrTest;
import net.mobtalker.mobtalkerscript.v2.instruction.Instructions;
import net.mobtalker.mobtalkerscript.v2.instruction.MtsInstruction;
import net.mobtalker.mobtalkerscript.v2.instruction.MtsJumpInstruction;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;

public class FunctionState {
    private final FunctionState _parent;
    private final List<FunctionState> _childs = Lists.newArrayList();
    private final List<MtsValue> _constants = Lists.newArrayList();
    private final List<LocalDescription> _locals = Lists.newArrayList();
    private final List<ExternalDescription> _externals = Lists.newArrayList();
    private final LinkedList<MtsInstruction> _instructions = Lists.newLinkedList();
    private final Queue<PendingJump> _pendingJumps = Lists.newLinkedList();
    private final Map<String, CompilerLabel> _labels = Maps.newHashMapWithExpectedSize((int)2);
    private final String _name;
    private final String _sourceFile;
    private final int _sourceLineStart;
    private final int _sourceLineEnd;
    private final LinkedList<SourcePosition> _lineNumbers = Lists.newLinkedList();
    private BlockScope _block = new BlockScope();
    private final Stack<LoopState> _loops = Stack.newStack();
    private final Stack<ConditionalState> _ifElses = Stack.newStack();

    public FunctionState(FunctionState functionState, String string, String string2, int n, int n2) {
        this._parent = functionState;
        this._name = string;
        this._sourceFile = string2;
        this._sourceLineStart = n;
        this._sourceLineEnd = n2;
    }

    public FunctionState getParent() {
        return this._parent;
    }

    public int addChild(FunctionState functionState) {
        this._childs.add(functionState);
        return this._childs.size() - 1;
    }

    public List<FunctionState> getChilds() {
        return this._childs;
    }

    private int addInstruction(MtsInstruction mtsInstruction) {
        return this.addInstruction(mtsInstruction, this._lineNumbers.getLast());
    }

    public int addInstruction(MtsInstruction mtsInstruction, SourcePosition sourcePosition) {
        this._instructions.add(mtsInstruction);
        this._lineNumbers.add(sourcePosition);
        return this.currentIndex();
    }

    public int currentIndex() {
        return this._instructions.size() - 1;
    }

    public void addLabel(String string) {
        CompilerLabel compilerLabel = this._labels.get(string);
        if (compilerLabel == null) {
            compilerLabel = new CompilerLabel();
            this._labels.put(string, compilerLabel);
        } else {
            Preconditions.checkArgument((compilerLabel.getTarget() != 0 ? 1 : 0) != 0, (String)"label '%s' already exists", (Object[])new Object[]{string});
        }
        compilerLabel.setTarget(this.currentIndex() + 1);
    }

    public CompilerLabel getLabel(String string) {
        CompilerLabel compilerLabel = this._labels.get(string);
        if (compilerLabel == null) {
            compilerLabel = new CompilerLabel();
            this._labels.put(string, compilerLabel);
        }
        return compilerLabel;
    }

    public void gotoLabel(String string) {
        CompilerLabel compilerLabel = this.getLabel(string);
        InstrJump instrJump = Instructions.InstrJump();
        int n = this.addInstruction(instrJump);
        compilerLabel.addGoto(new PendingJump(instrJump, n));
    }

    public void enterBlock() {
        this._block = new BlockScope(this._block);
    }

    public void exitBlock() {
        Preconditions.checkNotNull((Object)this._block.getParent(), (Object)"Tried to leave function scope!");
        this._block = this._block.getParent();
    }

    public void enterLoop() {
        this._loops.push(new LoopState(this.currentIndex() + 1));
    }

    public void markBreak() {
        Preconditions.checkState((!this._loops.isEmpty() ? 1 : 0) != 0, (Object)"There is no loop to break!");
        Preconditions.checkState((boolean)(this._instructions.getLast() instanceof MtsJumpInstruction), (Object)"Last added instruction is not a jump instruction!");
        LoopState loopState = this._loops.peek();
        MtsJumpInstruction mtsJumpInstruction = (MtsJumpInstruction)this._instructions.getLast();
        loopState.addBreak(new PendingJump(mtsJumpInstruction, this.currentIndex()));
    }

    public void exitLoop() {
        Preconditions.checkState((!this._loops.isEmpty() ? 1 : 0) != 0, (Object)"There is no loop to exit!");
        Preconditions.checkState((boolean)(this._instructions.getLast() instanceof MtsJumpInstruction), (Object)"Last added instruction is not a jump instruction!");
        LoopState loopState = this._loops.pop();
        ((MtsJumpInstruction)this._instructions.getLast()).setTarget(this.currentIndex(), loopState.firstIndex());
        loopState.setBreakTarget(this.currentIndex() + 1);
    }

    public void enterNumericForLoop(String string) {
        int n = this.declareLocal(string).getIndex();
        int n2 = this.declareAnonymousLocal("limit").getIndex();
        int n3 = this.declareAnonymousLocal("step").getIndex();
        assert (n3 == n2 + 1 && n2 == n + 1) : String.format("Loop variable indices are not consecutive! (%s,%s,%s)", n, n2, n3);
        this.addInstruction(Instructions.InstrNForPrep(n));
        this.enterLoop();
        this.addInstruction(Instructions.InstrNForLoop(n));
        this.markBreak();
    }

    public void enterGenericForLoop(String ... stringArray) {
        int n = this.declareAnonymousLocal("iter").getIndex();
        int n2 = this.declareAnonymousLocal("state").getIndex();
        int n3 = this.declareAnonymousLocal("index").getIndex();
        assert (n3 == n2 + 1 && n2 == n + 1) : String.format("Loop variable indices are not consecutive! (%s,%s,%s)", n, n2, n3);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n4 = this.declareLocal(string).getIndex();
            assert (n4 - i - 1 == n3) : "Loop variable indices are not consecutive!";
        }
        this.addInstruction(Instructions.InstrStoreL(n3));
        this.addInstruction(Instructions.InstrStoreL(n2));
        this.addInstruction(Instructions.InstrStoreL(n));
        this.enterLoop();
        this.addInstruction(Instructions.InstrGForLoop(n, stringArray.length));
        this.markBreak();
    }

    public void enterIfThenElse() {
        this._ifElses.push(new ConditionalState());
    }

    public void enterIfCondition() {
        Preconditions.checkState((!this._ifElses.isEmpty() ? 1 : 0) != 0, (Object)"Not inside an IfThenElse!");
        this._ifElses.peek().markBeginNext(this.currentIndex() + 1);
    }

    public void endIfCondition() {
        Preconditions.checkState((!this._ifElses.isEmpty() ? 1 : 0) != 0, (Object)"Not inside an IfThenElse!");
        ConditionalState conditionalState = this._ifElses.peek();
        InstrTest instrTest = Instructions.InstrTest();
        this.addInstruction(instrTest);
        conditionalState.setPendingNext(new PendingJump(instrTest, this.currentIndex()));
    }

    public void endThenBlock() {
        Preconditions.checkState((!this._ifElses.isEmpty() ? 1 : 0) != 0, (Object)"Not inside an IfThenElse!");
        ConditionalState conditionalState = this._ifElses.peek();
        InstrJump instrJump = Instructions.InstrJump();
        this.addInstruction(instrJump);
        conditionalState.addPendingExit(new PendingJump(instrJump, this.currentIndex()));
    }

    public void enterElseBlock() {
        Preconditions.checkState((!this._ifElses.isEmpty() ? 1 : 0) != 0, (Object)"Not inside an IfThenElse!");
        this._ifElses.peek().markBeginNext(this.currentIndex() + 1);
    }

    public void exitIfThenElse() {
        Preconditions.checkState((!this._ifElses.isEmpty() ? 1 : 0) != 0, (Object)"Not inside an IfThenElse!");
        this._ifElses.pop().setExitTarget(this.currentIndex() + 1);
    }

    public void markPendingJump() {
        Preconditions.checkState((boolean)(this._instructions.getLast() instanceof MtsJumpInstruction), (Object)"Last added instruction is not a jump instruction!");
        MtsJumpInstruction mtsJumpInstruction = (MtsJumpInstruction)this._instructions.getLast();
        this._pendingJumps.add(new PendingJump(mtsJumpInstruction, this.currentIndex()));
    }

    public void setPendingJump() {
        Preconditions.checkState((!this._pendingJumps.isEmpty() ? 1 : 0) != 0, (Object)"There is no pending jump!");
        this._pendingJumps.remove().setTarget(this.currentIndex());
    }

    public void setPendingJump(int n) {
        Preconditions.checkState((!this._pendingJumps.isEmpty() ? 1 : 0) != 0, (Object)"There is no pending jump!");
        this._pendingJumps.remove().setTarget(this.currentIndex() + n);
    }

    public int getConstantIndex(MtsValue mtsValue) {
        int n = this._constants.indexOf(mtsValue);
        if (n < 0) {
            this._constants.add(mtsValue);
            n = this._constants.size() - 1;
        }
        return n;
    }

    public boolean isLocal(String string) {
        return this._block.isLocal(string);
    }

    public LocalDescription declareLocal(String string) {
        int n = this._locals.size();
        LocalDescription localDescription = new LocalDescription(string, n, this.currentIndex());
        this._locals.add(localDescription);
        this._block.declare(localDescription);
        return localDescription;
    }

    public LocalDescription declareAnonymousLocal(String string) {
        int n = this._locals.size();
        LocalDescription localDescription = new LocalDescription("$" + string, n, this.currentIndex());
        this._locals.add(localDescription);
        return localDescription;
    }

    public int getLocalIndex(String string) {
        LocalDescription localDescription = this._block.getLocal(string);
        localDescription.setEnd(this._instructions.size() - 1);
        return localDescription.getIndex();
    }

    public int getExternalIndex(String string) {
        int n;
        for (n = 0; n < this._externals.size(); ++n) {
            if (!this._externals.get(n).getName().equals(string)) continue;
            return n;
        }
        Preconditions.checkArgument((this._parent != null ? 1 : 0) != 0, (Object)(string + " is a global!"));
        n = this._externals.size();
        boolean bl = this._parent.isLocal(string);
        int n2 = bl ? this._parent.getLocalIndex(string) : this._parent.getExternalIndex(string);
        this._externals.add(new ExternalDescription(string, n, n2, bl));
        return n;
    }

    public boolean isExternal(String string) {
        if (this.isLocal(string)) {
            return false;
        }
        Iterator<ExternalDescription> iterator = this._externals.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getName().equals(string)) continue;
            return true;
        }
        if (this._parent == null) {
            return false;
        }
        return this._parent.isLocal(string) || this._parent.isExternal(string);
    }

    public void addExternal(ExternalDescription externalDescription) {
        this._externals.add(externalDescription);
    }

    private int calculateMaxStackSize() {
        int n = 0;
        int n2 = 0;
        for (MtsInstruction mtsInstruction : this._instructions) {
            n2 = Math.max(n += mtsInstruction.stackSizeChange(), n2);
        }
        return n2;
    }

    public MtsFunctionPrototype createPrototype() {
        Preconditions.checkState((this._block.getParent() == null ? 1 : 0) != 0, (Object)"Not in the outermost function scope!");
        Preconditions.checkState((boolean)this._pendingJumps.isEmpty(), (Object)"Didn't close all pending jumps!");
        Preconditions.checkState((boolean)this._loops.isEmpty(), (Object)"Didn't close all loops!");
        Preconditions.checkState((boolean)this._ifElses.isEmpty(), (Object)"Didn't close all IfElse!");
        for (Map.Entry<String, CompilerLabel> entry : this._labels.entrySet()) {
            if (entry.getValue().getTarget() != 0) continue;
            throw new IllegalStateException("unknown label '" + entry.getKey() + "'");
        }
        MtsFunctionPrototype mtsFunctionPrototype = new MtsFunctionPrototype((List<MtsInstruction>)ImmutableList.copyOf(this._instructions), this.calculateMaxStackSize(), (List<MtsValue>)ImmutableList.copyOf(this._constants), (List<ExternalDescription>)ImmutableList.copyOf(this._externals), (List<LocalDescription>)ImmutableList.copyOf(this._locals), this._name, (List<SourcePosition>)ImmutableList.copyOf(this._lineNumbers), this._sourceFile, this._sourceLineStart, this._sourceLineEnd);
        for (FunctionState functionState : this._childs) {
            mtsFunctionPrototype.addNestedPrototype(functionState.createPrototype());
        }
        return mtsFunctionPrototype;
    }
}

