/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.instruction;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrAdd;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrAnd;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrCall;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrClosure;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrConcat;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrDiv;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrDup;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrEQ;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrGForLoop;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrJump;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrLT;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrLTE;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrLoadC;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrLoadE;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrLoadL;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrLoadM;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrLoadNil;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrLoadT;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrMod;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrMul;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrNForLoop;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrNForPrep;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrNeg;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrNewTable;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrNot;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrOr;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrPop;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrPow;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrReturn;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrSize;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrStoreE;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrStoreL;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrStoreT;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrSub;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrTailcall;
import net.mobtalker.mobtalkerscript.v2.instruction.InstrTest;
import net.mobtalker.mobtalkerscript.v2.instruction.MtsInstruction;

public class Instructions {
    private static final Map<String, MtsInstruction> _unaryOps;
    private static final InstrNeg _neg;
    private static final InstrNot _not;
    private static final InstrSize _size;
    private static final Map<String, MtsInstruction> _binaryOps;
    private static final InstrAdd _add;
    private static final InstrSub _sub;
    private static final InstrMul _mul;
    private static final InstrDiv _div;
    private static final InstrMod _mod;
    private static final InstrPow _pow;
    private static final InstrConcat[] _concat;
    private static final Map<String, MtsInstruction> _logicalOps;
    private static final InstrEQ _eq;
    private static final InstrLT _lt;
    private static final InstrLTE _lte;
    private static final Map<String, MtsInstruction> _assignOps;
    private static final InstrDup _dup;
    private static final InstrPop _pop;
    private static final InstrLoadT _loadT;
    private static final InstrStoreT _storeT;
    private static final InstrLoadL[] _loadL;
    private static final InstrLoadE[] _loadE;
    private static final InstrLoadC[] _loadC;
    private static final InstrLoadNil _loadNil;
    private static final InstrStoreL[] _storeL;
    private static final InstrStoreE[] _storeE;
    private static final InstrReturn[] _return;

    public static MtsInstruction InstrUnaryOp(String string) {
        MtsInstruction mtsInstruction = _unaryOps.get(string);
        Preconditions.checkArgument((mtsInstruction != null ? 1 : 0) != 0, (Object)"%s is not a valid unary operator!");
        return mtsInstruction;
    }

    public static MtsInstruction InstrBinaryOp(String string) {
        MtsInstruction mtsInstruction = _binaryOps.get(string);
        Preconditions.checkArgument((mtsInstruction != null ? 1 : 0) != 0, (String)"%s is not a valid binary operator!", (Object[])new Object[]{string});
        return mtsInstruction;
    }

    public static MtsInstruction InstrLogicalOp(String string) {
        MtsInstruction mtsInstruction = _logicalOps.get(string);
        Preconditions.checkArgument((mtsInstruction != null ? 1 : 0) != 0, (Object)"%s is not a valid logic operator!");
        return mtsInstruction;
    }

    public static InstrAnd InstrAnd() {
        return new InstrAnd();
    }

    public static InstrAnd InstrAnd(int n) {
        return new InstrAnd(n);
    }

    public static InstrOr InstrOr() {
        return new InstrOr();
    }

    public static InstrOr InstrOr(int n) {
        return new InstrOr(n);
    }

    public static InstrTest InstrTest() {
        return new InstrTest();
    }

    public static InstrTest InstrTest(int n) {
        return new InstrTest(n);
    }

    public static InstrJump InstrJump() {
        return new InstrJump();
    }

    public static InstrJump InstrJump(int n) {
        return new InstrJump(n);
    }

    public static InstrLoadL InstrLoadL(int n) {
        if (n < 20) {
            return _loadL[n];
        }
        return new InstrLoadL(n);
    }

    public static InstrLoadE InstrLoadE(int n) {
        if (n < 20) {
            return _loadE[n];
        }
        return new InstrLoadE(n);
    }

    public static InstrLoadC InstrLoadC(int n) {
        if (n < 100) {
            return _loadC[n];
        }
        return new InstrLoadC(n);
    }

    public static InstrLoadNil InstrLoadNil() {
        return _loadNil;
    }

    public static InstrStoreL InstrStoreL(int n) {
        if (n < 20) {
            return _storeL[n];
        }
        return new InstrStoreL(n);
    }

    public static InstrStoreE InstrStoreE(int n) {
        if (n < 20) {
            return _storeE[n];
        }
        return new InstrStoreE(n);
    }

    public static InstrNewTable InstrNewTable(int n, int n2) {
        return new InstrNewTable(n, n2);
    }

    public static InstrLoadT InstrLoadT() {
        return _loadT;
    }

    public static InstrLoadM InstrLoadM(int n) {
        return new InstrLoadM(n);
    }

    public static InstrStoreT InstrStoreT() {
        return _storeT;
    }

    public static InstrNeg InstrNeg() {
        return _neg;
    }

    public static InstrNot InstrNot() {
        return _not;
    }

    public static InstrSize InstrSize() {
        return _size;
    }

    public static InstrAdd InstrAdd() {
        return _add;
    }

    public static InstrSub InstrSub() {
        return _sub;
    }

    public static InstrMul InstrMul() {
        return _mul;
    }

    public static InstrDiv InstrDiv() {
        return _div;
    }

    public static InstrMod InstrMod() {
        return _mod;
    }

    public static InstrPow InstrPow() {
        return _pow;
    }

    public static InstrConcat InstrConcat(int n) {
        if (n < 10) {
            return _concat[n];
        }
        return new InstrConcat(n);
    }

    public static InstrEQ InstrEq() {
        return _eq;
    }

    public static InstrLT InstrLt() {
        return _lt;
    }

    public static InstrLTE InstrLte() {
        return _lte;
    }

    public static InstrDup InstrDup() {
        return _dup;
    }

    public static InstrPop InstrPop() {
        return _pop;
    }

    public static InstrClosure InstrClosure(int n) {
        return new InstrClosure(n);
    }

    public static InstrCall InstrCall(int n, int n2) {
        return new InstrCall(n, n2);
    }

    public static InstrReturn InstrReturn(int n) {
        if (n < 5) {
            return _return[n];
        }
        return new InstrReturn(n);
    }

    public static InstrTailcall InstrTailcall(int n, int n2) {
        return new InstrTailcall(n, n2);
    }

    public static InstrNForPrep InstrNForPrep(int n) {
        return new InstrNForPrep(n);
    }

    public static InstrNForLoop InstrNForLoop(int n) {
        return new InstrNForLoop(n);
    }

    public static InstrNForLoop InstrNForLoop(int n, int n2) {
        return new InstrNForLoop(n, n2);
    }

    public static InstrGForLoop InstrGForLoop(int n, int n2) {
        return new InstrGForLoop(n, n2);
    }

    public static InstrGForLoop InstrGForLoop(int n, int n2, int n3) {
        return new InstrGForLoop(n, n2, n3);
    }

    private Instructions() {
    }

    static {
        int n;
        _neg = new InstrNeg();
        _not = new InstrNot();
        _size = new InstrSize();
        _add = new InstrAdd();
        _sub = new InstrSub();
        _mul = new InstrMul();
        _div = new InstrDiv();
        _mod = new InstrMod();
        _pow = new InstrPow();
        _eq = new InstrEQ();
        _lt = new InstrLT();
        _lte = new InstrLTE();
        _dup = new InstrDup();
        _pop = new InstrPop();
        _loadT = new InstrLoadT();
        _storeT = new InstrStoreT();
        _loadNil = new InstrLoadNil();
        _unaryOps = Maps.newHashMapWithExpectedSize((int)3);
        _unaryOps.put("-", Instructions.InstrNeg());
        _unaryOps.put("not", Instructions.InstrNot());
        _unaryOps.put("#", Instructions.InstrSize());
        _binaryOps = Maps.newHashMapWithExpectedSize((int)6);
        _binaryOps.put("+", Instructions.InstrAdd());
        _binaryOps.put("-", Instructions.InstrSub());
        _binaryOps.put("*", Instructions.InstrMul());
        _binaryOps.put("/", Instructions.InstrDiv());
        _binaryOps.put("%", Instructions.InstrMod());
        _binaryOps.put("^", Instructions.InstrPow());
        _concat = new InstrConcat[10];
        for (n = 0; n < 10; ++n) {
            Instructions._concat[n] = new InstrConcat(n);
        }
        _binaryOps.put("..", Instructions.InstrConcat(2));
        _logicalOps = Maps.newHashMapWithExpectedSize((int)3);
        _logicalOps.put("==", Instructions.InstrEq());
        _logicalOps.put("<", Instructions.InstrLt());
        _logicalOps.put("<=", Instructions.InstrLte());
        _assignOps = Maps.newHashMapWithExpectedSize((int)6);
        _assignOps.put("+=", Instructions.InstrAdd());
        _assignOps.put("-=", Instructions.InstrSub());
        _assignOps.put("*=", Instructions.InstrMul());
        _assignOps.put("/=", Instructions.InstrDiv());
        _assignOps.put("%=", Instructions.InstrMod());
        _assignOps.put("^=", Instructions.InstrPow());
        _loadL = new InstrLoadL[20];
        _storeL = new InstrStoreL[20];
        n = 0;
        while (true) {
            if (n >= 20) break;
            Instructions._loadL[n] = new InstrLoadL(n);
            Instructions._storeL[n] = new InstrStoreL(n);
            ++n;
        }
        _loadE = new InstrLoadE[20];
        _storeE = new InstrStoreE[20];
        for (n = 0; n < 20; ++n) {
            Instructions._loadE[n] = new InstrLoadE(n);
            Instructions._storeE[n] = new InstrStoreE(n);
        }
        _loadC = new InstrLoadC[100];
        for (n = 0; n < 100; ++n) {
            Instructions._loadC[n] = new InstrLoadC(n);
        }
        _return = new InstrReturn[5];
        for (n = 0; n < 5; ++n) {
            Instructions._return[n] = new InstrReturn(n);
        }
    }
}

