/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.WritableToken;
import org.antlr.v4.runtime.misc.Interval;

public class BufferedTokenStream
implements TokenStream {
    private TokenSource tokenSource;
    protected List<Token> tokens = new ArrayList<Token>(100);
    protected int p = -1;
    private boolean fetchedEOF;

    public BufferedTokenStream(TokenSource tokenSource) {
        if (tokenSource == null) {
            throw new NullPointerException("tokenSource cannot be null");
        }
        this.tokenSource = tokenSource;
    }

    @Override
    public final TokenSource getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public final int index() {
        return this.p;
    }

    @Override
    public final int mark() {
        return 0;
    }

    @Override
    public final void release(int marker) {
    }

    @Override
    public final void seek(int index) {
        this.lazyInit();
        this.p = this.adjustSeekIndex(index);
    }

    @Override
    public final int size() {
        return this.tokens.size();
    }

    @Override
    public final void consume() {
        boolean skipEofCheck = this.p >= 0 ? (this.fetchedEOF ? this.p < this.tokens.size() - 1 : this.p < this.tokens.size()) : false;
        if (!skipEofCheck && this.LA(1) == -1) {
            throw new IllegalStateException("cannot consume EOF");
        }
        if (this.sync(this.p + 1)) {
            this.p = this.adjustSeekIndex(this.p + 1);
        }
    }

    protected final boolean sync(int i) {
        assert (i >= 0);
        int n = i - this.tokens.size() + 1;
        if (n > 0) {
            return this.fetch(n) >= n;
        }
        return true;
    }

    private int fetch(int n) {
        if (this.fetchedEOF) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            Token t = this.tokenSource.nextToken();
            if (t instanceof WritableToken) {
                ((WritableToken)t).setTokenIndex(this.tokens.size());
            }
            this.tokens.add(t);
            if (t.getType() != -1) continue;
            this.fetchedEOF = true;
            return i + 1;
        }
        return n;
    }

    @Override
    public final Token get(int i) {
        if (i < 0 || i >= this.tokens.size()) {
            throw new IndexOutOfBoundsException("token index " + i + " out of range 0.." + (this.tokens.size() - 1));
        }
        return this.tokens.get(i);
    }

    @Override
    public final int LA(int i) {
        return this.LT(i).getType();
    }

    protected Token LB(int k) {
        if (this.p - k < 0) {
            return null;
        }
        return this.tokens.get(this.p - k);
    }

    @Override
    public Token LT(int k) {
        this.lazyInit();
        if (k == 0) {
            return null;
        }
        if (k < 0) {
            return this.LB(-k);
        }
        int i = this.p + k - 1;
        this.sync(i);
        if (i >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        return this.tokens.get(i);
    }

    protected int adjustSeekIndex(int i) {
        return i;
    }

    protected final void lazyInit() {
        if (this.p == -1) {
            BufferedTokenStream bufferedTokenStream = this;
            bufferedTokenStream.sync(0);
            bufferedTokenStream.p = bufferedTokenStream.adjustSeekIndex(0);
        }
    }

    protected final int nextTokenOnChannel$255f288(int i) {
        this.sync(i);
        Token token = this.tokens.get(i);
        if (i >= this.size()) {
            return -1;
        }
        while (token.getChannel() != 0) {
            if (token.getType() == -1) {
                return -1;
            }
            this.sync(++i);
            token = this.tokens.get(i);
        }
        return i;
    }

    protected final int previousTokenOnChannel$255f288(int i) {
        while (i >= 0 && this.tokens.get(i).getChannel() != 0) {
            --i;
        }
        return i;
    }

    @Override
    public final String getSourceName() {
        return this.tokenSource.getSourceName();
    }

    @Override
    public final String getText(Token start, Token stop) {
        if (start != null && stop != null) {
            Token token;
            Interval interval = Interval.of(start.getTokenIndex(), stop.getTokenIndex());
            BufferedTokenStream bufferedTokenStream = this;
            int n = interval.a;
            int n2 = interval.b;
            if (n < 0 || n2 < 0) {
                return "";
            }
            bufferedTokenStream.lazyInit();
            if (n2 >= bufferedTokenStream.tokens.size()) {
                n2 = bufferedTokenStream.tokens.size() - 1;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n; i <= n2 && (token = bufferedTokenStream.tokens.get(i)).getType() != -1; ++i) {
                stringBuilder.append(token.getText());
            }
            return stringBuilder.toString();
        }
        return "";
    }
}

