/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.io.Serializable;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.WritableToken;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.Pair;

public class CommonToken
implements Serializable,
WritableToken {
    private static Pair<TokenSource, CharStream> EMPTY_SOURCE = new Pair<Object, Object>(null, null);
    protected int type;
    private int line;
    private int charPositionInLine = -1;
    private int channel = 0;
    private Pair<TokenSource, CharStream> source;
    private String text;
    private int index = -1;
    private int start;
    private int stop;

    public CommonToken(int type) {
        this.type = type;
        this.source = EMPTY_SOURCE;
    }

    public CommonToken(Pair<TokenSource, CharStream> source, int type, int channel, int start, int stop) {
        this.source = source;
        this.type = type;
        this.channel = channel;
        this.start = start;
        this.stop = stop;
        if (source.a != null) {
            this.line = ((TokenSource)source.a).getLine();
            this.charPositionInLine = ((TokenSource)source.a).getCharPositionInLine();
        }
    }

    public CommonToken(String text) {
        this.type = 74;
        this.channel = 0;
        this.text = text;
        this.source = EMPTY_SOURCE;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    public final void setLine(int line) {
        this.line = line;
    }

    @Override
    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        CharStream input = this.getInputStream();
        if (input == null) {
            return null;
        }
        int n = input.size();
        if (this.start < n && this.stop < n) {
            return input.getText(Interval.of(this.start, this.stop));
        }
        return "<EOF>";
    }

    public final void setText(String text) {
        this.text = text;
    }

    @Override
    public final int getLine() {
        return this.line;
    }

    @Override
    public final int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public final void setCharPositionInLine(int charPositionInLine) {
        this.charPositionInLine = charPositionInLine;
    }

    @Override
    public final int getChannel() {
        return this.channel;
    }

    @Override
    public final int getStartIndex() {
        return this.start;
    }

    @Override
    public final int getStopIndex() {
        return this.stop;
    }

    @Override
    public final int getTokenIndex() {
        return this.index;
    }

    @Override
    public final void setTokenIndex(int index) {
        this.index = index;
    }

    @Override
    public final TokenSource getTokenSource() {
        return (TokenSource)this.source.a;
    }

    @Override
    public final CharStream getInputStream() {
        return (CharStream)this.source.b;
    }

    public String toString() {
        String txt;
        String channelStr = "";
        if (this.channel > 0) {
            channelStr = ",channel=" + this.channel;
        }
        txt = (txt = this.getText()) != null ? txt.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t") : "<no text>";
        return "[@" + this.index + "," + this.start + ":" + this.stop + "='" + txt + "',<" + this.type + ">" + channelStr + "," + this.line + ":" + this.charPositionInLine + "]";
    }
}

