/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.Utils;

public abstract class SemanticContext {
    public static final SemanticContext NONE = new Predicate();

    public abstract boolean eval(Recognizer<?, ?> var1, RuleContext var2);

    public SemanticContext evalPrecedence(Recognizer<?, ?> parser, RuleContext outerContext) {
        return this;
    }

    public static SemanticContext and(SemanticContext a, SemanticContext b) {
        if (a == null || a == NONE) {
            return b;
        }
        if (b == null || b == NONE) {
            return a;
        }
        AND result = new AND(a, b);
        if (result.opnds.length == 1) {
            return result.opnds[0];
        }
        return result;
    }

    public static SemanticContext or(SemanticContext a, SemanticContext b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == NONE || b == NONE) {
            return NONE;
        }
        OR result = new OR(a, b);
        if (result.opnds.length == 1) {
            return result.opnds[0];
        }
        return result;
    }

    static /* synthetic */ List access$000(Collection x0) {
        Collection collection = x0;
        ArrayList<PrecedencePredicate> arrayList = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SemanticContext semanticContext = (SemanticContext)iterator.next();
            if (!(semanticContext instanceof PrecedencePredicate)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PrecedencePredicate>();
            }
            arrayList.add((PrecedencePredicate)semanticContext);
            iterator.remove();
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public static class OR
    extends SemanticContext {
        public final SemanticContext[] opnds;

        public OR(SemanticContext a, SemanticContext b) {
            HashSet<SemanticContext> operands = new HashSet<SemanticContext>();
            if (a instanceof OR) {
                operands.addAll(Arrays.asList(((OR)a).opnds));
            } else {
                operands.add(a);
            }
            if (b instanceof OR) {
                operands.addAll(Arrays.asList(((OR)b).opnds));
            } else {
                operands.add(b);
            }
            List precedencePredicates = SemanticContext.access$000(operands);
            if (!precedencePredicates.isEmpty()) {
                PrecedencePredicate reduced = (PrecedencePredicate)Collections.max(precedencePredicates);
                operands.add(reduced);
            }
            this.opnds = operands.toArray(new SemanticContext[operands.size()]);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OR)) {
                return false;
            }
            OR other = (OR)obj;
            return Arrays.equals(this.opnds, other.opnds);
        }

        public int hashCode() {
            return MurmurHash.hashCode(this.opnds, OR.class.hashCode());
        }

        @Override
        public final boolean eval(Recognizer<?, ?> parser, RuleContext outerContext) {
            SemanticContext[] arr$ = this.opnds;
            int len$ = this.opnds.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                if (!arr$[i$].eval(parser, outerContext)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final SemanticContext evalPrecedence(Recognizer<?, ?> parser, RuleContext outerContext) {
            boolean differs = false;
            ArrayList<SemanticContext> operands = new ArrayList<SemanticContext>();
            SemanticContext[] arr$ = this.opnds;
            int len$ = this.opnds.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                SemanticContext context = arr$[i$];
                SemanticContext evaluated = context.evalPrecedence(parser, outerContext);
                differs |= evaluated != context;
                if (evaluated == NONE) {
                    return NONE;
                }
                if (evaluated == null) continue;
                operands.add(evaluated);
            }
            if (!differs) {
                return this;
            }
            if (operands.isEmpty()) {
                return null;
            }
            SemanticContext result = (SemanticContext)operands.get(0);
            for (int i = 1; i < operands.size(); ++i) {
                result = SemanticContext.or(result, (SemanticContext)operands.get(i));
            }
            return result;
        }

        public String toString() {
            return Utils.join(Arrays.asList(this.opnds).iterator(), "||");
        }
    }

    public static class AND
    extends SemanticContext {
        public final SemanticContext[] opnds;

        public AND(SemanticContext a, SemanticContext b) {
            HashSet<SemanticContext> operands = new HashSet<SemanticContext>();
            if (a instanceof AND) {
                operands.addAll(Arrays.asList(((AND)a).opnds));
            } else {
                operands.add(a);
            }
            if (b instanceof AND) {
                operands.addAll(Arrays.asList(((AND)b).opnds));
            } else {
                operands.add(b);
            }
            List precedencePredicates = SemanticContext.access$000(operands);
            if (!precedencePredicates.isEmpty()) {
                PrecedencePredicate reduced = (PrecedencePredicate)Collections.min(precedencePredicates);
                operands.add(reduced);
            }
            this.opnds = operands.toArray(new SemanticContext[operands.size()]);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AND)) {
                return false;
            }
            AND other = (AND)obj;
            return Arrays.equals(this.opnds, other.opnds);
        }

        public int hashCode() {
            return MurmurHash.hashCode(this.opnds, AND.class.hashCode());
        }

        @Override
        public final boolean eval(Recognizer<?, ?> parser, RuleContext outerContext) {
            SemanticContext[] arr$ = this.opnds;
            int len$ = this.opnds.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                if (arr$[i$].eval(parser, outerContext)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final SemanticContext evalPrecedence(Recognizer<?, ?> parser, RuleContext outerContext) {
            boolean differs = false;
            ArrayList<SemanticContext> operands = new ArrayList<SemanticContext>();
            SemanticContext[] arr$ = this.opnds;
            int len$ = this.opnds.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                SemanticContext context = arr$[i$];
                SemanticContext evaluated = context.evalPrecedence(parser, outerContext);
                differs |= evaluated != context;
                if (evaluated == null) {
                    return null;
                }
                if (evaluated == NONE) continue;
                operands.add(evaluated);
            }
            if (!differs) {
                return this;
            }
            if (operands.isEmpty()) {
                return NONE;
            }
            SemanticContext result = (SemanticContext)operands.get(0);
            for (int i = 1; i < operands.size(); ++i) {
                result = SemanticContext.and(result, (SemanticContext)operands.get(i));
            }
            return result;
        }

        public String toString() {
            return Utils.join(Arrays.asList(this.opnds).iterator(), "&&");
        }
    }

    public static class PrecedencePredicate
    extends SemanticContext
    implements Comparable<PrecedencePredicate> {
        private int precedence;

        protected PrecedencePredicate() {
            this.precedence = 0;
        }

        public PrecedencePredicate(int precedence) {
            this.precedence = precedence;
        }

        @Override
        public final boolean eval(Recognizer<?, ?> parser, RuleContext outerContext) {
            return parser.precpred(outerContext, this.precedence);
        }

        @Override
        public final SemanticContext evalPrecedence(Recognizer<?, ?> parser, RuleContext outerContext) {
            if (parser.precpred(outerContext, this.precedence)) {
                return NONE;
            }
            return null;
        }

        public int hashCode() {
            return 31 + this.precedence;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PrecedencePredicate)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            PrecedencePredicate other = (PrecedencePredicate)obj;
            return this.precedence == other.precedence;
        }

        public String toString() {
            return super.toString();
        }
    }

    public static class Predicate
    extends SemanticContext {
        private int ruleIndex;
        private int predIndex;
        private boolean isCtxDependent;

        protected Predicate() {
            this.ruleIndex = -1;
            this.predIndex = -1;
            this.isCtxDependent = false;
        }

        public Predicate(int ruleIndex, int predIndex, boolean isCtxDependent) {
            this.ruleIndex = ruleIndex;
            this.predIndex = predIndex;
            this.isCtxDependent = isCtxDependent;
        }

        @Override
        public final boolean eval(Recognizer<?, ?> parser, RuleContext outerContext) {
            RuleContext localctx = this.isCtxDependent ? outerContext : null;
            return parser.sempred(localctx, this.ruleIndex, this.predIndex);
        }

        public int hashCode() {
            return MurmurHash.finish(MurmurHash.update(MurmurHash.update(MurmurHash.update(0, this.ruleIndex), this.predIndex), this.isCtxDependent ? 1 : 0), 3);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Predicate)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            Predicate p = (Predicate)obj;
            return this.ruleIndex == p.ruleIndex && this.predIndex == p.predIndex && this.isCtxDependent == p.isCtxDependent;
        }

        public String toString() {
            return "{" + this.ruleIndex + ":" + this.predIndex + "}?";
        }
    }
}

