/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree.gui;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeLayout;
import org.antlr.v4.runtime.misc.Utils;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.gui.PostScriptDocument;
import org.antlr.v4.runtime.tree.gui.TreeLayoutAdaptor;
import org.antlr.v4.runtime.tree.gui.TreeTextProvider;
import org.antlr.v4.runtime.tree.gui.TreeViewer;

public class TreePostScriptGenerator {
    private double gapBetweenLevels = 17.0;
    private double gapBetweenNodes = 7.0;
    protected int nodeWidthPadding = 1;
    protected int nodeHeightPaddingBelow = 5;
    private TreeTextProvider treeTextProvider;
    private TreeLayout<Tree> treeLayout;
    protected PostScriptDocument doc;

    public TreePostScriptGenerator(List<String> ruleNames, Tree root, String fontName, int fontSize) {
        this.treeTextProvider = new TreeViewer.DefaultTreeTextProvider(ruleNames);
        this.doc = new PostScriptDocument(fontName, fontSize);
        this.treeLayout = new TreeLayout<Tree>(new TreeLayoutAdaptor(root), new VariableExtentProvide(this), new Configuration(this.gapBetweenLevels, this.gapBetweenNodes));
    }

    public final String getPS() {
        this.generateEdges(this.treeLayout.getTree().getRoot());
        Iterator<Tree> i$ = this.treeLayout.getNodeBounds().keySet().iterator();
        while (i$.hasNext()) {
            Tree node;
            Tree tree = node = i$.next();
            TreePostScriptGenerator treePostScriptGenerator = this;
            String[] stringArray = treePostScriptGenerator.getText(tree).split("\n");
            Rectangle2D.Double double_ = treePostScriptGenerator.getBoundsOfNode(tree);
            if (tree instanceof ErrorNode) {
                treePostScriptGenerator.doc.highlight(double_.x, double_.y, double_.width, double_.height);
            }
            double d = double_.x + (double)treePostScriptGenerator.nodeWidthPadding;
            double d2 = double_.y + (double)treePostScriptGenerator.nodeHeightPaddingBelow;
            for (int i = 0; i < stringArray.length; ++i) {
                treePostScriptGenerator.doc.text(stringArray[i], d, d2);
                d2 += treePostScriptGenerator.doc.getLineHeight();
            }
        }
        Dimension size = this.treeLayout.getBounds().getBounds().getSize();
        this.doc.boundingBox(size.width, size.height);
        this.doc.close();
        return this.doc.getPS();
    }

    private void generateEdges(Tree parent) {
        if (!this.treeLayout.getTree().isLeaf(parent)) {
            Rectangle2D.Double parentBounds = this.getBoundsOfNode(parent);
            double x1 = parentBounds.getCenterX();
            double y1 = parentBounds.y;
            Tree tree = parent;
            for (Tree child : this.treeLayout.getTree().getChildren(tree)) {
                Rectangle2D.Double childBounds = this.getBoundsOfNode(child);
                double x2 = childBounds.getCenterX();
                double y2 = childBounds.getMaxY();
                this.doc.line(x1, y1, x2, y2);
                this.generateEdges(child);
            }
        }
    }

    private Rectangle2D.Double getBoundsOfNode(Tree node) {
        return this.treeLayout.getNodeBounds().get(node);
    }

    protected final String getText(Tree tree) {
        return Utils.escapeWhitespace(this.treeTextProvider.getText(tree), false);
    }

    public class VariableExtentProvide
    implements NodeExtentProvider<Tree> {
        private /* synthetic */ TreePostScriptGenerator this$0;

        public VariableExtentProvide(TreePostScriptGenerator treePostScriptGenerator) {
            this.this$0 = treePostScriptGenerator;
        }
    }
}

