/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.client;

import com.google.common.base.Strings;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.mobtalker.mobtalker2.client.gui.MobTalkerInteractionGui;
import net.mobtalker.mobtalker2.client.network.ClientMessageHandler;
import net.mobtalker.mobtalker2.common.resources.MobTalkerResourceLocation;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;
import net.mobtalker.mobtalker2.util.mgt.AlignmentX;
import net.mobtalker.mobtalker2.util.mgt.FullscreenMode;
import net.mobtalker.mobtalker2.util.mgt.Point;

@SideOnly(value=Side.CLIENT)
public class ClientInteractionHandler
extends Container {
    private static final String LOG_TAG = "ClientInteractionHandler";
    protected final EntityPlayer _player;
    protected final MobTalkerInteractionGui _gui;

    public ClientInteractionHandler(EntityPlayer player) {
        this._player = player;
        this._gui = new MobTalkerInteractionGui(this);
        this.func_75146_a(new Slot((IInventory)new InventoryBasic("FakeInventory", false, 1), 0, 9001, 9001));
    }

    private Minecraft getMinecraft() {
        return FMLClientHandler.instance().getClient();
    }

    public EntityPlayer getPlayer() {
        return this._player;
    }

    public MobTalkerInteractionGui getGui() {
        return this._gui;
    }

    public void close() {
        Minecraft mc = this.getMinecraft();
        mc.func_147108_a(null);
        mc.func_71381_h();
    }

    public void onChoiceMade(int choice) {
        MobTalkerLog.debug(LOG_TAG, "Choice made: %s", choice);
        this._gui.hideChoiceMenu();
        ClientMessageHandler.instance().sendChoiceMade(choice);
    }

    public void onKeyTyped(char par1, int keyCode) {
        MobTalkerLog.debug(LOG_TAG, "Typed key '%s' (%s)", Character.valueOf(par1), keyCode);
        if (keyCode == 1 || keyCode == this.getMinecraft().field_71474_y.field_151445_Q.func_151463_i()) {
            ClientMessageHandler.instance().sendCancelInteraction();
        }
    }

    public void onTextFinished() {
        ClientMessageHandler.instance().sendTextFinished();
    }

    public void showSprite(String textureGroup, String texturePath, String position, Point offset) {
        textureGroup = textureGroup.toLowerCase();
        texturePath = texturePath.toLowerCase();
        String pathStr = "textures/sprites/" + textureGroup + "/" + texturePath + ".png";
        MobTalkerResourceLocation textureLocation = new MobTalkerResourceLocation(pathStr);
        this._gui.showSprite(textureGroup, textureLocation, position, offset);
    }

    public void showScene(String texturePath, String mode) {
        texturePath = texturePath.toLowerCase();
        String pathStr = "textures/scenes/" + texturePath + ".png";
        FullscreenMode fsMode = FullscreenMode.valueOf(mode.toUpperCase());
        MobTalkerResourceLocation textureLocation = new MobTalkerResourceLocation(pathStr);
        this._gui.showScene(textureLocation, fsMode);
    }

    public void hideTexture(String textureGroup) {
        textureGroup = textureGroup.toLowerCase();
        this._gui.hideTexture(textureGroup);
    }

    public void displayName(String name) {
        this._gui.setCharacterName(name, AlignmentX.LEFT);
    }

    public void displayText(String text, boolean isLast) {
        this._gui.clearDialogeText();
        this._gui.setDialogeText(text);
    }

    public void displayChoice(String caption, List<String> choices) {
        if (!Strings.isNullOrEmpty((String)caption)) {
            this._gui.setCharacterName("", AlignmentX.LEFT);
            this._gui.clearDialogeText();
            this._gui.setDialogeText(caption);
        }
        this._gui.displayChoiceMenu(choices);
    }

    public final boolean func_75145_c(EntityPlayer player) {
        return this._player == player;
    }

    public final void func_75134_a(EntityPlayer player) {
        if (player.func_70089_S()) {
            throw new AssertionError((Object)"Should not call this if player is still alive");
        }
        super.func_75134_a(player);
    }
}

