/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.mobtalker.mobtalker2.common.MobTalkerConfig;
import net.mobtalker.mobtalker2.util.SoundHelper;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;
import net.mobtalker.mobtalker2.util.mgt.IMouseListener;
import net.mobtalker.mobtalker2.util.mgt.MGComponent;
import net.mobtalker.mobtalker2.util.mgt.MGTextArea;
import net.mobtalker.mobtalker2.util.mgt.MouseListenerAdapter;

@SideOnly(value=Side.CLIENT)
public class MobTalkerDialogArea
extends MGTextArea {
    private static final String LOG_TAG = "GUI";
    private static final String CONTINUE_INDICATOR = "\u25b6";
    private IEndOfTextReachedListener _listener;
    private final Queue<String> _queuedLines;
    private long _indicatorTime;
    final IMouseListener advanceTextListener = new MouseListenerAdapter(){

        @Override
        public void mouseClicked(MGComponent sender, int x, int y, int button) {
            if (button == 0) {
                if (MobTalkerDialogArea.this._isScrolling) {
                    MobTalkerDialogArea.this._isScrolling = false;
                } else {
                    MobTalkerDialogArea.this.advanceText();
                }
                SoundHelper.playSoundFX("gui.button.press", 1.0f);
            }
        }
    };

    public MobTalkerDialogArea(int id) {
        super(id);
        this._queuedLines = new LinkedList<String>();
        this.addMouseListener(this.advanceTextListener);
        this.setScrolling(true);
        this.setScrollingSpeed(MobTalkerConfig.getTextScrollingSpeed());
    }

    @Override
    protected void doDraw() {
        super.doDraw();
        if (!this.isEndOfText()) {
            long elapsed = Minecraft.func_71386_F() - this._indicatorTime;
            if (elapsed % 1250L > 625L) {
                return;
            }
            int posX = this.getBounds().getRight() + 1;
            int posY = this.getBounds().getBottom() - MobTalkerDialogArea.getFontRenderer().field_78288_b;
            MobTalkerDialogArea.getFontRenderer().func_78276_b(CONTINUE_INDICATOR, posX, posY, -1);
        }
    }

    public void clearText() {
        this._text = null;
        this._lines.clear();
        this._queuedLines.clear();
    }

    @Override
    public void setText(String text) {
        this._text = text;
        if (text != null && !text.isEmpty()) {
            int i;
            List allLines = MobTalkerDialogArea.getFontRenderer().func_78271_c(text, this.getBounds().getWidth());
            for (i = 0; i < this._lineCount && i < allLines.size(); ++i) {
                this._lines.add(allLines.get(i));
            }
            while (i < allLines.size()) {
                this._queuedLines.add((String)allLines.get(i));
                ++i;
            }
            if (this._enableScrolling) {
                this._scrollingRow = 1;
                this._scrollingCol = 1;
                this._isScrolling = true;
            }
        } else {
            this.clearText();
        }
    }

    public boolean isEndOfText() {
        return this._queuedLines.isEmpty();
    }

    public void advanceText() {
        if (this.isEndOfText()) {
            if (this._listener != null) {
                this._listener.onEndOfTextReached();
            } else {
                MobTalkerLog.warn(LOG_TAG, "Reached end of text, but no listener is set!");
            }
        } else {
            this._lines.clear();
            for (int i = 0; i < this._lineCount && !this._queuedLines.isEmpty(); ++i) {
                this._lines.add(this._queuedLines.remove());
            }
            this._scrollingRow = 1;
            this._scrollingCol = 1;
            this._isScrolling = true;
        }
    }

    public void setEndOfTextListener(IEndOfTextReachedListener listener) {
        this._listener = listener;
    }

    public static interface IEndOfTextReachedListener {
        public void onEndOfTextReached();
    }
}

