/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.common;

import com.google.common.base.Preconditions;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class MobTalkerConfig {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private static Configuration _config;
    private static Property _interactableEntities;
    private static Property _textScrollingSpeed;

    public static void init(File configFile) {
        Preconditions.checkState((_config == null ? 1 : 0) != 0, (Object)"A config is already loaded");
        Preconditions.checkNotNull((Object)configFile);
        _config = new Configuration(configFile, true);
        MobTalkerConfig.load();
        MobTalkerConfig.save();
        FMLCommonHandler.instance().bus().register((Object)new ChangeHandler());
    }

    public static void load() {
        MobTalkerConfig.loadGeneral();
        MobTalkerConfig.loadGui();
    }

    private static void loadGeneral() {
        _interactableEntities = MobTalkerConfig.get("general", "InteractableEntities", new String[]{"Creeper", "Skeleton", "WitherSkeleton", "Zombie"}, "Entities players should be able to interact with\nCurrently available:\n - Creeper\n - Skeleton\n - WitherSkeleton\n - Zombie");
    }

    private static void loadGui() {
        _textScrollingSpeed = MobTalkerConfig.get("gui", "TextScrollingSpeed", 2, "Scrolling speed of the dialog text");
    }

    public static void save() {
        if (_config.hasChanged()) {
            _config.save();
        }
    }

    public static Configuration getConfiguration() {
        return _config;
    }

    public static List<String> getInteractableEntities() {
        return Arrays.asList(_interactableEntities.getStringList());
    }

    public static void setInteractableEntities(List<String> entities) {
        _interactableEntities.setValues((String[])entities.toArray());
    }

    public static int getTextScrollingSpeed() {
        return _textScrollingSpeed.getInt();
    }

    public static void setTextScrollingSpeed(int speed) {
        _textScrollingSpeed.setValue(speed);
    }

    private static Property get(String category, String key, int defaultValue, String comment) {
        return _config.get(category, key, defaultValue, comment);
    }

    private static Property get(String category, String key, boolean defaultValue, String comment) {
        return _config.get(category, key, defaultValue, comment);
    }

    private static Property get(String category, String key, double defaultValue, String comment) {
        return _config.get(category, key, defaultValue, comment);
    }

    private static Property get(String category, String key, String defaultValue, String comment) {
        return _config.get(category, key, defaultValue, comment);
    }

    private static Property get(String category, String key, String[] defaultValue, String comment) {
        return _config.get(category, key, defaultValue, comment);
    }

    private static final class ChangeHandler {
        private ChangeHandler() {
        }

        @SubscribeEvent
        public void onConfigurationChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (!event.modID.equals("mobtalker2")) {
                return;
            }
            MobTalkerConfig.load();
        }
    }
}

