/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.interaction;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.mobtalker.mobtalker2.common.item.ItemMobTalker;
import net.mobtalker.mobtalker2.server.entity.ai.MobTalkerAiInteractPlayer;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;
import net.mobtalker.mobtalker2.server.script.InteractionScript;
import net.mobtalker.mobtalker2.server.script.InteractionScriptFactory;
import net.mobtalker.mobtalker2.server.script.MissingScriptException;
import net.mobtalker.mobtalker2.util.ChatMessageHelper;
import net.mobtalker.mobtalker2.util.EntityUtil;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;
import net.mobtalker.mobtalkerscript.v2.compiler.MtsSyntaxError;

public class BasicInteractionAdapter
implements IInteractionAdapter {
    private static final String LOG_TAG = "InteractionAdapter";
    protected static final double MAX_INTERACTION_DISTANCE = 3.0;
    protected final EntityLiving _entity;
    protected String _entityKey;
    protected EntityPlayerMP _partner;
    protected InteractionScript _script;
    protected final boolean _allowInWater;
    protected final boolean _allowInAir;
    protected final HashMap<UUID, Double> _loveList;
    protected double _defaultLoveLevel;
    protected EntityLivingBase _followTarget;
    protected EntityLivingBase _escortTarget;
    protected EntityLivingBase _focusTarget;
    protected Vec3 _stayPoint;
    protected final MobTalkerAiInteractPlayer _aiInteract;
    protected int _aiInteractPrio;
    private NBTTagCompound _savedVariables;

    public BasicInteractionAdapter(EntityLiving entity) {
        Preconditions.checkNotNull((Object)entity);
        this._entity = entity;
        this._allowInWater = false;
        this._allowInAir = false;
        this._loveList = Maps.newHashMapWithExpectedSize((int)1);
        this._defaultLoveLevel = 0.0;
        this._aiInteract = new MobTalkerAiInteractPlayer(this);
        this._aiInteractPrio = 1;
    }

    @Override
    public final EntityLiving getEntity() {
        return this._entity;
    }

    @Override
    public String getEntityName() {
        return this._entity.func_94056_bM() ? this._entity.func_94057_bL() : this.getDefaultEntityName();
    }

    @Override
    public String getDefaultEntityName() {
        return (String)EntityList.field_75626_c.get(this._entity.getClass());
    }

    @Override
    public boolean hasScriptInstance() {
        return this._script != null;
    }

    @Override
    public InteractionScript getScriptInstance() {
        if (this._script == null) {
            throw new NullPointerException("Adapter has no script instance!");
        }
        return this._script;
    }

    private void createScriptInstance() throws IOException {
        this._script = InteractionScriptFactory.instance().createInstanceFor(this);
        if (this._savedVariables != null) {
            MobTalkerLog.trace(LOG_TAG, "Reading SavedVariables for '%s'", this.getDefaultEntityName());
            try {
                this.deserializeScript(this._savedVariables);
            }
            catch (Exception ex) {
                MobTalkerLog.fatal(LOG_TAG, "Error while reading SavedVariables", ex);
            }
            this._savedVariables = null;
        }
    }

    @Override
    @Deprecated
    public final void init(Entity entity, World world) {
        assert (this._entity.equals((Object)entity));
    }

    @Override
    public void onSpawn(World world) {
    }

    @Override
    public void onHitByEntity(EntityLivingBase attacker, DamageSource source, float ammount) {
        int level = (int)(this.getLoveLevel(attacker) - (double)ammount);
        MobTalkerLog.debug(LOG_TAG, "'%s' attacked '%s' for '%s'", EntityUtil.getName(attacker), this.getDefaultEntityName(), Float.valueOf(ammount));
        this.setLoveLevel(attacker, level);
    }

    @Override
    public void onDeath() {
    }

    @Override
    public void onWorldChanged() {
    }

    @Override
    public void onInteractionStart() {
    }

    @Override
    public void onInteractionEnd() {
    }

    @Override
    public void onInteractionCanceled() {
    }

    @Override
    public boolean canStartInteractionWith(EntityPlayerMP player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        ItemStack holdItemStack = player.func_70694_bm();
        if (holdItemStack == null || !(holdItemStack.func_77973_b() instanceof ItemMobTalker)) {
            MobTalkerLog.debug(LOG_TAG, "'%s' wants to interact with '%s', but does not hold a MobTalker item", EntityUtil.getName((EntityPlayer)player), this.getDefaultEntityName());
            return false;
        }
        if (this.isActive()) {
            Preconditions.checkState((!player.equals((Object)this._partner) ? 1 : 0) != 0, (String)"%s tried to start interaction with %s twice", (Object[])new Object[]{EntityUtil.getName((EntityPlayer)player), this.getEntityName()});
            MobTalkerLog.debug(LOG_TAG, "'%s' requested interaction with '%s', who is currently interacting with '%s'", EntityUtil.getName((EntityPlayer)player), this.getDefaultEntityName(), EntityUtil.getName((EntityPlayer)this._partner));
            return false;
        }
        if (!this.canInteractWith((EntityLivingBase)player)) {
            return false;
        }
        if (!this.hasScriptInstance()) {
            try {
                MobTalkerLog.info(LOG_TAG, "Creating script instance for '%s'", this.getDefaultEntityName());
                this.createScriptInstance();
            }
            catch (MissingScriptException ex) {
                MobTalkerLog.warn(LOG_TAG, "Missing script instance for '%s'", this.getDefaultEntityName());
                ChatMessageHelper.sendMessageToPlayer((EntityPlayer)player, "Interactions for '%s' are enabled but no script is available!", EnumChatFormatting.RED, this.getDefaultEntityName());
                return false;
            }
            catch (MtsSyntaxError ex) {
                MobTalkerLog.warn(LOG_TAG, "Script instance for '%s' contains syntax errors\n%s", this.getDefaultEntityName(), ex.getMessage());
                ChatMessageHelper.sendMessageToPlayer((EntityPlayer)player, ex.getMessage(), EnumChatFormatting.RED, new Object[0]);
                return false;
            }
            catch (Exception ex) {
                MobTalkerLog.fatal(LOG_TAG, "Unable to create a script instance for '%s'", ex, this.getDefaultEntityName());
                ChatMessageHelper.sendMessageToPlayer((EntityPlayer)player, "Unable to create script: %s", EnumChatFormatting.RED, ex.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canInteractWith(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        if (!this._allowInWater && this._entity.func_70090_H()) {
            MobTalkerLog.info(LOG_TAG, "Cannot interact with '%s': Entity is in water", EntityUtil.getName(entity));
            return false;
        }
        if (!this._allowInAir && !this._entity.field_70122_E) {
            MobTalkerLog.info(LOG_TAG, "Cannot interact with '%s': Entity is not on the ground", EntityUtil.getName(entity));
            return false;
        }
        if (this._entity.field_70133_I) {
            MobTalkerLog.info(LOG_TAG, "Cannot interact with '%s': Entity velocity changed", EntityUtil.getName(entity));
            return false;
        }
        if (!entity.func_70089_S()) {
            MobTalkerLog.info(LOG_TAG, "Cannot interact with '%s': Entity partner is not alive", EntityUtil.getName(entity));
            return false;
        }
        if (!this.checkInteractionDistance(entity)) {
            MobTalkerLog.info(LOG_TAG, "Cannot interact with '%s': Out of Interaction distance", EntityUtil.getName(entity));
            return false;
        }
        return true;
    }

    @Override
    public boolean canInteractWithCurrentPartner() {
        return this.canInteractWith((EntityLivingBase)this._partner);
    }

    @Override
    public boolean checkInteractionDistance(EntityLivingBase entity) {
        Preconditions.checkNotNull((Object)entity);
        return Math.ceil(this._entity.func_70032_d((Entity)entity)) <= 3.0;
    }

    @Override
    public boolean checkInteractionDistance() {
        return this.checkInteractionDistance((EntityLivingBase)this._partner);
    }

    @Override
    public EntityPlayerMP getPlayer() {
        return this._partner;
    }

    @Override
    public void setPlayer(EntityPlayerMP player) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0);
        this._partner = player;
    }

    @Override
    public void clearPlayer() {
        this._partner = null;
    }

    @Override
    public boolean isActive() {
        return this._partner != null;
    }

    @Override
    public double getLoveLevel(EntityLivingBase entity) {
        Preconditions.checkNotNull((Object)entity);
        UUID entityID = entity.func_110124_au();
        if (!this._loveList.containsKey(entityID)) {
            return this.getDefaultLoveLevel();
        }
        return this._loveList.get(entityID);
    }

    @Override
    public double getDefaultLoveLevel() {
        return this._defaultLoveLevel;
    }

    @Override
    public void setDefaultLoveLevel(double defaultLoveLevel) {
        this._defaultLoveLevel = defaultLoveLevel;
    }

    @Override
    public void setLoveLevel(EntityLivingBase entity, double level) {
        MobTalkerLog.debug(LOG_TAG, "Setting LoveLevel for '%s' on '%s' to '%s'", this.getDefaultEntityName(), EntityUtil.getName(entity), level);
        UUID id = entity.func_110124_au();
        if (level == this.getDefaultLoveLevel()) {
            this._loveList.remove(id);
        } else {
            this._loveList.put(id, level);
        }
    }

    @Override
    public void increaseLoveLevel(EntityLivingBase entity) {
        this.setLoveLevel(entity, this.getLoveLevel(entity) + 1.0);
    }

    @Override
    public void decreaseLoveLevel(EntityLivingBase entity) {
        this.setLoveLevel(entity, this.getLoveLevel(entity) - 1.0);
    }

    @Override
    public EntityLivingBase getEscortTarget() {
        return this._escortTarget;
    }

    @Override
    public void setEscortTarget(EntityLivingBase entity) {
        this._escortTarget = entity;
        this.setFollowTarget(entity);
    }

    @Override
    public EntityLivingBase getFollowTarget() {
        return this._followTarget;
    }

    @Override
    public void setFollowTarget(EntityLivingBase entity) {
        this._followTarget = entity;
    }

    @Override
    public boolean shouldAttack(EntityLivingBase entity) {
        if (entity == this._partner) {
            return false;
        }
        return this.getLoveLevel(entity) < 0.0;
    }

    @Override
    public EntityLivingBase getFocusTarget() {
        return this._focusTarget;
    }

    @Override
    public void setFocusTarget(EntityLivingBase target) {
        this._focusTarget = target;
    }

    @Override
    public void stayAtPosition() {
        this._stayPoint = Vec3.func_72443_a((double)this._entity.field_70165_t, (double)this._entity.field_70163_u, (double)this._entity.field_70161_v);
    }

    @Override
    public Vec3 getStayPosition() {
        return this._stayPoint;
    }

    @Override
    public void roam() {
        this._stayPoint = null;
    }

    @Override
    public int getInteractAiPriority() {
        return this._aiInteractPrio;
    }

    @Override
    public void setInteractAiPriority(int priority) {
        this._aiInteractPrio = priority;
    }

    @Override
    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound store = new NBTTagCompound();
        store.func_74782_a("LoveLevels", (NBTBase)this.serializeLoveLevels());
        if (this.hasScriptInstance()) {
            store.func_74782_a("Script", (NBTBase)this.serializeScript());
        }
        compound.func_74782_a("mobtalker2", (NBTBase)store);
    }

    protected NBTTagCompound serializeLoveLevels() {
        NBTTagCompound compound = new NBTTagCompound();
        for (Map.Entry<UUID, Double> entry : this._loveList.entrySet()) {
            String entityID = entry.getKey().toString();
            double loveLevel = entry.getValue();
            compound.func_74780_a(entityID, loveLevel);
        }
        return compound;
    }

    protected NBTTagCompound serializeScript() {
        return this._script.serialize();
    }

    @Override
    public void loadNBTData(NBTTagCompound compound) {
        if (!compound.func_74764_b("mobtalker2")) {
            return;
        }
        NBTTagCompound store = compound.func_74775_l("mobtalker2");
        this.deserializeLoveLevels(store.func_74775_l("LoveLevels"));
        if (store.func_74764_b("Script")) {
            this._savedVariables = store.func_74775_l("Script");
        }
    }

    protected void deserializeLoveLevels(NBTTagCompound store) {
        Set keys = store.func_150296_c();
        for (String key : keys) {
            NBTTagDouble tag = (NBTTagDouble)store.func_74781_a(key);
            UUID entityID = UUID.fromString(key);
            double loveLevel = tag.func_150286_g();
            this._loveList.put(entityID, loveLevel);
        }
    }

    protected void deserializeScript(NBTTagCompound compound) {
        this._script.deserialize(compound);
    }

    protected void addAiTask(int prio, EntityAIBase task) {
        this._entity.field_70714_bg.func_75776_a(prio, task);
    }

    protected void removeAiTask(EntityAIBase task) {
        this._entity.field_70714_bg.func_85156_a(task);
    }
}

