/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.interaction;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.mobtalker.mobtalker2.MobTalker2;
import net.mobtalker.mobtalker2.common.MobTalkerConfig;
import net.mobtalker.mobtalker2.server.ServerInteractionHandler;
import net.mobtalker.mobtalker2.server.entity.monster.CreeperAdapterInitializer;
import net.mobtalker.mobtalker2.server.entity.monster.SkeletonAdapterInitializer;
import net.mobtalker.mobtalker2.server.entity.monster.ZombieAdapterInitializer;
import net.mobtalker.mobtalker2.server.event.MobTalkerEvent;
import net.mobtalker.mobtalker2.server.interaction.BasicInteractionAdapter;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapterFactory;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapterInitializer;
import net.mobtalker.mobtalker2.server.interaction.InteractionScriptFutureTask;
import net.mobtalker.mobtalker2.server.script.InteractionScript;
import net.mobtalker.mobtalker2.util.EntityUtil;
import net.mobtalker.mobtalker2.util.logging.MobTalkerLog;

public class InteractionRegistry {
    private static final String LOG_TAG = "InteractionRegistry";
    private static InteractionRegistry instance;
    private final Map<String, IInteractionAdapterFactory> _adapterFactories = Maps.newHashMap();
    private final Map<String, IInteractionAdapterInitializer> _adapterInitializers = Maps.newHashMap();
    private final ExecutorService _executor = InteractionRegistry.createExecutor();
    private final Set<IInteractionAdapter> _activeAdapters = Sets.newHashSet();
    private final Map<IInteractionAdapter, InteractionScriptFutureTask> _activeInteractions = Maps.newHashMap();
    private static final String ADAPTER_IDENTIFIER = "MobTalkerInteractionAdapter";

    public static InteractionRegistry instance() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"No InteractionAdapterFactory is currently loaded");
        return instance;
    }

    public static boolean isLoaded() {
        return instance != null;
    }

    public static void load() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Already loaded");
        MobTalkerLog.debug(LOG_TAG, "Loading");
        instance = new InteractionRegistry();
        instance.registerAdapterInitializer("Creeper", new CreeperAdapterInitializer());
        instance.registerAdapterInitializer("Skeleton", new SkeletonAdapterInitializer());
        instance.registerAdapterInitializer("WitherSkeleton", new SkeletonAdapterInitializer());
        instance.registerAdapterInitializer("Zombie", new ZombieAdapterInitializer());
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    public static void unload() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"No InteractionAdapterFactory is currently loaded");
        MobTalkerLog.debug(LOG_TAG, "Unloading");
        MinecraftForge.EVENT_BUS.unregister((Object)instance);
        instance.shutdown();
        instance = null;
    }

    private InteractionRegistry() {
    }

    private static ExecutorService createExecutor() {
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("MobTalker2 ScriptThread #%d").setPriority(5).setDaemon(true).build();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), factory);
        executor.prestartCoreThread();
        return executor;
    }

    private void shutdown() {
        for (IInteractionAdapter adapter : Lists.newArrayList(this._activeAdapters)) {
            this.cancelInteraction(adapter);
        }
        this._executor.shutdown();
    }

    public boolean hasAdapterFactory(String entityType) {
        return this._adapterFactories.containsKey(entityType);
    }

    public void registerAdapterFactory(String entityType, IInteractionAdapterFactory factory) {
        Preconditions.checkNotNull((Object)entityType, (Object)"entityType can not be null");
        Preconditions.checkNotNull((Object)factory, (Object)"factory can not be null");
        boolean knownEntity = EntityList.field_75626_c.containsValue(entityType);
        Preconditions.checkArgument((boolean)knownEntity, (String)"Unknown entityType '%s'", (Object[])new Object[]{entityType});
        this._adapterFactories.put(entityType, factory);
    }

    public boolean hasAdapterInitializer(String entityType) {
        return this._adapterInitializers.containsKey(entityType);
    }

    public void registerAdapterInitializer(String entityType, IInteractionAdapterInitializer initializer) {
        Preconditions.checkNotNull((Object)entityType, (Object)"entityType can not be null");
        Preconditions.checkNotNull((Object)initializer, (Object)"initializer can not be null");
        this._adapterInitializers.put(entityType, initializer);
    }

    public IInteractionAdapter getAdapter(EntityLivingBase entity) {
        return (IInteractionAdapter)entity.getExtendedProperties(ADAPTER_IDENTIFIER);
    }

    public IInteractionAdapter getAdapter(EntityPlayer player) {
        Preconditions.checkNotNull((Object)player);
        for (IInteractionAdapter adapter : this._activeAdapters) {
            if (!player.equals((Object)adapter.getPlayer())) continue;
            return adapter;
        }
        return null;
    }

    private boolean canCreateAdapterFor(EntityLiving entity) {
        String entityType = EntityUtil.getName(entity);
        if (!MobTalkerConfig.getInteractableEntities().contains(entityType)) {
            return false;
        }
        boolean hasFactory = this.hasAdapterFactory(entityType);
        boolean hasInitializer = this.hasAdapterInitializer(entityType);
        if (!hasFactory && !hasInitializer) {
            MobTalkerLog.warn(LOG_TAG, "Entity %s does not have an adapter initializer. Interactions are not enabled.", entityType);
            MobTalkerConfig.getInteractableEntities().remove(entityType);
            return false;
        }
        return true;
    }

    private IInteractionAdapter createAdapter(EntityLiving entity) {
        String entityType = EntityUtil.getName(entity);
        IInteractionAdapterFactory factory = this._adapterFactories.get(entityType);
        IInteractionAdapter adapter = factory != null ? factory.create(entity) : new BasicInteractionAdapter(entity);
        String identifier = entity.registerExtendedProperties(ADAPTER_IDENTIFIER, (IExtendedEntityProperties)adapter);
        if (!identifier.equals(ADAPTER_IDENTIFIER)) {
            MobTalkerLog.fatal(LOG_TAG, "Unable to register adapter properly, result was: %s", identifier);
        }
        MobTalkerLog.trace(LOG_TAG, "Created adapter for '%s'", EntityUtil.getName(entity));
        IInteractionAdapterInitializer initializer = this._adapterInitializers.get(entityType);
        if (initializer != null) {
            initializer.initialize(adapter);
        }
        return adapter;
    }

    public void startInteraction(EntityLiving entity, EntityPlayerMP player) {
        IInteractionAdapter adapter = this.getAdapter((EntityLivingBase)entity);
        if (this._activeAdapters.contains(adapter)) {
            MobTalkerLog.warn(LOG_TAG, "Suppressing duplicate interaction request. Don't click so fast!");
            return;
        }
        String entityName = EntityUtil.getName(entity);
        String playerName = EntityUtil.getName((EntityPlayer)player);
        if (adapter == null) {
            MobTalkerLog.debug(LOG_TAG, "Entity '%s' does not have an adapter", entityName);
            return;
        }
        if (!adapter.canStartInteractionWith(player)) {
            MobTalkerLog.info(LOG_TAG, "'%s' cannot start an interaction with '%s'", playerName, entityName);
            return;
        }
        if (!MobTalkerEvent.queryReqestInteraction(adapter, (EntityPlayer)player)) {
            MobTalkerLog.debug(LOG_TAG, "Request to start interaction between '%s' and '%s' was denied by an event handler", playerName, entityName);
            return;
        }
        MobTalkerLog.info(LOG_TAG, "Starting interaction between '%s' and '%s'", playerName, entityName);
        adapter.setPlayer(player);
        this._activeAdapters.add(adapter);
        player.openGui((Object)MobTalker2.instance, 1, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        InteractionScript script = adapter.getScriptInstance();
        InteractionScriptFutureTask task = new InteractionScriptFutureTask(script);
        this._executor.submit(task);
        this._activeInteractions.put(adapter, task);
        adapter.onInteractionStart();
        MobTalkerEvent.notifyStartInteraction(adapter);
    }

    public void cancelInteraction(EntityPlayer player) {
        this.cancelInteraction(this.getAdapter(player));
    }

    public void cancelInteraction(IInteractionAdapter adapter) {
        String entityName = adapter.getEntityName();
        Preconditions.checkState((boolean)adapter.isActive(), (String)"Trying to end interaction for '%s' who does not have a partner!", (Object[])new Object[]{entityName});
        Preconditions.checkState((boolean)this._activeAdapters.contains(adapter), (String)"Corrupt InteractionRegistry: Adapter for '%s' has interaction partner but is not registered as active", (Object[])new Object[]{entityName});
        this._activeInteractions.get(adapter).cancel(true);
    }

    public void endInteraction(EntityPlayer player) {
        this.endInteraction(this.getAdapter(player));
    }

    public void endInteraction(IInteractionAdapter adapter) {
        String entityName = adapter.getEntityName();
        EntityPlayerMP player = adapter.getPlayer();
        String playerName = EntityUtil.getName((EntityPlayer)player);
        Preconditions.checkState((boolean)adapter.isActive(), (String)"Trying to end interaction for '%s' who does not have a partner!", (Object[])new Object[]{entityName});
        Preconditions.checkState((boolean)this._activeAdapters.contains(adapter), (String)"Corrupt InteractionRegistry: Adapter for '%s' has interaction partner but is not registered as active", (Object[])new Object[]{entityName});
        Preconditions.checkState((boolean)this._activeInteractions.get(adapter).isDone(), (String)"Interaction is not done yet. You have to cancel it to end it forcefully.", (Object[])new Object[]{entityName});
        MobTalkerLog.info(LOG_TAG, "Ending interaction between '%s' and '%s'", entityName, playerName);
        adapter.clearPlayer();
        this._activeAdapters.remove(adapter);
        this._activeInteractions.remove(adapter).cancel(true);
        if (player.field_71070_bA instanceof ServerInteractionHandler) {
            player.func_71053_j();
        } else {
            MobTalkerLog.fatal(LOG_TAG, "Open container should be '%s' since we had an active interaction, but it was '%s'", ServerInteractionHandler.class.getSimpleName(), player.field_71070_bA.getClass().getName());
        }
        adapter.onInteractionEnd();
        MobTalkerEvent.notifyEndInteraction(adapter);
    }

    public void endInteraction(EntityLiving entity) {
        IInteractionAdapter adapter = this.getAdapter((EntityLivingBase)entity);
        if (adapter == null) {
            MobTalkerLog.debug(LOG_TAG, "Entity '%s' does not have an adapter", EntityUtil.getName(entity));
            return;
        }
        this.endInteraction(adapter);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityInteractEvent(EntityInteractEvent event) {
        if (!(event.target instanceof EntityLiving) || !MobTalker2.isServer()) {
            return;
        }
        EntityLiving entity = (EntityLiving)event.target;
        EntityPlayerMP player = (EntityPlayerMP)event.entityPlayer;
        this.startInteraction(entity, player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (!MobTalker2.isServer() || !(event.entity instanceof EntityLiving)) {
            return;
        }
        EntityLiving entity = (EntityLiving)event.entity;
        IInteractionAdapter adapter = this.getAdapter((EntityLivingBase)entity);
        if (adapter != null) {
            adapter.onWorldChanged();
        } else if (this.canCreateAdapterFor(entity)) {
            adapter = this.createAdapter(entity);
            adapter.onSpawn(event.world);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public void onLivingAttack(LivingHurtEvent event) {
        if (!MobTalker2.isServer() || !(event.entity instanceof EntityLiving)) {
            return;
        }
        EntityLiving entity = (EntityLiving)event.entity;
        IInteractionAdapter adapter = this.getAdapter((EntityLivingBase)entity);
        if (adapter == null) {
            return;
        }
        if (!(event.source.func_76364_f() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.source.func_76364_f();
        adapter.onHitByEntity(attacker, event.source, event.ammount);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public void onEntityDeath(LivingDeathEvent event) {
        if (!MobTalker2.isServer() || !(event.entity instanceof EntityLiving)) {
            return;
        }
        EntityLiving entity = (EntityLiving)event.entity;
        IInteractionAdapter adapter = this.getAdapter((EntityLivingBase)entity);
        if (adapter == null) {
            return;
        }
        adapter.onDeath();
    }
}

