/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.script.lib;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.mobtalker.mobtalker2.server.interaction.IInteractionAdapter;
import net.mobtalker.mobtalker2.server.script.lib.AbstractInteractionLib;
import net.mobtalker.mobtalkerscript.util.MtsCheck;
import net.mobtalker.mobtalkerscript.v2.value.MtsBoolean;
import net.mobtalker.mobtalkerscript.v2.value.MtsNumber;
import net.mobtalker.mobtalkerscript.v2.value.MtsString;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;
import net.mobtalker.mobtalkerscript.v2.value.userdata.MtsNativeFunction;
import org.apache.commons.lang3.StringUtils;

public class InteractionWorldLib
extends AbstractInteractionLib {
    public InteractionWorldLib(IInteractionAdapter adapter) {
        super(adapter);
    }

    private BiomeGenBase getEntityBiome() {
        EntityLivingBase entity = this.getEntity();
        return entity.field_70170_p.func_72807_a((int)entity.field_70165_t, (int)entity.field_70161_v);
    }

    @MtsNativeFunction
    public MtsString getBiome() {
        BiomeGenBase biome = this.getEntityBiome();
        String name = StringUtils.remove((String)biome.field_76791_y, (char)' ');
        return MtsValue.valueOf(name);
    }

    @MtsNativeFunction
    public MtsVarArgs getClimate() {
        BiomeGenBase biome = this.getEntityBiome();
        float temperature = biome.field_76750_F;
        String temperatureCategory = BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) ? "hellish" : (temperature >= 2.0f ? "hot" : (temperature >= 1.2f ? "warm" : (temperature >= 0.2f ? "normal" : (temperature >= 0.05f ? "cold" : "icy"))));
        float humidity = biome.field_76751_G;
        String humidityCategory = "ardid";
        if (humidity >= 0.9f) {
            humidityCategory = "damp";
        } else if (humidity >= 0.3f) {
            humidityCategory = "normal";
        }
        return MtsVarArgs.of((MtsValue)MtsValue.valueOf(temperatureCategory), MtsValue.valueOf(humidityCategory));
    }

    @MtsNativeFunction
    public MtsVarArgs getWeather() {
        BiomeGenBase biome = this.getEntityBiome();
        World world = this.getWorld();
        boolean isRaining = world.func_72896_J();
        boolean canSnow = biome.func_76746_c();
        boolean isThundering = world.func_72911_I();
        String weather = "clear";
        if (isRaining) {
            weather = canSnow ? "snow" : "raining";
        }
        return MtsVarArgs.of((MtsValue)MtsValue.valueOf(weather), MtsValue.valueOf(isThundering));
    }

    @MtsNativeFunction
    public MtsNumber getID() {
        int id = this.getWorld().field_73011_w.field_76574_g;
        return MtsValue.valueOf(id);
    }

    @MtsNativeFunction
    public MtsNumber getMoonphase() {
        int phase = this.getWorld().func_72853_d();
        return MtsValue.valueOf(phase);
    }

    @MtsNativeFunction
    public MtsString getName() {
        String nameRaw = this.getWorld().field_73011_w.func_80007_l();
        String name = StringUtils.remove((String)nameRaw, (char)' ');
        return MtsValue.valueOf(name);
    }

    @MtsNativeFunction
    public MtsNumber getTime() {
        long time = this.getWorld().func_72820_D();
        return MtsValue.valueOf(time);
    }

    @MtsNativeFunction
    public MtsBoolean isDaytime() {
        boolean isDaytime = this.getWorld().func_72935_r();
        return MtsValue.valueOf(isDaytime);
    }

    @MtsNativeFunction
    public MtsString getType() {
        WorldType worldType = this.getWorld().field_73011_w.field_76577_b;
        String name = StringUtils.remove((String)worldType.func_77127_a(), (char)' ');
        name = StringUtils.capitalize((String)name);
        return MtsValue.valueOf(name);
    }

    @MtsNativeFunction
    public MtsVarArgs getDifficulty() {
        World world = this.getWorld();
        EnumDifficulty difficulty = world.field_73013_u;
        boolean isHardcore = world.func_72912_H().func_76093_s();
        String name = difficulty.func_151526_b().substring(19);
        return MtsVarArgs.of((MtsValue)MtsValue.valueOf(name), MtsValue.valueOf(isHardcore));
    }

    @MtsNativeFunction
    public MtsBoolean getGameRule(MtsValue argRuleName) {
        String ruleName = MtsCheck.checkString(argRuleName, 0);
        boolean isSet = this.getWorld().func_82736_K().func_82766_b(ruleName);
        return MtsValue.valueOf(isSet);
    }
}

