/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.scriptpack.config;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.mobtalker.mobtalker2.server.scriptpack.config.ScriptPackConfigException;

public class InteractionScriptConfig {
    private String _entity;
    private List<String> _paths;
    private Set<String> _savedVariables;
    private Set<String> _savedVariablesPerPlayer;

    public String getEntity() {
        return this._entity;
    }

    public void setEntity(String entity) {
        this._entity = entity;
    }

    public List<String> getFiles() {
        return this._paths;
    }

    public void setPaths(List<String> paths) {
        this._paths = paths;
    }

    public Set<String> getSavedVariables() {
        return this._savedVariables;
    }

    public void setSavedVariables(Set<String> savedVariables) {
        this._savedVariables = savedVariables;
    }

    public Set<String> getSavedVariablesPerPlayer() {
        return this._savedVariablesPerPlayer;
    }

    public void setSavedVariablesPerPlayer(Set<String> savedVariablesPerPlayer) {
        this._savedVariablesPerPlayer = savedVariablesPerPlayer;
    }

    public static class Deserializer
    implements JsonDeserializer<InteractionScriptConfig> {
        private static final String TAG_ENTITY = "Entity";
        private static final String TAG_FILES = "Files";
        private static final String TAG_SAVEDVARIABLES = "SavedVariables";
        private static final String TAG_SAVEDVARIABLESPERPLAYER = "SavedVariablesPerPlayer";

        public InteractionScriptConfig deserialize(JsonElement doc, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonRoot = doc.getAsJsonObject();
            InteractionScriptConfig config = new InteractionScriptConfig();
            if (!jsonRoot.has(TAG_ENTITY)) {
                throw new ScriptPackConfigException("missing tag: %s", TAG_ENTITY);
            }
            String entity = jsonRoot.get(TAG_ENTITY).getAsString();
            config.setEntity(entity);
            if (!jsonRoot.has(TAG_FILES)) {
                throw new ScriptPackConfigException("missing tag: %s", TAG_FILES);
            }
            JsonArray json = jsonRoot.getAsJsonArray(TAG_FILES);
            Object[] array = (String[])context.deserialize((JsonElement)json, String[].class);
            config.setPaths(Arrays.asList(array));
            if (jsonRoot.has(TAG_SAVEDVARIABLES)) {
                json = jsonRoot.getAsJsonArray(TAG_SAVEDVARIABLES);
                array = (String[])context.deserialize((JsonElement)json, String[].class);
                config.setSavedVariables((Set<String>)ImmutableSet.copyOf((Object[])array));
            } else {
                config.setSavedVariables((Set<String>)ImmutableSet.of());
            }
            if (jsonRoot.has(TAG_SAVEDVARIABLESPERPLAYER)) {
                json = jsonRoot.getAsJsonArray(TAG_SAVEDVARIABLESPERPLAYER);
                array = (String[])context.deserialize((JsonElement)json, String[].class);
                config.setSavedVariablesPerPlayer((Set<String>)ImmutableSet.copyOf((Object[])array));
            } else {
                config.setSavedVariablesPerPlayer((Set<String>)ImmutableSet.of());
            }
            return config;
        }
    }
}

