/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.server.scriptpack.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import net.mobtalker.mobtalker2.common.MobTalkerConfig;
import net.mobtalker.mobtalker2.server.scriptpack.config.InteractionScriptConfig;
import net.mobtalker.mobtalker2.server.scriptpack.config.ScriptPackConfigException;

public class ScriptPackConfig {
    private static final GsonBuilder _gsonPrototype = new GsonBuilder().registerTypeAdapter(ScriptPackConfig.class, (Object)new Deserializer()).registerTypeAdapter(InteractionScriptConfig.class, (Object)new InteractionScriptConfig.Deserializer());
    private String _title;
    private String _version;
    private String _descr;
    private List<String> _authors;
    private transient List<InteractionScriptConfig> _interactionScripts;

    public static void main(String[] args) throws IOException {
        ScriptPackConfig.read(Paths.get("C:/Users/Tobsen/Desktop/Minecraft/MobTalker2/MobTalker2.pack.json", new String[0]));
    }

    public static ScriptPackConfig read(Path path) throws IOException {
        ScriptPackConfig config;
        Gson gson = _gsonPrototype.create();
        try {
            config = (ScriptPackConfig)gson.fromJson((Reader)Files.newBufferedReader(path, MobTalkerConfig.CHARSET), ScriptPackConfig.class);
        }
        catch (JsonSyntaxException ex) {
            throw new ScriptPackConfigException(ex.getCause());
        }
        return config;
    }

    public static ScriptPackConfig read(InputStream stream) {
        ScriptPackConfig config;
        Gson gson = _gsonPrototype.create();
        try {
            config = (ScriptPackConfig)gson.fromJson((Reader)new InputStreamReader(stream, MobTalkerConfig.CHARSET), ScriptPackConfig.class);
        }
        catch (JsonSyntaxException ex) {
            throw new ScriptPackConfigException(ex.getCause());
        }
        return config;
    }

    public String getTitle() {
        return this._title;
    }

    public String getVersion() {
        return this._version;
    }

    public String getDescription() {
        return this._descr;
    }

    public List<String> getAuthors() {
        return this._authors;
    }

    public List<InteractionScriptConfig> getInteractionScripts() {
        return this._interactionScripts;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setDescription(String descr) {
        this._descr = descr;
    }

    public void setAuthors(List<String> authors) {
        this._authors = authors;
    }

    public void setInteractionScripts(List<InteractionScriptConfig> interactionScripts) {
        this._interactionScripts = interactionScripts;
    }

    public static class Deserializer
    implements JsonDeserializer<ScriptPackConfig> {
        private static final String TAG_TITLE = "Title";
        private static final String TAG_DESCRIPTION = "Description";
        private static final String TAG_VERSION = "Version";
        private static final String TAG_AUTHORS = "Authors";
        private static final String TAG_INTERACTION = "Interaction";

        public ScriptPackConfig deserialize(JsonElement doc, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonRoot = doc.getAsJsonObject();
            ScriptPackConfig config = new ScriptPackConfig();
            if (!jsonRoot.has(TAG_TITLE)) {
                throw new ScriptPackConfigException("missing tag: %s", TAG_TITLE);
            }
            String title = jsonRoot.get(TAG_TITLE).getAsString();
            config.setTitle(title);
            if (!jsonRoot.has(TAG_DESCRIPTION)) {
                throw new ScriptPackConfigException("missing tag: %s", TAG_DESCRIPTION);
            }
            String descr = jsonRoot.get(TAG_DESCRIPTION).getAsString();
            config.setDescription(descr);
            if (!jsonRoot.has(TAG_VERSION)) {
                throw new ScriptPackConfigException("missing tag: %s", TAG_VERSION);
            }
            String version = jsonRoot.get(TAG_VERSION).getAsString();
            config.setVersion(version);
            if (!jsonRoot.has(TAG_AUTHORS)) {
                throw new ScriptPackConfigException("missing tag: %s", TAG_AUTHORS);
            }
            JsonArray json = jsonRoot.getAsJsonArray(TAG_AUTHORS);
            Object[] array = (String[])context.deserialize((JsonElement)json, String[].class);
            config.setAuthors(Arrays.asList(array));
            if (jsonRoot.has(TAG_INTERACTION)) {
                json = jsonRoot.getAsJsonArray(TAG_INTERACTION);
                array = (InteractionScriptConfig[])context.deserialize((JsonElement)json, InteractionScriptConfig[].class);
                config.setInteractionScripts((List<InteractionScriptConfig>)ImmutableList.copyOf((Object[])array));
            } else {
                config.setInteractionScripts((List<InteractionScriptConfig>)ImmutableList.of());
            }
            return config;
        }
    }
}

