/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.util.mgt;

import cpw.mods.fml.common.toposort.TopologicalSort;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.mobtalker.mobtalker2.util.mgt.Dimension;
import net.mobtalker.mobtalker2.util.mgt.MGDrawable;

@SideOnly(value=Side.CLIENT)
public abstract class MGContainer
extends MGDrawable {
    protected static final Comparator<MGDrawable> ascZLevelComp = new Comparator<MGDrawable>(){

        @Override
        public int compare(MGDrawable a, MGDrawable b) {
            return a.getZLevel() - b.getZLevel();
        }
    };
    protected static final Comparator<MGDrawable> descZLevelComp = new Comparator<MGDrawable>(){

        @Override
        public int compare(MGDrawable a, MGDrawable b) {
            return b.getZLevel() - a.getZLevel();
        }
    };
    protected final List<MGDrawable> _zlevelOrder = new ArrayList<MGDrawable>(1);
    protected List<MGDrawable> _drawOrder = new ArrayList<MGDrawable>(1);

    @Override
    public void doDraw() {
        for (MGDrawable drawable : this._drawOrder) {
            drawable.draw();
        }
    }

    @Override
    public void doLayout(Dimension screenDim) {
        this.sortDependencies();
        for (MGDrawable drawable : this._drawOrder) {
            drawable.layout(screenDim);
        }
    }

    private void sortDependencies() {
        TopologicalSort.DirectedGraph graph = new TopologicalSort.DirectedGraph();
        Collections.sort(this._drawOrder, ascZLevelComp);
        for (MGDrawable d : this._drawOrder) {
            graph.addNode((Object)d);
        }
        for (MGDrawable d : this._drawOrder) {
            if (d.getParent() == null) continue;
            graph.addEdge((Object)d.getParent(), (Object)d);
        }
        this._drawOrder = TopologicalSort.topologicalSort((TopologicalSort.DirectedGraph)graph);
    }

    @Override
    public void update() {
        for (MGDrawable drawable : this._drawOrder) {
            drawable.update();
        }
    }

    @Override
    public boolean onMouseMoved(int x, int y, boolean concealed) {
        boolean consumed = false;
        for (MGDrawable drawable : this._zlevelOrder) {
            consumed |= drawable.onMouseMoved(x, y, consumed);
        }
        return consumed;
    }

    @Override
    public boolean onMouseClicked(int x, int y, int button) {
        if (!this.isVisible()) {
            return false;
        }
        for (MGDrawable drawable : this._zlevelOrder) {
            if (!drawable.onMouseClicked(x, y, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseUp(int x, int y) {
        if (!this.isVisible()) {
            return false;
        }
        for (MGDrawable drawable : this._zlevelOrder) {
            if (!drawable.onMouseUp(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyPressed(char eventChar, int eventKey) {
        if (!this.isVisible()) {
            return false;
        }
        for (MGDrawable drawable : this._zlevelOrder) {
            if (!drawable.onKeyPressed(eventChar, eventKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onClosed() {
        for (MGDrawable drawable : this._zlevelOrder) {
            drawable.onClosed();
        }
    }

    public void add(MGDrawable drawable) {
        if (this._zlevelOrder.contains(drawable)) {
            return;
        }
        this._zlevelOrder.add(drawable);
        this._drawOrder.add(drawable);
        Collections.sort(this._zlevelOrder, descZLevelComp);
    }

    public void addAll(Collection<? extends MGDrawable> drawables) {
        for (MGDrawable mGDrawable : drawables) {
            if (this._zlevelOrder.contains(drawables)) continue;
            this._zlevelOrder.add(mGDrawable);
            this._drawOrder.add(mGDrawable);
        }
        Collections.sort(this._zlevelOrder, descZLevelComp);
    }

    public void remove(MGDrawable drawables) {
        this._zlevelOrder.remove(drawables);
        this._drawOrder.remove(drawables);
    }

    public void removeAll(Collection<? extends MGDrawable> drawables) {
        this._zlevelOrder.removeAll(drawables);
        this._drawOrder.removeAll(drawables);
    }
}

