/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalker2.util.mgt;

import com.google.common.math.DoubleMath;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.RoundingMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.mobtalker.mobtalker2.util.SoundHelper;
import net.mobtalker.mobtalker2.util.mgt.Dimension;
import net.mobtalker.mobtalker2.util.mgt.IMouseListener;
import net.mobtalker.mobtalker2.util.mgt.MGComponent;
import net.mobtalker.mobtalker2.util.mgt.MouseListenerAdapter;
import net.mobtalker.mobtalker2.util.mgt.Point;
import net.mobtalker.mobtalker2.util.mgt.Rectangle;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class MGDrawable {
    public static final IMouseListener clickSoundListener = new MouseListenerAdapter(){

        @Override
        public void mouseClicked(MGComponent sender, int x, int y, int button) {
            SoundHelper.playSoundFX("gui.button.press", 1.0f);
        }
    };
    protected boolean _isValid = true;
    protected boolean _isVisible = true;
    protected Dimension _screenDim = new Dimension(1, 1);
    protected int _z;
    protected MGDrawable _parent;
    private Point _lastMousePoint = new Point(-1, -1);

    public final void draw() {
        this.draw(false);
    }

    public final void draw(boolean force) {
        if (force || this.isVisible()) {
            if (!this.isValid()) {
                this.layout(this._screenDim);
            }
            this.doDraw();
        }
    }

    protected abstract void doDraw();

    public boolean isValid() {
        return this._isValid;
    }

    public void invalidate() {
        this._isValid = false;
    }

    public final void layout(Dimension screenDim) {
        if (!screenDim.equals(this._screenDim)) {
            this._screenDim = screenDim;
        }
        this.doLayout(screenDim);
        this._isValid = true;
    }

    public abstract void doLayout(Dimension var1);

    public abstract void update();

    public final void onMouseUpdate(int x, int y) {
        if (!this._lastMousePoint.equals(x, y)) {
            this._lastMousePoint = new Point(x, y);
            this.onMouseMoved(x, y, false);
        }
    }

    public boolean onMouseMoved(int x, int y, boolean concealed) {
        return false;
    }

    public boolean onMouseClicked(int x, int y, int button) {
        return false;
    }

    public boolean onMouseUp(int x, int y) {
        return false;
    }

    public boolean onKeyPressed(char eventChar, int eventKey) {
        return false;
    }

    public void onClosed() {
    }

    public void setParent(MGDrawable parent) {
        this._parent = parent;
    }

    public MGDrawable getParent() {
        return this._parent;
    }

    public int getZLevel() {
        return this._z;
    }

    public void setZLevel(int z) {
        this._z = z;
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public void setVisible(boolean isVisible) {
        this._isVisible = isVisible;
    }

    public static void drawCornersTexture(Rectangle b, double z) {
        int cWidth = DoubleMath.roundToInt((double)((double)b.getWidth() / 2.0), (RoundingMode)RoundingMode.CEILING);
        int cHeight = DoubleMath.roundToInt((double)((double)b.getHeight() / 2.0), (RoundingMode)RoundingMode.CEILING);
        int fWidth = DoubleMath.roundToInt((double)((double)b.getWidth() / 2.0), (RoundingMode)RoundingMode.FLOOR);
        int fHeight = DoubleMath.roundToInt((double)((double)b.getHeight() / 2.0), (RoundingMode)RoundingMode.FLOOR);
        int tWidth = 256;
        int tHeight = 256;
        MGDrawable.drawTexture(b.getLeft(), b.getTop(), z, 0, 0, cWidth, cHeight);
        MGDrawable.drawTexture(b.getCenterX(), b.getTop(), z, tWidth - fWidth, 0, fWidth, cHeight);
        MGDrawable.drawTexture(b.getLeft(), b.getCenterY(), z, 0, tHeight - fHeight, cWidth, fHeight);
        MGDrawable.drawTexture(b.getCenterX(), b.getCenterY(), z, tWidth - fWidth, tHeight - fHeight, fWidth, fHeight);
    }

    public static void drawTexture(Rectangle b, double z, int u, int v) {
        Tessellator t = Tessellator.field_78398_a;
        double left = b.getLeft();
        double right = b.getRight();
        double top = b.getTop();
        double bottom = b.getBottom();
        double width = b.getWidth();
        double height = b.getHeight();
        float uScaling = 0.00390625f;
        float vScaling = 0.00390625f;
        t.func_78382_b();
        t.func_78374_a(left, bottom, z, (double)((float)u * 0.00390625f), ((double)v + height) * 0.00390625);
        t.func_78374_a(right, bottom, z, ((double)u + width) * 0.00390625, ((double)v + height) * 0.00390625);
        t.func_78374_a(right, top, z, ((double)u + width) * 0.00390625, (double)((float)v * 0.00390625f));
        t.func_78374_a(left, top, z, (double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f));
        t.func_78381_a();
    }

    public static void drawTexture(int x, int y, double z, int u, int v, int width, int height) {
        Tessellator t = Tessellator.field_78398_a;
        double left = x;
        double right = x + width;
        double top = y;
        double bottom = y + height;
        float uScaling = 0.00390625f;
        float vScaling = 0.00390625f;
        t.func_78382_b();
        t.func_78374_a(left, bottom, z, (double)((float)u * 0.00390625f), (double)((float)(v + height) * 0.00390625f));
        t.func_78374_a(right, bottom, z, (double)((float)(u + width) * 0.00390625f), (double)((float)(v + height) * 0.00390625f));
        t.func_78374_a(right, top, z, (double)((float)(u + width) * 0.00390625f), (double)((float)v * 0.00390625f));
        t.func_78374_a(left, top, z, (double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f));
        t.func_78381_a();
    }

    public static void drawTextureScaled(Rectangle b, double z, int u, int v) {
        Tessellator t = Tessellator.field_78398_a;
        double left = b.getLeft();
        double right = b.getRight();
        double top = b.getTop();
        double bottom = b.getBottom();
        double width = b.getWidth();
        double height = b.getHeight();
        double uScaling = 0.00390625 * (256.0 / width);
        double vScaling = 0.00390625 * (256.0 / height);
        t.func_78382_b();
        t.func_78374_a(left, bottom, z, (double)u * uScaling, ((double)v + height) * vScaling);
        t.func_78374_a(right, bottom, z, ((double)u + width) * uScaling, ((double)v + height) * vScaling);
        t.func_78374_a(right, top, z, ((double)u + width) * uScaling, (double)v * vScaling);
        t.func_78374_a(left, top, z, (double)u * uScaling, (double)v * vScaling);
        t.func_78381_a();
    }

    public static void drawRectangle(int x, int y, int z, int width, int height, float r, float g, float b, float a) {
        Tessellator t = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        t.func_78382_b();
        t.func_78377_a((double)x, (double)(y + height), (double)z);
        t.func_78377_a((double)(x + width), (double)(y + height), (double)z);
        t.func_78377_a((double)(x + width), (double)y, (double)z);
        t.func_78377_a((double)x, (double)y, (double)z);
        t.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawCenteredString(String s, int x, int y, int color) {
        FontRenderer r = MGDrawable.getFontRenderer();
        r.func_78261_a(s, x - r.func_78256_a(s) / 2, y, color);
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        MGDrawable.getTextureManager().func_110577_a(resourceLocation);
    }

    public static TextureManager getTextureManager() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static SoundHandler getSoundHandler() {
        return Minecraft.func_71410_x().func_147118_V();
    }
}

