/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.util;

import net.mobtalker.mobtalkerscript.v2.BadArgumentException;
import net.mobtalker.mobtalkerscript.v2.ScriptRuntimeException;
import net.mobtalker.mobtalkerscript.v2.value.MtsTable;
import net.mobtalker.mobtalkerscript.v2.value.MtsType;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;

public class MtsCheck {
    public static MtsValue checkNotNil(MtsValue mtsValue) {
        if (mtsValue.isNil()) {
            throw new BadArgumentException("value cannot be nil", new Object[0]);
        }
        return mtsValue;
    }

    public static MtsValue checkNotNil(MtsValue mtsValue, String string) {
        if (mtsValue.isNil()) {
            throw new BadArgumentException(string, new Object[0]);
        }
        return mtsValue;
    }

    public static MtsValue checkNotNil(MtsValue mtsValue, int n) {
        if (mtsValue.isNil()) {
            throw new ScriptRuntimeException("bad argument #%s (value expected, got %s)", n, mtsValue.getType());
        }
        return mtsValue;
    }

    public static MtsValue checkNotNil(MtsVarArgs mtsVarArgs, int n) {
        return MtsCheck.checkNotNil(mtsVarArgs.get(n), n);
    }

    public static MtsValue checkType(MtsValue mtsValue, int n, MtsType mtsType) {
        if (!mtsValue.is(mtsType)) {
            throw new BadArgumentException(n, mtsType, mtsValue.getType());
        }
        return mtsValue;
    }

    public static MtsTable checkTable(MtsValue mtsValue, int n) {
        if (mtsValue.isTable()) {
            return mtsValue.asTable();
        }
        throw new BadArgumentException(n, MtsType.TABLE, mtsValue.getType());
    }

    public static MtsTable checkTable(MtsVarArgs mtsVarArgs, int n) {
        return MtsCheck.checkTable(mtsVarArgs.get(n), n);
    }

    public static String checkString(MtsValue mtsValue, int n) {
        if (mtsValue.isString()) {
            return mtsValue.asString().asJavaString();
        }
        throw new BadArgumentException(n, MtsType.STRING, mtsValue.getType());
    }

    public static String checkString(MtsValue mtsValue, int n, String string) {
        if (mtsValue.isNil()) {
            return string;
        }
        if (mtsValue.isString()) {
            return mtsValue.asString().asJavaString();
        }
        throw new BadArgumentException(n, "%s or %s expected, got %s", MtsType.STRING, MtsType.NIL, mtsValue.getType());
    }

    public static String checkString(MtsVarArgs mtsVarArgs, int n) {
        return MtsCheck.checkString(mtsVarArgs.get(n), n);
    }

    public static String checkString(MtsVarArgs mtsVarArgs, int n, String string) {
        return MtsCheck.checkString(mtsVarArgs.get(n), n);
    }

    public static double checkNumber(MtsValue mtsValue, int n) {
        if (mtsValue.isNumber()) {
            return mtsValue.asNumber().asJavaDouble();
        }
        throw new BadArgumentException(n, MtsType.NUMBER, mtsValue.getType());
    }

    public static double checkNumber(MtsVarArgs mtsVarArgs, int n) {
        return MtsCheck.checkNumber(mtsVarArgs.get(n), n);
    }

    public static int checkInteger(MtsValue mtsValue, int n) {
        if (mtsValue.isNumber()) {
            return mtsValue.asNumber().asJavaInt();
        }
        throw new BadArgumentException(n, MtsType.NUMBER, mtsValue.getType());
    }

    public static int checkInteger(MtsValue mtsValue, int n, int n2) {
        if (mtsValue.isNil()) {
            return n2;
        }
        if (mtsValue.isNumber()) {
            return mtsValue.asNumber().asJavaInt();
        }
        throw new BadArgumentException(n, "%s or %s expected, got %s", MtsType.NUMBER, MtsType.NIL, mtsValue.getType());
    }

    public static int checkInteger(MtsVarArgs mtsVarArgs, int n) {
        return MtsCheck.checkInteger(mtsVarArgs.get(n), n);
    }

    public static int checkInteger(MtsVarArgs mtsVarArgs, int n, int n2) {
        return MtsCheck.checkInteger(mtsVarArgs.get(n), n, n2);
    }

    public static int checkIntegerWithMinimum(MtsValue mtsValue, int n, int n2) {
        int n3 = MtsCheck.checkInteger(mtsValue, n);
        if (n3 < n2) {
            throw new BadArgumentException(n, "number must be equal to or greater than %s, was %s", n2, mtsValue);
        }
        return n3;
    }
}

