/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.util.logging;

import com.google.common.base.Strings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

final class LogFormatter
extends Formatter {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    LogFormatter() {
    }

    @Override
    public final String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        Level level = logRecord.getLevel();
        String string = level.getLocalizedName();
        if (string == null) {
            string = level.getName();
        }
        if (string != null && string.length() > 0) {
            stringBuilder.append(Strings.padEnd((String)("[" + string + "] "), (int)9, (char)' '));
        } else {
            stringBuilder.append(" ");
        }
        if (logRecord.getLoggerName() != null) {
            stringBuilder.append("[" + logRecord.getLoggerName() + "] ");
        } else {
            stringBuilder.append("[] ");
        }
        stringBuilder.append(this.formatMessage(logRecord));
        stringBuilder.append(LINE_SEPARATOR);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringBuilder.append(stringWriter.toString());
        }
        return stringBuilder.toString();
    }
}

