/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.util.logging;

import java.util.Objects;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.mobtalker.mobtalkerscript.util.logging.LogFormatter;

public final class MtsLog {
    private static Logger LoggerParent;
    public static MtsLog CompilerLog;
    public static MtsLog EngineLog;
    private final Logger _log;

    public static void setLogger(Logger logger, boolean bl) {
        LoggerParent = logger;
        if (bl) {
            LoggerParent.setUseParentHandlers(false);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            consoleHandler.setFormatter(new LogFormatter());
            LoggerParent.addHandler(consoleHandler);
        }
        CompilerLog = new MtsLog(Logger.getLogger(logger.getName() + ".Compiler"));
        EngineLog = new MtsLog(Logger.getLogger(logger.getName() + ".Engine"));
        CompilerLog.getLogger().setUseParentHandlers(true);
        EngineLog.getLogger().setUseParentHandlers(true);
        CompilerLog.setLevel(Level.parse(System.getProperty("mts.log.compiler", "OFF")));
        EngineLog.setLevel(Level.parse(System.getProperty("mts.log.engine", "OFF")));
    }

    public MtsLog(Logger logger) {
        this._log = logger;
    }

    public final void setLevel(Level level) {
        this._log.setLevel(level);
    }

    public final Logger getLogger() {
        return this._log;
    }

    public final boolean isInfoEnabled() {
        return this._log.isLoggable(Level.INFO);
    }

    public final boolean isConfigEnabled() {
        return this._log.isLoggable(Level.CONFIG);
    }

    public final boolean isFineEnabled() {
        return this._log.isLoggable(Level.FINE);
    }

    public final boolean isFinerEnabled() {
        return this._log.isLoggable(Level.FINER);
    }

    public final boolean isFinestEnabled() {
        return this._log.isLoggable(Level.FINEST);
    }

    public final void log(Level level, Object object) {
        if (this._log.isLoggable(level)) {
            this._log.log(level, Objects.toString(object));
        }
    }

    public final void log(Level level, String string, Object ... objectArray) {
        if (this._log.isLoggable(level)) {
            this._log.log(level, String.format(string, objectArray));
        }
    }

    public final void log(Level level, Throwable throwable, String string, Object ... objectArray) {
        if (this._log.isLoggable(level)) {
            this._log.log(level, String.format(string, objectArray), throwable);
        }
    }

    public final void severe(Object object) {
        this.log(Level.SEVERE, object);
    }

    public final void severe(String string, Object ... objectArray) {
        this.log(Level.SEVERE, string, objectArray);
    }

    public final void severe(String string, Throwable throwable, Object ... objectArray) {
        this.log(Level.SEVERE, string, throwable, objectArray);
    }

    public final void warning(Object object) {
        this.log(Level.WARNING, object);
    }

    public final void warning(String string, Object ... objectArray) {
        this.log(Level.WARNING, string, objectArray);
    }

    public final void warning(String string, Throwable throwable, Object ... objectArray) {
        this.log(Level.WARNING, string, throwable, objectArray);
    }

    public final void info(String string, Object ... objectArray) {
        this.log(Level.INFO, string, objectArray);
    }

    public final void config(String string, Object ... objectArray) {
        this.log(Level.CONFIG, string, objectArray);
    }

    public final void fine(String string, Object ... objectArray) {
        this.log(Level.FINE, string, objectArray);
    }

    public final void finer(String string, Object ... objectArray) {
        this.log(Level.FINER, string, objectArray);
    }

    public final void finest(String string, Object ... objectArray) {
        this.log(Level.FINEST, string, objectArray);
    }
}

