/*
 * Decompiled with CFR 0.152.
 */
package net.mobtalker.mobtalkerscript.v2.instruction;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.mobtalker.mobtalkerscript.util.logging.MtsLog;
import net.mobtalker.mobtalkerscript.v2.ScriptEngineException;
import net.mobtalker.mobtalkerscript.v2.instruction.FrameValue;
import net.mobtalker.mobtalkerscript.v2.instruction.MtsInstruction;
import net.mobtalker.mobtalkerscript.v2.value.MtsClosure;
import net.mobtalker.mobtalkerscript.v2.value.MtsValue;
import net.mobtalker.mobtalkerscript.v2.value.MtsVarArgs;

public final class MtsFrame {
    private static boolean DEBUG = true;
    private final MtsClosure _closure;
    private int _ip;
    private final MtsValue[] _stack;
    private int _top;
    private final List<FrameValue> _locals;
    private final List<FrameValue> _externals;
    private String _lastVarOrConst;

    public static void enableDebug(boolean bl) {
        DEBUG = bl;
    }

    public MtsFrame(MtsClosure mtsClosure, MtsVarArgs mtsVarArgs, List<FrameValue> list) {
        int n;
        this._closure = mtsClosure;
        this._ip = 0;
        int n2 = mtsClosure.getPrototype().getMaxStackSize();
        int n3 = mtsClosure.getPrototype().getLocalCount();
        int n4 = mtsVarArgs.count();
        this._stack = new MtsValue[n2];
        this._top = 0;
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)n3);
        for (n = 0; n < n4; ++n) {
            arrayList.add(new FrameValue(mtsVarArgs.get(n)));
        }
        while (n < n3) {
            arrayList.add(new FrameValue());
            ++n;
        }
        this._locals = arrayList;
        this._externals = list;
        this._lastVarOrConst = "?";
    }

    public final MtsClosure getClosure() {
        return this._closure;
    }

    public final int getInstructionPointer() {
        return this._ip;
    }

    public final void setInstructionPointer(int n) {
        this._ip = n;
    }

    public final String getLastVariableOrConstant() {
        return this._lastVarOrConst;
    }

    public final MtsValue run() {
        Object object;
        List<MtsInstruction> list = this._closure.getPrototype().getInstructions();
        if (MtsLog.EngineLog.isFinestEnabled()) {
            MtsLog.EngineLog.finest("Stack: " + this.formatStack(), new Object[0]);
        }
        while (true) {
            object = list.get(this._ip);
            if (MtsLog.EngineLog.isInfoEnabled()) {
                Object[] objectArray = new Object[2];
                int n = list.size();
                MtsFrame mtsFrame = this;
                int n2 = Integer.toString(n).length();
                objectArray[0] = Strings.padStart((String)Integer.toString(mtsFrame._ip), (int)n2, (char)'0');
                objectArray[1] = ((MtsInstruction)object).toString(this.getClosure().getPrototype());
                MtsLog.EngineLog.info("Executing [%s] %s", objectArray);
            }
            ((MtsInstruction)object).execute(this);
            if (MtsLog.EngineLog.isFinestEnabled()) {
                MtsLog.EngineLog.finest("Stack: " + this.formatStack(), new Object[0]);
            }
            if (((MtsInstruction)object).exits()) break;
            ++this._ip;
        }
        object = this.pop();
        assert (this.stackIsEmpty()) : "Stack was not emptied! " + this.formatStack();
        return object;
    }

    private String formatStack() {
        int n;
        if (this._top == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        for (n = 0; n < this._top - 1; ++n) {
            stringBuilder.append(this._stack[n]).append(", ");
        }
        stringBuilder.append(this._stack[n]).append(']');
        return stringBuilder.toString();
    }

    public final MtsValue getConstant(int n) {
        MtsValue mtsValue = this._closure.getPrototype().getConstant(n);
        this._lastVarOrConst = DEBUG ? (mtsValue.isString() ? mtsValue.toString() : "?") : "?";
        return mtsValue;
    }

    public final FrameValue getLocal(int n) {
        this._lastVarOrConst = DEBUG ? this._closure.getPrototype().getLocalDescription(n).getName() : "?";
        return this._locals.get(n);
    }

    public final FrameValue getExternal(int n) {
        this._lastVarOrConst = DEBUG ? this._closure.getPrototype().getExternalDescription(n).getName() : "?";
        return this._externals.get(n);
    }

    public final void push(MtsValue mtsValue) {
        if (this._top == this._stack.length) {
            throw new ScriptEngineException("stack overflow");
        }
        this._stack[this._top++] = mtsValue;
    }

    public final MtsValue pop() {
        if (this.stackIsEmpty()) {
            throw new ScriptEngineException("stack underflow");
        }
        return this._stack[--this._top];
    }

    public final List<MtsValue> pop(int n) {
        if (n == 0) {
            return Collections.emptyList();
        }
        if (n > this.stackCount()) {
            throw new ScriptEngineException("stack underflow");
        }
        MtsValue[] mtsValueArray = new MtsValue[n];
        System.arraycopy(this._stack, this._top - n, mtsValueArray, 0, n);
        this._top -= n;
        return Arrays.asList(mtsValueArray);
    }

    public final MtsValue peek() {
        if (this.stackIsEmpty()) {
            throw new ScriptEngineException("stack is empty");
        }
        return this._stack[this._top - 1];
    }

    public final void duplicateTop() {
        if (this._top == this._stack.length) {
            throw new ScriptEngineException("stack overflow");
        }
        this._stack[this._top] = this._stack[this._top - 1];
        ++this._top;
    }

    public final void pushConstant(int n) {
        this.push(this.getConstant(n));
    }

    public final void pushLocal(int n) {
        this.push(this.getLocal(n).get());
    }

    public final void pushExternal(int n) {
        this.push(this.getExternal(n).get());
    }

    public final void storeLocal(int n) {
        this.getLocal(n).set(this.pop());
    }

    public final void storeExternal(int n) {
        this.getExternal(n).set(this.pop());
    }

    public final int stackCount() {
        return this._top;
    }

    public final boolean stackIsEmpty() {
        return this._top <= 0;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("Frame");
        stringBuilder.append(" [IP: ").append(this._ip);
        stringBuilder.append(", Last used Variable or Constant: ").append(this._lastVarOrConst);
        stringBuilder.append("]\n");
        stringBuilder.append(" Locals    ").append(this._locals.toString()).append("\n");
        stringBuilder.append(" Externals ").append(this._externals.toString()).append("\n");
        stringBuilder.append(" Stack     ").append(this.formatStack());
        return stringBuilder.toString();
    }
}

