/*
 * Decompiled with CFR 0.152.
 */
package org.abego.treelayout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeForTreeLayout;

public final class TreeLayout<TreeNode> {
    private final TreeForTreeLayout<TreeNode> tree;
    private final NodeExtentProvider<TreeNode> nodeExtentProvider;
    private final Configuration<TreeNode> configuration;
    private double boundsLeft = Double.MAX_VALUE;
    private double boundsRight = Double.MIN_VALUE;
    private double boundsTop = Double.MAX_VALUE;
    private double boundsBottom = Double.MIN_VALUE;
    private final List<Double> sizeOfLevel = new ArrayList<Double>();
    private final Map<TreeNode, Double> mod;
    private final Map<TreeNode, TreeNode> thread;
    private final Map<TreeNode, Double> prelim;
    private final Map<TreeNode, Double> change;
    private final Map<TreeNode, Double> shift;
    private final Map<TreeNode, TreeNode> ancestor;
    private final Map<TreeNode, Integer> number;
    private final Map<TreeNode, Point2D> positions;
    private Map<TreeNode, Rectangle2D.Double> nodeBounds;

    public final TreeForTreeLayout<TreeNode> getTree() {
        return this.tree;
    }

    private double getNodeHeight(TreeNode node) {
        return this.nodeExtentProvider.getHeight(node);
    }

    private double getNodeWidth(TreeNode node) {
        return this.nodeExtentProvider.getWidth(node);
    }

    private double getWidthOrHeightOfNode(TreeNode treeNode, boolean returnWidth) {
        if (returnWidth) {
            return this.getNodeWidth(treeNode);
        }
        return this.getNodeHeight(treeNode);
    }

    private double getNodeThickness(TreeNode treeNode) {
        return this.getWidthOrHeightOfNode(treeNode, !this.isLevelChangeInYAxis());
    }

    private double getNodeSize(TreeNode treeNode) {
        return this.getWidthOrHeightOfNode(treeNode, this.isLevelChangeInYAxis());
    }

    private boolean isLevelChangeInYAxis() {
        int rootLocation = this.configuration.getRootLocation$76e7c9b6();
        return rootLocation == 1 || rootLocation == 3;
    }

    public final Rectangle2D getBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.boundsRight - this.boundsLeft, this.boundsBottom - this.boundsTop);
    }

    private void calcSizeOfLevels(TreeNode node, int level) {
        double oldSize;
        if (this.sizeOfLevel.size() <= level) {
            this.sizeOfLevel.add(0.0);
            oldSize = 0.0;
        } else {
            oldSize = this.sizeOfLevel.get(level);
        }
        double size = this.getNodeThickness(node);
        if (oldSize < size) {
            this.sizeOfLevel.set(level, size);
        }
        if (!this.tree.isLeaf(node)) {
            for (TreeNode child : this.tree.getChildren(node)) {
                this.calcSizeOfLevels(child, level + 1);
            }
        }
    }

    private double getMod(TreeNode node) {
        Double d = this.mod.get(node);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private void setMod(TreeNode node, double d) {
        this.mod.put(node, d);
    }

    private TreeNode getThread(TreeNode node) {
        TreeNode n = this.thread.get(node);
        if (n != null) {
            return n;
        }
        return null;
    }

    private void setThread(TreeNode node, TreeNode thread) {
        this.thread.put(node, thread);
    }

    private double getPrelim(TreeNode node) {
        Double d = this.prelim.get(node);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private void setPrelim(TreeNode node, double d) {
        this.prelim.put(node, d);
    }

    private double getChange(TreeNode node) {
        Double d = this.change.get(node);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private void setChange(TreeNode node, double d) {
        this.change.put(node, d);
    }

    private double getShift(TreeNode node) {
        Double d = this.shift.get(node);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private double getDistance(TreeNode v, TreeNode w) {
        return (this.getNodeSize(v) + this.getNodeSize(w)) / 2.0 + this.configuration.getGapBetweenNodes$2838e59b();
    }

    private TreeNode nextLeft(TreeNode v) {
        if (this.tree.isLeaf(v)) {
            return this.getThread(v);
        }
        return this.tree.getFirstChild(v);
    }

    private TreeNode nextRight(TreeNode v) {
        if (this.tree.isLeaf(v)) {
            return this.getThread(v);
        }
        return this.tree.getLastChild(v);
    }

    private int getNumber(TreeNode node, TreeNode parentNode) {
        Integer n = this.number.get(node);
        if (n == null) {
            int i = 1;
            for (TreeNode child : this.tree.getChildren(parentNode)) {
                this.number.put(child, i++);
            }
            n = this.number.get(node);
        }
        return n;
    }

    private void firstWalk(TreeNode v, TreeNode leftSibling) {
        TreeLayout treeLayout;
        TreeNode TreeNode2;
        if (this.tree.isLeaf(v)) {
            TreeNode w = leftSibling;
            if (w != null) {
                this.setPrelim(v, this.getPrelim(w) + this.getDistance(v, w));
            }
            return;
        }
        TreeNode defaultAncestor = this.tree.getFirstChild(v);
        Object previousChild = null;
        for (TreeNode w : this.tree.getChildren(v)) {
            this.firstWalk(w, previousChild);
            TreeNode TreeNode3 = v;
            Object var11_13 = previousChild;
            TreeNode TreeNode4 = defaultAncestor;
            TreeNode2 = w;
            treeLayout = this;
            Object var13_16 = var11_13;
            if (var13_16 != null) {
                Iterator<TreeNode> iterator = TreeNode2;
                TreeNode TreeNode5 = TreeNode2;
                Object var16_19 = var13_16;
                TreeNode TreeNode6 = treeLayout.tree.getFirstChild(TreeNode3);
                Double d = treeLayout.getMod(TreeNode5);
                Double d2 = treeLayout.getMod(iterator);
                Double d3 = treeLayout.getMod(var16_19);
                Double d4 = treeLayout.getMod(TreeNode6);
                Object var22_25 = treeLayout.nextRight(var16_19);
                TreeNode TreeNode7 = treeLayout.nextLeft(TreeNode5);
                while (var22_25 != null && TreeNode7 != null) {
                    double d5;
                    var16_19 = var22_25;
                    TreeNode5 = TreeNode7;
                    TreeNode6 = treeLayout.nextLeft(TreeNode6);
                    iterator = treeLayout.nextRight(iterator);
                    TreeNode TreeNode8 = TreeNode2;
                    Iterator<TreeNode> iterator2 = iterator;
                    treeLayout.ancestor.put(iterator2, TreeNode8);
                    double d6 = treeLayout.getPrelim(var16_19) + d3 - (treeLayout.getPrelim(TreeNode5) + d) + treeLayout.getDistance(var16_19, TreeNode5);
                    if (d5 > 0.0) {
                        TreeNode TreeNode9 = TreeNode4;
                        TreeNode8 = TreeNode3;
                        iterator2 = var16_19;
                        TreeLayout treeLayout2 = treeLayout;
                        Iterator<TreeNode> iterator3 = iterator2;
                        TreeNode TreeNode10 = treeLayout2.ancestor.get(iterator3);
                        Object object = TreeNode10 != null ? TreeNode10 : iterator3;
                        Object object2 = treeLayout2.tree.isChildOfParent(object, TreeNode8) ? object : TreeNode9;
                        double d7 = d6;
                        TreeNode9 = TreeNode3;
                        TreeNode8 = TreeNode2;
                        iterator2 = object2;
                        treeLayout2 = treeLayout;
                        int n = treeLayout2.getNumber(TreeNode8, TreeNode9) - treeLayout2.getNumber(iterator2, TreeNode9);
                        treeLayout2.setChange(TreeNode8, treeLayout2.getChange(TreeNode8) - d7 / (double)n);
                        double d8 = treeLayout2.getShift(TreeNode8) + d7;
                        TreeNode10 = TreeNode8;
                        treeLayout2.shift.put(TreeNode10, d8);
                        treeLayout2.setChange(iterator2, treeLayout2.getChange(iterator2) + d7 / (double)n);
                        treeLayout2.setPrelim(TreeNode8, treeLayout2.getPrelim(TreeNode8) + d7);
                        treeLayout2.setMod(TreeNode8, treeLayout2.getMod(TreeNode8) + d7);
                        d = d + d6;
                        d2 = d2 + d6;
                    }
                    d3 = d3 + treeLayout.getMod(var16_19);
                    d = d + treeLayout.getMod(TreeNode5);
                    d4 = d4 + treeLayout.getMod(TreeNode6);
                    d2 = d2 + treeLayout.getMod(iterator);
                    var22_25 = treeLayout.nextRight(var16_19);
                    TreeNode7 = treeLayout.nextLeft(TreeNode5);
                }
                if (var22_25 != null && treeLayout.nextRight(iterator) == null) {
                    treeLayout.setThread(iterator, var22_25);
                    treeLayout.setMod(iterator, treeLayout.getMod(iterator) + d3 - d2);
                }
                if (TreeNode7 != null && treeLayout.nextLeft(TreeNode6) == null) {
                    treeLayout.setThread(TreeNode6, TreeNode7);
                    treeLayout.setMod(TreeNode6, treeLayout.getMod(TreeNode6) + d - d4);
                    TreeNode4 = TreeNode2;
                }
            }
            defaultAncestor = TreeNode4;
            previousChild = w;
        }
        TreeNode2 = v;
        treeLayout = this;
        double d = 0.0;
        double d9 = 0.0;
        for (TreeNode TreeNode5 : treeLayout.tree.getChildrenReverse(TreeNode2)) {
            treeLayout.setPrelim(TreeNode5, treeLayout.getPrelim(TreeNode5) + d);
            treeLayout.setMod(TreeNode5, treeLayout.getMod(TreeNode5) + d);
            d = d + treeLayout.getShift(TreeNode5) + (d9 += treeLayout.getChange(TreeNode5));
        }
        double midpoint = (this.getPrelim(this.tree.getFirstChild(v)) + this.getPrelim(this.tree.getLastChild(v))) / 2.0;
        TreeNode w = leftSibling;
        if (w != null) {
            this.setPrelim(v, this.getPrelim(w) + this.getDistance(v, w));
            this.setMod(v, this.getPrelim(v) - midpoint);
            return;
        }
        this.setPrelim(v, midpoint);
    }

    private void secondWalk(TreeNode v, double m, int level, double levelStart) {
        int n = this.configuration.getRootLocation$76e7c9b6();
        double levelChangeSign = n == 3 || n == 4 ? -1 : 1;
        boolean levelChangeOnYAxis = this.isLevelChangeInYAxis();
        n = level;
        TreeLayout treeLayout = this;
        Configuration.checkArg(n >= 0, "level must be >= 0");
        Configuration.checkArg(n < treeLayout.sizeOfLevel.size(), "level must be < levelCount");
        double levelSize = treeLayout.sizeOfLevel.get(n);
        double x = this.getPrelim(v) + m;
        int alignment = this.configuration.getAlignmentInLevel$223b8ce3();
        double y = alignment == 1 ? levelStart + levelChangeSign * (levelSize / 2.0) : (alignment == 2 ? levelStart + levelChangeSign * (this.getNodeThickness(v) / 2.0) : levelStart + levelSize - levelChangeSign * (this.getNodeThickness(v) / 2.0));
        if (!levelChangeOnYAxis) {
            double t = x;
            x = y;
            y = t;
        }
        this.positions.put(v, new NormalizedPosition(this, x, y));
        double d = y;
        double d2 = x;
        TreeNode TreeNode2 = v;
        treeLayout = this;
        double d3 = treeLayout.getNodeWidth(TreeNode2);
        double d4 = treeLayout.getNodeHeight(TreeNode2);
        double d5 = d2 - d3 / 2.0;
        double d6 = d2 + d3 / 2.0;
        double d7 = d - d4 / 2.0;
        double d8 = d + d4 / 2.0;
        if (treeLayout.boundsLeft > d5) {
            treeLayout.boundsLeft = d5;
        }
        if (treeLayout.boundsRight < d6) {
            treeLayout.boundsRight = d6;
        }
        if (treeLayout.boundsTop > d7) {
            treeLayout.boundsTop = d7;
        }
        if (treeLayout.boundsBottom < d8) {
            treeLayout.boundsBottom = d8;
        }
        if (!this.tree.isLeaf(v)) {
            double nextLevelStart = levelStart + (levelSize + this.configuration.getGapBetweenLevels$13461c()) * levelChangeSign;
            for (TreeNode w : this.tree.getChildren(v)) {
                this.secondWalk(w, m + this.getMod(v), level + 1, nextLevelStart);
            }
        }
    }

    public final Map<TreeNode, Rectangle2D.Double> getNodeBounds() {
        if (this.nodeBounds == null) {
            this.nodeBounds = new IdentityHashMap<TreeNode, Rectangle2D.Double>();
            for (Map.Entry<TreeNode, Point2D> entry : this.positions.entrySet()) {
                TreeNode node = entry.getKey();
                Point2D pos = entry.getValue();
                double w = this.getNodeWidth(node);
                double h = this.getNodeHeight(node);
                double x = pos.getX() - w / 2.0;
                double y = pos.getY() - h / 2.0;
                this.nodeBounds.put(node, new Rectangle2D.Double(x, y, w, h));
            }
        }
        return this.nodeBounds;
    }

    public TreeLayout(TreeForTreeLayout<TreeNode> tree, NodeExtentProvider<TreeNode> nodeExtentProvider, Configuration<TreeNode> configuration) {
        this.tree = tree;
        this.nodeExtentProvider = nodeExtentProvider;
        this.configuration = configuration;
        this.mod = new IdentityHashMap<TreeNode, Double>();
        this.thread = new IdentityHashMap<TreeNode, TreeNode>();
        this.prelim = new IdentityHashMap<TreeNode, Double>();
        this.change = new IdentityHashMap<TreeNode, Double>();
        this.shift = new IdentityHashMap<TreeNode, Double>();
        this.ancestor = new IdentityHashMap<TreeNode, TreeNode>();
        this.number = new IdentityHashMap<TreeNode, Integer>();
        this.positions = new IdentityHashMap<TreeNode, Point2D>();
        TreeNode r = tree.getRoot();
        this.firstWalk(r, null);
        this.calcSizeOfLevels(r, 0);
        this.secondWalk(r, -this.getPrelim(r), 0, 0.0);
    }

    final class NormalizedPosition
    extends Point2D {
        private double x_relativeToRoot;
        private double y_relativeToRoot;
        private /* synthetic */ TreeLayout this$0;

        public NormalizedPosition(TreeLayout treeLayout, double x_relativeToRoot, double y_relativeToRoot) {
            this.this$0 = treeLayout;
            this.setLocation(x_relativeToRoot, y_relativeToRoot);
        }

        @Override
        public final double getX() {
            return this.x_relativeToRoot - this.this$0.boundsLeft;
        }

        @Override
        public final double getY() {
            return this.y_relativeToRoot - this.this$0.boundsTop;
        }

        @Override
        public final void setLocation(double x_relativeToRoot, double y_relativeToRoot) {
            this.x_relativeToRoot = x_relativeToRoot;
            this.y_relativeToRoot = y_relativeToRoot;
        }
    }
}

