/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.util.Arrays;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.atn.LexerAction;
import org.antlr.v4.runtime.atn.LexerIndexedCustomAction;
import org.antlr.v4.runtime.misc.MurmurHash;

public class LexerActionExecutor {
    private final LexerAction[] lexerActions;
    private final int hashCode;

    private LexerActionExecutor(LexerAction[] lexerActions) {
        this.lexerActions = lexerActions;
        int hash = 0;
        LexerAction[] arr$ = lexerActions;
        int len$ = lexerActions.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            LexerAction lexerAction = arr$[i$];
            hash = MurmurHash.update(hash, lexerAction);
        }
        this.hashCode = MurmurHash.finish(hash, lexerActions.length);
    }

    public static LexerActionExecutor append(LexerActionExecutor lexerActionExecutor, LexerAction lexerAction) {
        if (lexerActionExecutor == null) {
            return new LexerActionExecutor(new LexerAction[]{lexerAction});
        }
        LexerAction[] lexerActionArray = Arrays.copyOf(lexerActionExecutor.lexerActions, lexerActionExecutor.lexerActions.length + 1);
        LexerAction[] lexerActions = lexerActionArray;
        lexerActionArray[lexerActionArray.length - 1] = lexerAction;
        return new LexerActionExecutor(lexerActions);
    }

    public final LexerActionExecutor fixOffsetBeforeMatch(int offset) {
        LexerAction[] updatedLexerActions = null;
        for (int i = 0; i < this.lexerActions.length; ++i) {
            if (!this.lexerActions[i].isPositionDependent() || this.lexerActions[i] instanceof LexerIndexedCustomAction) continue;
            if (updatedLexerActions == null) {
                updatedLexerActions = (LexerAction[])this.lexerActions.clone();
            }
            updatedLexerActions[i] = new LexerIndexedCustomAction(offset, this.lexerActions[i]);
        }
        if (updatedLexerActions == null) {
            return this;
        }
        return new LexerActionExecutor(updatedLexerActions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void execute(Lexer lexer, CharStream input, int startIndex) {
        boolean requiresSeek = false;
        int stopIndex = input.index();
        try {
            LexerAction[] arr$ = this.lexerActions;
            int len$ = this.lexerActions.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                LexerAction lexerAction = arr$[i$];
                if (lexerAction instanceof LexerIndexedCustomAction) {
                    int offset = ((LexerIndexedCustomAction)lexerAction).getOffset();
                    input.seek(startIndex + offset);
                    lexerAction = ((LexerIndexedCustomAction)lexerAction).getAction();
                    requiresSeek = startIndex + offset != stopIndex;
                } else if (lexerAction.isPositionDependent()) {
                    input.seek(stopIndex);
                    requiresSeek = false;
                }
                lexerAction.execute(lexer);
            }
            if (!requiresSeek) return;
        }
        catch (Throwable throwable) {
            if (!requiresSeek) throw throwable;
            input.seek(stopIndex);
            throw throwable;
        }
        input.seek(stopIndex);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LexerActionExecutor)) {
            return false;
        }
        LexerActionExecutor other = (LexerActionExecutor)obj;
        return this.hashCode == other.hashCode && Arrays.equals(this.lexerActions, other.lexerActions);
    }
}

