/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.ObjectEqualityComparator;

public class FlexibleHashMap<K, V>
implements Map<K, V> {
    private AbstractEqualityComparator<? super K> comparator;
    private LinkedList<Entry<K, V>>[] buckets;
    private int n = 0;
    private int threshold = 12;
    private int currentPrime = 1;

    public FlexibleHashMap(AbstractEqualityComparator<? super K> comparator) {
        this(comparator, 0);
    }

    private FlexibleHashMap(AbstractEqualityComparator<? super K> comparator, byte by) {
        if (comparator == null) {
            comparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = comparator;
        this.buckets = new LinkedList[8];
    }

    private int getBucket(K key) {
        return this.comparator.hashCode(key) & this.buckets.length - 1;
    }

    @Override
    public V get(Object key) {
        Object typedKey = key;
        if (key == null) {
            return null;
        }
        int b = this.getBucket(typedKey);
        LinkedList<Entry<K, V>> bucket = this.buckets[b];
        if (bucket == null) {
            return null;
        }
        for (Entry entry : bucket) {
            if (!this.comparator.equals(entry.key, typedKey)) continue;
            return entry.value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        int b;
        LinkedList<Entry<K, V>> bucket;
        if (key == null) {
            return null;
        }
        if (this.n > this.threshold) {
            FlexibleHashMap flexibleHashMap = this;
            LinkedList<Entry<K, V>>[] linkedListArray = flexibleHashMap.buckets;
            flexibleHashMap.currentPrime += 4;
            int n = flexibleHashMap.buckets.length << 1;
            LinkedList[] linkedListArray2 = new LinkedList[n];
            flexibleHashMap.buckets = linkedListArray2;
            flexibleHashMap.threshold = (int)((double)n * 0.75);
            int n2 = flexibleHashMap.size();
            LinkedList<Entry<K, V>>[] linkedListArray3 = linkedListArray;
            int n3 = linkedListArray.length;
            for (int i = 0; i < n3; ++i) {
                Entry entry;
                LinkedList<Entry<K, V>> linkedList = linkedListArray3[i];
                if (linkedList == null) continue;
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext() && (entry = (Entry)iterator.next()) != null) {
                    flexibleHashMap.put(entry.key, entry.value);
                }
            }
            flexibleHashMap.n = n2;
        }
        if ((bucket = this.buckets[b = this.getBucket(key)]) == null) {
            this.buckets[b] = new LinkedList();
            bucket = this.buckets[b];
        }
        for (Entry entry : bucket) {
            if (!this.comparator.equals(entry.key, key)) continue;
            Object prev = entry.value;
            entry.value = value;
            ++this.n;
            return prev;
        }
        bucket.add(new Entry<K, V>(key, value));
        ++this.n;
        return null;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        ArrayList a = new ArrayList(this.size());
        LinkedList<Entry<K, V>>[] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            LinkedList<Entry<K, V>> bucket = arr$[i$];
            if (bucket == null) continue;
            for (Entry entry : bucket) {
                a.add(entry.value);
            }
        }
        return a;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int hash = 0;
        LinkedList<Entry<K, V>>[] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Entry e;
            LinkedList<Entry<K, V>> bucket = arr$[i$];
            if (bucket == null) continue;
            Iterator i$2 = bucket.iterator();
            while (i$2.hasNext() && (e = (Entry)i$2.next()) != null) {
                hash = MurmurHash.update(hash, this.comparator.hashCode(e.key));
            }
        }
        return MurmurHash.finish(hash, this.size());
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public void clear() {
        this.buckets = new LinkedList[16];
        this.n = 0;
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        boolean first = true;
        LinkedList<Entry<K, V>>[] arr$ = this.buckets;
        int len$ = this.buckets.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Entry e;
            LinkedList<Entry<K, V>> bucket = arr$[i$];
            if (bucket == null) continue;
            Iterator i$2 = bucket.iterator();
            while (i$2.hasNext() && (e = (Entry)i$2.next()) != null) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(e.toString());
            }
        }
        buf.append('}');
        return buf.toString();
    }

    public static class Entry<K, V> {
        public final K key;
        public V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key.toString() + ":" + this.value.toString();
        }
    }
}

