/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.helpers;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.helpers.McKeyBindHelper;
import com.shiny.joypadmod.inputevent.ControllerBinding;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.input.Controller;

public class ConfigFile {
    public int preferedJoyNo;
    public String preferedJoyName;
    private Configuration config;
    private File _configFile;
    private String userName;
    private String userCategory;
    private String bindingComment = "S:<actionID>=<Menu String>,{ <keycode> },<AXIS/BUTTON/POV>,<INDEX>,<THRESHOLD>,<DEADZONE>,<BINDING_OPTIONS1>,<BINDING_OPTIONS2>...";
    private List<ControllerBinding> controlBindingsFromConfigFile = new ArrayList<ControllerBinding>();
    private String globalCat = "-Global-";
    private double lastConfigFileVersion;

    public ConfigFile(File configFile) {
        this._configFile = configFile;
        this.reload();
    }

    private void reload() {
        this.config = new Configuration(this._configFile, true);
    }

    public void init() {
        this.config.load();
        ControllerSettings.loggingLevel = this.config.get(this.globalCat, "LoggingLevel", 1).getInt();
        this.userName = "unknown";
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_110432_I() != null) {
            this.userName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        }
        this.setSharedProfile(this.config.get(this.globalCat, "SharedProfile", false).getBoolean(false));
        this.userCategory = "Joypad-" + this.userName;
        if (this.config.hasCategory(this.userCategory.toLowerCase())) {
            this.config.removeCategory(this.config.getCategory(this.userCategory.toLowerCase()));
        }
        this.preferedJoyNo = this.config.get(this.userCategory, "JoyNo", -1).getInt();
        this.preferedJoyName = this.config.get(this.userCategory, "JoyName", "").getString();
        ControllerSettings.invertYAxis = this.config.get(this.userCategory, "InvertY", false).getBoolean(false);
        ControllerSettings.displayHints = this.config.get(this.userCategory, "DisplayHints", true).getBoolean(true);
        this.lastConfigFileVersion = this.config.get(this.getDefaultCategory(), "ConfigVersion", 0.07).getDouble(0.07);
        if (this.lastConfigFileVersion < 0.0953) {
            this.deleteKey("-UserBindings-", "NumBindings");
        }
        LogHelper.Info(this.userName + "'s JoyNo == " + this.preferedJoyNo + " (" + this.preferedJoyName + "). SharedProfile = " + this.getConfigFileSetting("-Global-.SharedProfile") + ". GrabMouse = " + this.getConfigFileSetting("-Global-.GrabMouse") + ".  invertYAxis = " + ControllerSettings.invertYAxis + ". ConfigVersion " + this.lastConfigFileVersion + ". Game Sensitivity multiplier: " + ControllerSettings.inGameSensitivity + ". Menu Sensitivity multiplier: " + ControllerSettings.inMenuSensitivity);
        this.addBindingOptionsComment();
        this.addGlobalOptionsComment();
        this.updateKey(this.getDefaultCategory(), "ConfigVersion", String.valueOf(0.21f), true);
    }

    public String getDefaultCategory() {
        if (this.config.get(this.globalCat, "SharedProfile", false).getString().equals("true")) {
            return "Joypad--Shared-";
        }
        return "Joypad-" + this.userName;
    }

    public void setSharedProfile(boolean shared) {
        LogHelper.Info("Setting shared profile to " + shared);
        this.updateKey(this.globalCat, "SharedProfile", "" + shared, true);
        ControllerSettings.inGameSensitivity = this.config.get(this.getDefaultCategory(), "GameSensitivity", 40).getInt();
        ControllerSettings.inMenuSensitivity = this.config.get(this.getDefaultCategory(), "GuiSensitivity", 10).getInt();
    }

    public void addComment(String category, String comment) {
        this.config.addCustomCategoryComment(category, comment);
        this.config.save();
    }

    public void updatePreferedJoy(int joyNo, String joyName) {
        String category = this.userCategory;
        this.updateKey(category, "JoyNo", "" + joyNo, false);
        this.updateKey(category, "JoyName", joyName, true);
    }

    public void updateConfigFileSetting(UserJoypadSettings setting, String value) {
        String category;
        switch (setting) {
            case JoyNo: 
            case JoyName: 
            case InvertY: {
                category = this.userCategory;
                break;
            }
            default: {
                category = this.getDefaultCategory();
            }
        }
        this.updateKey(category, setting.toString(), value, true);
    }

    public String getConfigFileSetting(String categoryKey) {
        if (categoryKey.contains("-User-")) {
            categoryKey = categoryKey.replace("-User-", this.userCategory);
        }
        int lastIndex = categoryKey.lastIndexOf(46);
        String category = categoryKey.substring(0, lastIndex);
        String key = categoryKey.substring(lastIndex + 1);
        return this.config.get(category, key, "false").getString();
    }

    public void setConfigFileSetting(String categoryKey, String value) {
        if (categoryKey.contains("-User-")) {
            categoryKey = categoryKey.replace("-User-", this.userCategory);
        }
        int lastIndex = categoryKey.lastIndexOf(46);
        String category = categoryKey.substring(0, lastIndex);
        String key = categoryKey.substring(lastIndex + 1);
        this.setConfigFileSetting(category, key, value);
    }

    public void setConfigFileSetting(String category, String key, String value) {
        this.updateKey(category, key, value, true);
    }

    public void applySavedDeadZones(Controller c) {
        ConfigCategory cc = this.config.getCategory("-Deadzones-." + c.getName());
        for (int i = 0; i < c.getAxisCount(); ++i) {
            String key = c.getAxisName(i);
            if (!cc.containsKey(key)) continue;
            try {
                String floatStr = cc.get(key).getString();
                LogHelper.Info("Applying deadzone value " + floatStr + " to " + c.getAxisName(i));
                c.setDeadZone(i, Float.parseFloat(floatStr));
                continue;
            }
            catch (Exception ex) {
                LogHelper.Error("Failed trying to apply deadzone for " + c.getAxisName(i) + " using the value for " + key + " from the config file");
            }
        }
    }

    public Map<String, String> buildStringMapFromConfig(String cat, String name) {
        String catName = cat + "." + name;
        if (!this.config.hasCategory(catName)) {
            LogHelper.Info("No category name mapping found for: " + catName);
            return null;
        }
        ConfigCategory cc = this.config.getCategory(catName);
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (String key : cc.keySet()) {
            String nameMap = cc.get(key).getString();
            retMap.put(key, nameMap);
        }
        return retMap;
    }

    public void saveStringMap(String category, String setName, Map<String, String> map, String comment) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.setConfigFileSetting(category + "." + setName, entry.getKey(), entry.getValue());
        }
        if (comment != null && !comment.isEmpty()) {
            this.addComment(category, comment);
        }
    }

    public void deleteUserBinding(ControllerBinding binding) {
        String catToUpdate = "-UserBindings-";
        LogHelper.Info("Attempting to delete " + binding.inputString + " " + binding.toConfigFileString() + " for " + catToUpdate);
        this.deleteKey(catToUpdate, binding.inputString);
    }

    public void saveControllerBinding(String joyName, ControllerBinding binding) {
        this.saveControllerBindingInternal(joyName, binding, true);
    }

    public List<ControllerBinding> getUserDefinedBindings(int joyNo) {
        String category = "-UserBindings-";
        ControllerSettings.userDefinedBindings.clear();
        ConfigCategory cc = this.config.getCategory(category);
        for (String key : cc.keySet()) {
            String bindSettings = cc.get(key).getString();
            try {
                ControllerBinding binding = new ControllerBinding(key + "," + bindSettings, joyNo, this.lastConfigFileVersion);
                if (!binding.hasCategory()) {
                    binding.bindingOptions.add(ControllerBinding.BindingOptions.CATEGORY_MISC);
                }
                ControllerSettings.userDefinedBindings.add(binding);
            }
            catch (Exception ex) {
                LogHelper.Error("Exception caught trying to process user binding " + bindSettings + " Exception " + ex.toString());
            }
        }
        return ControllerSettings.userDefinedBindings;
    }

    public void getJoypadSavedBindings(int joyNo, String joyName) {
        double lastJoyConfigVersion;
        String category = this.getDefaultCategory() + "." + joyName;
        if (!this.config.hasCategory(category)) {
            return;
        }
        boolean cleanupBindings = (lastJoyConfigVersion = this.config.get(category, "ConfigVersion", 0.07).getDouble(0.07)) < 0.0953;
        int numBindingsFound = this.populateBindingList(joyNo, joyName, lastJoyConfigVersion, cleanupBindings);
        if (numBindingsFound <= 0) {
            return;
        }
        try {
            if (cleanupBindings) {
                this.config.save();
                this.reload();
            }
            for (ControllerBinding binding : this.controlBindingsFromConfigFile) {
                try {
                    this.saveControllerBindingInternal(joyName, binding, false);
                }
                catch (Exception ex) {
                    LogHelper.Error("Failed trying to save controller binding: " + binding.toConfigFileString() + " Exception: " + ex.toString());
                }
            }
            this.updateKey(category, "ConfigVersion", String.valueOf(0.21f), true);
        }
        catch (Exception ex) {
            LogHelper.Error("Failed calling updateControllerBindings from config file. Exception: " + ex.toString());
        }
    }

    private int populateBindingList(int joyNo, String joyName, double lastJoyConfigVersion, boolean cleanupCategories) {
        if (joyNo < 0) {
            LogHelper.Info("Not processing joyNo " + joyNo);
            return 0;
        }
        this.controlBindingsFromConfigFile.clear();
        String category = this.getDefaultCategory() + "." + joyName;
        this.processJoyCategory(this.config.getCategory(category), joyNo, lastJoyConfigVersion, cleanupCategories);
        return this.controlBindingsFromConfigFile.size();
    }

    private void processJoyCategory(ConfigCategory joyCategory, int joyNo, double lastVersion, boolean cleanupCategories) {
        if (!joyCategory.getChildren().isEmpty()) {
            for (ConfigCategory child : joyCategory.getChildren()) {
                this.processJoyCategory(child, joyNo, lastVersion, cleanupCategories);
                if (!cleanupCategories) continue;
                joyCategory.removeChild(child);
            }
            return;
        }
        for (String key : joyCategory.keySet()) {
            if (!key.contains("joy.") && McKeyBindHelper.getMinecraftKeyBind(key) == null) {
                LogHelper.Info("Skipping binding " + key + " from config file as Minecraft isn't using it this session");
                continue;
            }
            String bindSettings = joyCategory.get(key).getString();
            if (!bindSettings.isEmpty()) {
                try {
                    ControllerBinding b = new ControllerBinding(key + "," + bindSettings, joyNo, lastVersion);
                    if (b.inputString != null) {
                        ControllerBinding targetBinding;
                        if (cleanupCategories && (targetBinding = ControllerSettings.get(b.inputString)) != null) {
                            targetBinding.inputEvent = b.inputEvent;
                            if (b.bindingOptions.contains((Object)ControllerBinding.BindingOptions.IS_TOGGLE)) {
                                targetBinding.bindingOptions.add(ControllerBinding.BindingOptions.IS_TOGGLE);
                            }
                            if (b.bindingOptions.contains((Object)ControllerBinding.BindingOptions.RENDER_TICK)) {
                                targetBinding.bindingOptions.add(ControllerBinding.BindingOptions.RENDER_TICK);
                            }
                            b = targetBinding;
                        }
                        this.controlBindingsFromConfigFile.add(b);
                        ControllerSettings.joyBindingsMap.put(b.inputString, b);
                    }
                }
                catch (Exception ex) {
                    LogHelper.Error("Failed parsing config string " + bindSettings);
                }
            }
            if (!cleanupCategories) continue;
            joyCategory.remove((Object)key);
        }
    }

    private void saveControllerBindingInternal(String joyName, ControllerBinding binding, boolean save) {
        boolean userBinding = binding.inputString.toLowerCase().contains("user");
        String catToUpdate = userBinding ? "-UserBindings-" : this.createConfigSettingString(joyName, binding.inputString);
        LogHelper.Info("Attempting to save " + binding.inputString + " " + binding.toConfigFileString() + " for " + catToUpdate);
        this.updateKey(catToUpdate, binding.inputString, binding.toConfigFileString(), save);
        ConfigCategory cc = this.config.getCategory(catToUpdate);
        cc.setComment(this.bindingComment);
        if (save) {
            this.config.save();
        }
    }

    private String createConfigSettingString(String joyName, String controlString) {
        return this.getDefaultCategory() + "." + joyName + "." + controlString;
    }

    private boolean deleteKey(String category, String key) {
        if (!this.config.hasCategory(category)) {
            return false;
        }
        if (null != this.config.getCategory(category).remove((Object)key)) {
            this.config.save();
            LogHelper.Info("Deleted category " + category + " key " + key);
            return true;
        }
        return false;
    }

    private boolean updateKey(String category, String key, String value, boolean save) {
        boolean bRet = false;
        try {
            bRet = !this.deleteKey(category, key);
            this.config.get(category, key, value);
            LogHelper.Info(String.format("updateKey %s %s:%s with %s", bRet ? "created" : "updated", category, key, value));
            if (save) {
                this.config.save();
            }
        }
        catch (Exception ex) {
            LogHelper.Error("Failed trying to save key " + category + " value " + key + ":" + value + ". Exception: " + ex.toString());
        }
        return bRet;
    }

    private void addBindingOptionsComment() {
        ControllerBinding.BindingOptions[] bos;
        for (ControllerBinding.BindingOptions bo : bos = ControllerBinding.BindingOptions.values()) {
            this.config.get("-BindingOptions-", bo.toString(), " " + ControllerBinding.BindingOptionsComment[bo.ordinal()]);
        }
        this.config.addCustomCategoryComment("-BindingOptions-", "List of valid binding options that can be combined with Controller events");
    }

    private void addGlobalOptionsComment() {
        this.config.addCustomCategoryComment(this.globalCat, "GrabMouse = will grab mouse when in game (generally not good for splitscreen)\r\nLoggingLevel = 0-4 levels of logging ranging from next to none to very verbose. 1 recommended unless debugging.\r\nSharedProfile = Will share joypad settings across all users except for invert");
    }

    public static enum UserJoypadSettings {
        JoyNo,
        JoyName,
        InvertY,
        GameSensitivity,
        GuiSensitivity;

    }
}

