/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.lwjglVirtualInput;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.lwjgl.input.Keyboard;

public class VirtualKeyboard {
    private static Field keyDownField;
    private static Field keyBufferField;
    private static Byte[] keyState;
    private static boolean created;

    private VirtualKeyboard() {
    }

    public static void create() throws NoSuchFieldException, SecurityException {
        if (created) {
            return;
        }
        LogHelper.Info("Creating VirtualKeyboard");
        keyBufferField = Keyboard.class.getDeclaredField("readBuffer");
        keyDownField = Keyboard.class.getDeclaredField("keyDownBuffer");
        keyDownField.setAccessible(true);
        keyBufferField.setAccessible(true);
        keyState = new Byte[256];
        for (int i = 0; i < 256; ++i) {
            VirtualKeyboard.keyState[i] = 0;
        }
        created = true;
    }

    public static boolean isCreated() {
        return created;
    }

    public static void pressKey(int keycode) {
        if (!VirtualKeyboard.checkCreated()) {
            return;
        }
        if (VirtualKeyboard.keyHelper(keycode, 1)) {
            if (ControllerSettings.loggingLevel > 1) {
                LogHelper.Info("Pressing key " + Keyboard.getKeyName((int)keycode));
            }
            VirtualKeyboard.keyState[keycode] = 1;
            VirtualKeyboard.holdKey(keycode, true);
        }
    }

    public static void releaseKey(int keycode, boolean onlyIfPressed) {
        if (!VirtualKeyboard.checkCreated()) {
            return;
        }
        if (VirtualKeyboard.isValidKey(keycode, true) && (!onlyIfPressed || keyState[keycode] == 1)) {
            if (ControllerSettings.loggingLevel > 1) {
                LogHelper.Info("Releasing key " + Keyboard.getKeyName((int)keycode));
            }
            VirtualKeyboard.keyHelper(keycode, 0);
            VirtualKeyboard.keyState[keycode] = 0;
            VirtualKeyboard.holdKey(keycode, false);
        }
    }

    public static void holdKey(int keycode, boolean down) {
        if (!VirtualKeyboard.checkCreated()) {
            return;
        }
        if (!VirtualKeyboard.isValidKey(keycode, true)) {
            return;
        }
        if (ControllerSettings.loggingLevel > 2) {
            LogHelper.Info("Holding key " + Keyboard.getKeyName((int)keycode));
        }
        if (keyDownField != null) {
            try {
                byte b = (byte)(down ? 1 : 0);
                ((ByteBuffer)keyDownField.get(null)).put(keycode, b);
            }
            catch (Exception ex) {
                LogHelper.Error("Failed putting value in key buffer" + ex.toString());
            }
        }
    }

    private static boolean checkCreated() {
        if (!created) {
            LogHelper.Error("Virtual Keyboard has not been created or failed to initialize and cannot be used");
            return false;
        }
        return true;
    }

    private static boolean isValidKey(int keycode, boolean logError) {
        if (keycode < 0 || keycode > 256) {
            if (logError) {
                LogHelper.Error("Invalid keyboard keycode requested: " + keycode);
            }
            return false;
        }
        return true;
    }

    private static boolean keyHelper(int keycode, int state) {
        if (!VirtualKeyboard.checkCreated()) {
            return false;
        }
        if (!VirtualKeyboard.isValidKey(keycode, true)) {
            return false;
        }
        if (keyBufferField != null) {
            if (ControllerSettings.loggingLevel > 1) {
                LogHelper.Info("Hacking key " + Keyboard.getKeyName((int)keycode) + " state: " + state);
            }
            try {
                ((ByteBuffer)keyBufferField.get(null)).compact();
                ((ByteBuffer)keyBufferField.get(null)).putInt(keycode);
                ((ByteBuffer)keyBufferField.get(null)).put((byte)state);
                ((ByteBuffer)keyBufferField.get(null)).putInt(keycode);
                ((ByteBuffer)keyBufferField.get(null)).putLong(500L);
                ((ByteBuffer)keyBufferField.get(null)).put((byte)0);
                ((ByteBuffer)keyBufferField.get(null)).flip();
                return true;
            }
            catch (Exception ex) {
                LogHelper.Error("Failed putting value in keyBufferField " + ex.toString());
            }
        }
        return false;
    }

    static {
        created = false;
    }
}

