/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.lwjglVirtualInput;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.lwjgl.input.Mouse;

public class VirtualMouse {
    private static Field xField;
    private static Field yField;
    private static Field dxField;
    private static Field dyField;
    private static Field buttonField;
    private static Field mouseReadBuffer;
    private static Field isGrabbedField;
    private static int[] buttonsDown;
    private static final int buttonsSupported = 3;
    private static int lastX;
    private static int lastY;
    private static boolean created;

    private VirtualMouse() {
    }

    public static void create() throws NoSuchFieldException, SecurityException {
        if (created) {
            return;
        }
        LogHelper.Info("Creating VirtualMouse");
        xField = VirtualMouse.getSetField("x");
        yField = VirtualMouse.getSetField("y");
        dxField = VirtualMouse.getSetField("dx");
        dyField = VirtualMouse.getSetField("dy");
        buttonField = VirtualMouse.getSetField("buttons");
        mouseReadBuffer = VirtualMouse.getSetField("readBuffer");
        isGrabbedField = VirtualMouse.getSetField("isGrabbed");
        created = true;
    }

    private static Field getSetField(String fieldName) throws NoSuchFieldException, SecurityException {
        Field f = Mouse.class.getDeclaredField(fieldName);
        f.setAccessible(true);
        return f;
    }

    public static boolean isCreated() {
        return created;
    }

    public static void unpressAllButtons() {
        for (int i = 0; i < 3; ++i) {
            VirtualMouse.releaseMouseButton(i, true);
        }
    }

    public static boolean moveMouse(int dx, int dy) {
        if (!VirtualMouse.checkCreated()) {
            return false;
        }
        if (ControllerSettings.loggingLevel > 1) {
            LogHelper.Info("Moving mouse: dx:" + dx + " dy:" + dy);
        }
        VirtualMouse.addMouseEvent((byte)-1, (byte)0, dx, dy, 0, 1000L);
        try {
            dxField.setInt(null, dx);
            dyField.setInt(null, dy);
        }
        catch (Exception ex) {
            LogHelper.Error("Failed setting dx/dy value of mouse. " + ex.toString());
        }
        return true;
    }

    public static boolean holdMouseButton(int button, boolean onlyIfNotHeld) {
        if (!VirtualMouse.checkCreated() || !VirtualMouse.checkButtonSupported(button)) {
            return false;
        }
        if (onlyIfNotHeld && buttonsDown[button] != 0) {
            if (ControllerSettings.loggingLevel > 1) {
                LogHelper.Info("rejecting mouse button press as its already indicated as held");
            }
            return true;
        }
        if (ControllerSettings.loggingLevel > 1) {
            LogHelper.Info("Holding mouse button: " + button);
        }
        VirtualMouse.setMouseButton(button, true);
        VirtualMouse.addMouseEvent((byte)button, (byte)1, lastX, lastY, 0, 1000L);
        VirtualMouse.buttonsDown[button] = 1;
        return true;
    }

    public static boolean releaseMouseButton(int button, boolean onlyIfHeld) {
        if (!VirtualMouse.checkCreated() || !VirtualMouse.checkButtonSupported(button)) {
            return false;
        }
        if (onlyIfHeld && buttonsDown[button] != 1) {
            return true;
        }
        if (ControllerSettings.loggingLevel > 1) {
            LogHelper.Info("Releasing mouse button: " + button);
        }
        VirtualMouse.setMouseButton(button, false);
        VirtualMouse.addMouseEvent((byte)button, (byte)0, lastX, lastY, 0, 1000L);
        VirtualMouse.buttonsDown[button] = 0;
        return true;
    }

    public static boolean isButtonDown(int button) {
        return buttonsDown[button] == 1;
    }

    public static boolean scrollWheel(int event_dwheel) {
        if (!VirtualMouse.checkCreated()) {
            return false;
        }
        if (ControllerSettings.loggingLevel > 1) {
            LogHelper.Info("Setting scroll wheel: " + event_dwheel);
        }
        VirtualMouse.addMouseEvent((byte)-1, (byte)0, 0, 0, event_dwheel, 10000L);
        return true;
    }

    public static boolean setXY(int x, int y) {
        if (!VirtualMouse.checkCreated()) {
            return false;
        }
        if (ControllerSettings.loggingLevel > 3 && (lastX != x || lastY != y)) {
            LogHelper.Info("Setting mouse position to x:" + x + " y:" + y);
        }
        try {
            xField.setInt(null, x);
            yField.setInt(null, y);
            lastX = x;
            lastY = y;
            return true;
        }
        catch (Exception ex) {
            LogHelper.Error("Failed setting x/y value of mouse. " + ex.toString());
            return false;
        }
    }

    public static boolean setMouseButton(int button, boolean down) {
        if (ControllerSettings.loggingLevel > 3) {
            LogHelper.Info("Hacking mouse button: " + button);
        }
        try {
            ((ByteBuffer)buttonField.get(null)).put(button, (byte)(down ? 1 : 0));
        }
        catch (Exception ex) {
            LogHelper.Error("Failed setting mouse button field: " + ex.toString());
            return false;
        }
        return true;
    }

    private static boolean addMouseEvent(byte eventButton, byte eventState, int event_dx, int event_dy, int event_dwheel, long event_nanos) {
        if (!VirtualMouse.checkCreated()) {
            return false;
        }
        if (ControllerSettings.loggingLevel > 1) {
            LogHelper.Info("AddMouseEvent: eventButton: " + eventButton + " eventState: " + eventState + " event_dx: " + event_dx + " event_dy: " + event_dy + " event_dwheel: " + event_dwheel);
        }
        try {
            ((ByteBuffer)mouseReadBuffer.get(null)).compact();
            ((ByteBuffer)mouseReadBuffer.get(null)).put(eventButton);
            ((ByteBuffer)mouseReadBuffer.get(null)).put(eventState);
            ((ByteBuffer)mouseReadBuffer.get(null)).putInt(event_dx);
            ((ByteBuffer)mouseReadBuffer.get(null)).putInt(event_dy);
            ((ByteBuffer)mouseReadBuffer.get(null)).putInt(event_dwheel);
            ((ByteBuffer)mouseReadBuffer.get(null)).putLong(event_nanos);
            ((ByteBuffer)mouseReadBuffer.get(null)).flip();
        }
        catch (Exception ex) {
            LogHelper.Error("Failed putting value in mouseReadBuffer " + ex.toString());
            return false;
        }
        return true;
    }

    public static void setGrabbed(boolean grabbed) {
        if (ControllerSettings.loggingLevel > 3) {
            LogHelper.Info("Setting Mouse.isGrabbed to return: " + grabbed);
        }
        try {
            isGrabbedField.setBoolean(null, grabbed);
        }
        catch (Exception ex) {
            LogHelper.Error("Failed trying to set Mouse.isGrabbed. " + ex.toString());
        }
    }

    private static boolean checkButtonSupported(int button) {
        if (button < 0 || button >= 3) {
            LogHelper.Error("Button number is not supported.  Max button index is 2");
            return false;
        }
        return true;
    }

    private static boolean checkCreated() {
        if (!created) {
            LogHelper.Error("Virtual mouse has not been created or failed to initialize and cannot be used");
            return false;
        }
        return true;
    }

    static {
        buttonsDown = new int[]{0, 0, 0};
        lastX = 0;
        lastY = 0;
        created = false;
    }
}

