/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.helpers.McObfuscationHelper;
import com.shiny.joypadmod.helpers.ModVersionHelper;
import com.shiny.joypadmod.inputevent.ControllerBinding;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;

public class ButtonScreenTips
extends Gui {
    public static HintString[] blTipsGame = new HintString[]{new HintString("joy.inventory"), new HintString("joy.jump")};
    public static HintString[] brTipsGame = new HintString[]{new HintString("joy.attack"), new HintString("joy.use")};
    public static HintString[] blTipsMenu = new HintString[]{new HintString("joy.closeInventory"), new HintString("joy.shiftClick", "menuHint.quickmove", null)};
    public static HintString[] brTipsMenu = new HintString[]{new HintString("joy.guiLeftClick", "menuHint.takeall", "menuHint.placeall"), new HintString("joy.interact", "menuHint.takehalf", "menuHint.placeone")};
    Minecraft mc = Minecraft.func_71410_x();
    FontRenderer fr;
    int currentX;
    int currentY;

    public ButtonScreenTips() {
        this.fr = this.mc.field_71466_p;
        this.currentX = 5;
        this.currentY = 20;
        if (ControllerSettings.isSuspended() || !ControllerSettings.isInputEnabled() || !ControllerSettings.displayHints) {
            return;
        }
        this.displayTips();
    }

    public static void UpdateHintString() {
        for (HintString hs : blTipsGame) {
            hs.UpdateHintString();
        }
        for (HintString hs : brTipsGame) {
            hs.UpdateHintString();
        }
        for (HintString hs : blTipsMenu) {
            hs.UpdateHintString();
        }
        for (HintString hs : brTipsMenu) {
            hs.UpdateHintString();
        }
    }

    private int findMaxStringLength(HintString[] hintStrings, boolean inMenu, boolean isHolding) {
        int max = 0;
        for (HintString hs : hintStrings) {
            String checkString;
            int len;
            if (!hs.isValid.booleanValue() || (len = this.fr.func_78256_a(checkString = isHolding && hs.hintHolding != null ? hs.hintHolding : hs.hintNormal)) <= max) continue;
            max = len;
        }
        return max;
    }

    private void displayTips() {
        block5: {
            String outString;
            int height;
            int width;
            block4: {
                String outString2;
                ScaledResolution scaled = ModVersionHelper.GetScaledResolution();
                width = scaled.func_78326_a();
                height = scaled.func_78328_b();
                if (!(this.mc.field_71462_r instanceof GuiContainer)) break block4;
                boolean isHolding = this.mc.field_71439_g != null && this.mc.field_71439_g.field_71071_by != null && this.mc.field_71439_g.field_71071_by.func_70445_o() != null;
                int maxLen = this.findMaxStringLength(blTipsMenu, true, isHolding);
                this.currentX = width / 2 - 100 - maxLen;
                this.currentY = height - (this.fr.field_78288_b * blTipsMenu.length + blTipsMenu.length * 5);
                for (HintString hs : blTipsMenu) {
                    if (!hs.isValid.booleanValue()) continue;
                    outString2 = isHolding && hs.hintHolding != null ? hs.hintHolding : hs.hintNormal;
                    this.drawTip(outString2, 0xFFFFFF);
                }
                this.currentX = width / 2 + 100;
                this.currentY = height - (this.fr.field_78288_b * brTipsMenu.length + brTipsMenu.length * 5);
                for (HintString hs : brTipsMenu) {
                    if (!hs.isValid.booleanValue()) continue;
                    outString2 = isHolding && hs.hintHolding != null ? hs.hintHolding : hs.hintNormal;
                    this.drawTip(outString2, 0xFFFFFF);
                }
                break block5;
            }
            if (!this.mc.field_71415_G) break block5;
            boolean isHolding = false;
            int maxLen = this.findMaxStringLength(blTipsGame, false, isHolding);
            this.currentX = width / 2 - 95 - maxLen;
            this.currentY = height - (this.fr.field_78288_b * blTipsGame.length + blTipsGame.length * 5);
            for (HintString hs : blTipsGame) {
                if (!hs.isValid.booleanValue()) continue;
                outString = isHolding && hs.hintHolding != null ? hs.hintHolding : hs.hintNormal;
                this.drawTip(outString, 0xFFFFFF);
            }
            this.currentX = width / 2 + 95;
            this.currentY = height - (this.fr.field_78288_b * brTipsGame.length + brTipsGame.length * 5);
            for (HintString hs : brTipsGame) {
                if (!hs.isValid.booleanValue()) continue;
                outString = isHolding && hs.hintHolding != null ? hs.hintHolding : hs.hintNormal;
                this.drawTip(outString, 0xFFFFFF);
            }
        }
    }

    private void drawTip(String text, int color) {
        this.func_73731_b(this.fr, text, this.currentX, this.currentY, color);
        this.currentY += this.fr.field_78288_b + 5;
    }

    public static class HintString {
        public String bindingString;
        public String hintHolding;
        public String hintNormal;
        public Boolean isValid;
        private String hintOverride;
        private String hintOverrideHolding;

        public HintString(String bindString, String menuHintOverride, String menuHintOverrideHolding) {
            LogHelper.Info(String.format("HintString Constructor called with binding: %s. MenuOverride: %s. menuHintOverrideHolding: %s", bindString, menuHintOverride, menuHintOverrideHolding));
            this.bindingString = bindString;
            this.hintOverride = menuHintOverride;
            this.hintOverrideHolding = menuHintOverrideHolding;
            this.UpdateHintString();
        }

        public HintString(String a) {
            this(a, null, null);
        }

        public void UpdateHintString() {
            try {
                ControllerBinding b = ControllerSettings.get(this.bindingString);
                this.isValid = b != null && b.inputEvent != null && b.inputEvent.isValid();
                if (this.isValid.booleanValue()) {
                    this.hintNormal = b.getInputName() + " - ";
                    this.hintNormal = this.hintOverride == null ? this.hintNormal + b.getMenuItemName() : this.hintNormal + McObfuscationHelper.lookupString(this.hintOverride);
                    this.hintHolding = this.hintOverrideHolding == null ? null : b.getInputName() + " - " + McObfuscationHelper.lookupString(this.hintOverrideHolding);
                }
                LogHelper.Info(String.format("HintString: %s, HintStringHolding: %s", this.hintNormal, this.hintHolding));
            }
            catch (Exception ex) {
                this.isValid = false;
                LogHelper.Error("Error updating HintString " + this.bindingString + " " + ex.getLocalizedMessage());
            }
        }
    }
}

