/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.helpers;

import com.shiny.joypadmod.ButtonScreenTips;
import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.GameRenderHandler;
import com.shiny.joypadmod.helpers.Customizations;
import com.shiny.joypadmod.helpers.LogHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;

public class ModVersionHelper {
    public static final String VERSION = "1.7.2";
    public static final int MC_VERSION = 172;

    public void gameInit() {
        if (ControllerSettings.modDisabled) {
            LogHelper.Warn("Mod game initialization ignored due to mod disabled.  No in game options will appear to change this unless config file updated");
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        Customizations.init();
    }

    public static int getVersion() {
        return 172;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void tickRender(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            GameRenderHandler.HandlePreRender();
        } else if (event.phase == TickEvent.Phase.END) {
            GameRenderHandler.HandlePostRender();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void tickRenderClient(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            GameRenderHandler.HandleClientStartTick();
        } else if (event.phase == TickEvent.Phase.END) {
            GameRenderHandler.HandleClientEndTick();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void buttonMapDisplay(RenderGameOverlayEvent.Post event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        new ButtonScreenTips();
    }

    public static ScaledResolution GetScaledResolution() {
        Minecraft mc = Minecraft.func_71410_x();
        return new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
    }
}

