/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.inputevent;

import com.shiny.joypadmod.inputevent.ControllerInputEvent;
import org.lwjgl.input.Controllers;

public class PovInputEvent
extends ControllerInputEvent {
    int povNumber;

    public PovInputEvent(int controllerId, int povNumber, float threshold) {
        super(ControllerInputEvent.EventType.POV, controllerId, povNumber, threshold, 0.0f);
        this.povNumber = povNumber;
    }

    @Override
    protected boolean isTargetEvent() {
        if (this.povNumber == 0) {
            return Controllers.isEventPovX();
        }
        return Controllers.isEventPovY();
    }

    @Override
    public float getAnalogReading() {
        return this.povNumber == 0 ? Controllers.getController((int)this.controllerNumber).getPovX() : Controllers.getController((int)this.controllerNumber).getPovY();
    }

    @Override
    public String getName() {
        return this.povNumber == 0 ? "POV X" : "POV Y";
    }

    public String toString() {
        return "Event: " + this.getName() + " Type: " + (Object)((Object)this.getEventType()) + " Max Value: " + this.threshold + " Current value: " + this.getAnalogReading() + " Is pressed: " + this.isPressed();
    }

    @Override
    public String getDescription() {
        return this.getName() + " " + this.getDirection(this.getThreshold());
    }

    private String getDirection(float reading) {
        if (reading == 0.0f) {
            return "";
        }
        if (reading > 0.0f) {
            return "+";
        }
        return "-";
    }

    @Override
    public boolean isValid() {
        return this.povNumber == 0 || this.povNumber == 1;
    }
}

