/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.minecraftExtensions;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.helpers.McObfuscationHelper;
import com.shiny.joypadmod.minecraftExtensions.JoypadCalibrationMenu;
import com.shiny.joypadmod.minecraftExtensions.JoypadConfigMenu;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

public class JoypadAdvancedMenu
extends GuiScreen {
    private int buttonWidth = 150;
    private int buttonsPerRow = 2;
    private int buttonYSpacing = 25;
    private int buttonXSpacing = 5;
    private int buttonXStart_top;
    private int buttonYStart_top;
    private int joyIndex;
    private JoypadConfigMenu parent;
    private String[] otherButtons = new String[]{"controlMenu.calibrate", "controlMenu.invert"};
    private String[] gameOptions = new String[]{"-Global-.SharedProfile", "-Global-.displayAllControls", "-Global-.GrabMouse", "-User-.DisplayHints"};

    public JoypadAdvancedMenu(JoypadConfigMenu parent, int joyIndex) {
        this.parent = parent;
        this.joyIndex = joyIndex;
    }

    public void func_73866_w_() {
        this.buttonWidth = this.findMaxButtonWidth() + 10;
        this.buttonXStart_top = (this.field_146294_l - this.buttonWidth * this.buttonsPerRow - this.buttonXSpacing * this.buttonsPerRow) / 2;
        this.buttonYStart_top = 50;
        int buttonNum = 0;
        this.addButton(buttonNum++, 100, "controlMenu.calibrate", false);
        this.addButton(buttonNum++, 200, "controlMenu.invert", true, ControllerSettings.getInvertYAxis());
        for (int i = 0; i < this.gameOptions.length; ++i) {
            this.addButton(buttonNum++, 300 + i, this.gameOptions[i], true);
        }
        this.field_146292_n.add(new GuiButton(500, this.field_146294_l / 2 - this.parent.bottomButtonWidth / 2, this.field_146295_m - 20, this.parent.bottomButtonWidth, 20, this.parent.sGet("gui.done")));
    }

    private int findMaxButtonWidth() {
        int width;
        String buttonString;
        int i;
        int maxWidth = 0;
        for (i = 0; i < this.otherButtons.length; ++i) {
            buttonString = this.createToggleString(this.otherButtons[i], true);
            width = this.field_146297_k.field_71466_p.func_78256_a(buttonString);
            maxWidth = width > maxWidth ? width : maxWidth;
        }
        for (i = 0; i < this.gameOptions.length; ++i) {
            buttonString = this.createToggleString(this.gameOptions[i], true);
            width = this.field_146297_k.field_71466_p.func_78256_a(buttonString);
            maxWidth = width > maxWidth ? width : maxWidth;
        }
        return maxWidth;
    }

    protected void func_146284_a(GuiButton guiButton) {
        LogHelper.Info("Action performed on " + guiButton.field_146126_j);
        switch (guiButton.field_146127_k) {
            case 100: {
                this.field_146297_k.func_147108_a((GuiScreen)new JoypadCalibrationMenu(this, this.joyIndex));
                break;
            }
            case 200: {
                ControllerSettings.setInvertYAxis(!ControllerSettings.getInvertYAxis());
                this.toggleOnOffButton(ControllerSettings.getInvertYAxis(), guiButton);
                break;
            }
            case 500: {
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                break;
            }
            default: {
                int id = guiButton.field_146127_k - 300;
                if (id < 0 || id >= this.gameOptions.length) break;
                boolean currentSetting = ControllerSettings.getGameOption(this.gameOptions[id]).equals("true");
                ControllerSettings.setGameOption(this.gameOptions[id], "" + !currentSetting);
                this.toggleOnOffButton(!currentSetting, guiButton);
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        int labelYStart = 5;
        String titleText = String.format("Joypad Mod - %s", this.parent.sGet("controlMenu.advanced"));
        this.func_73732_a(this.parent.getFontRenderer(), titleText, this.field_146294_l / 2, labelYStart, -1);
        super.func_73863_a(par1, par2, par3);
    }

    private void addButton(int buttonNum, int id, String code, boolean isToggle) {
        boolean toggleValue = isToggle ? ControllerSettings.getGameOption(code).equals("true") : false;
        this.addButton(buttonNum, id, code, isToggle, toggleValue);
    }

    private void addButton(int buttonNum, int id, String code, boolean isToggle, boolean toggleValue) {
        int buttonBase = buttonNum % this.buttonsPerRow;
        String buttonString = isToggle ? this.createToggleString(code, toggleValue) : McObfuscationHelper.lookupString(code);
        this.field_146292_n.add(new GuiButton(id, this.buttonXStart_top + this.buttonWidth * buttonBase + this.buttonXSpacing * buttonBase, this.buttonYStart_top + buttonNum / this.buttonsPerRow * this.buttonYSpacing, this.buttonWidth, 20, buttonString));
    }

    private String createToggleString(String code, boolean on) {
        String toggleString = on ? "options.on" : "options.off";
        return String.format("%s: %s", McObfuscationHelper.lookupString(code), McObfuscationHelper.lookupString(toggleString));
    }

    private void toggleOnOffButton(boolean b, GuiButton button) {
        String s1 = b ? McObfuscationHelper.lookupString("options.off") : McObfuscationHelper.lookupString("options.on");
        String s2 = b ? McObfuscationHelper.lookupString("options.on") : McObfuscationHelper.lookupString("options.off");
        button.field_146126_j = button.field_146126_j.replace(s1, s2);
    }
}

