/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.minecraftExtensions;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.helpers.McKeyBindHelper;
import com.shiny.joypadmod.helpers.McObfuscationHelper;
import com.shiny.joypadmod.helpers.ModVersionHelper;
import com.shiny.joypadmod.inputevent.ButtonInputEvent;
import com.shiny.joypadmod.inputevent.ControllerBinding;
import com.shiny.joypadmod.inputevent.ControllerInputEvent;
import com.shiny.joypadmod.lwjglVirtualInput.VirtualMouse;
import com.shiny.joypadmod.minecraftExtensions.JoypadConfigMenu;
import cpw.mods.fml.client.GuiScrollingList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.KeyBinding;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Mouse;

public class JoypadControlList
extends GuiScrollingList {
    private FontRenderer fontRenderer;
    private int controllerInputTimeout = 5000;
    public long controllerTickStart = 0L;
    private static final int buttonHeight = 20;
    public static int lastXClick = 0;
    public static int lastYClick = 0;
    public static int lastMouseButton = 0;
    private int selectedIndex = -1;
    public int bindingIndexToUpdate = -1;
    public int inputIndexToUpdate = -1;
    private JoypadConfigMenu parent;
    private int lastListSize = 0;
    private int descriptionStartX;
    private int controlButtonCenterOffset = 20;
    public static GuiTextField textInputName = null;
    private static Minecraft mc = Minecraft.func_71410_x();
    public List<String> joyBindKeys;
    int wheelDown = 0;
    private int controlButtonWidth = 70;
    private int smallButtonWidth = 15;

    public JoypadControlList(JoypadConfigMenu parent, FontRenderer fontRenderer) {
        super(mc, parent.controlListWidth, parent.field_146295_m, parent.controlListYStart, parent.controlListYStart + parent.controlListHeight, parent.controlListXStart, 20);
        LogHelper.Info("width:" + parent.controlListWidth + " height:" + parent.field_146295_m + " yStart:" + parent.controlListYStart + " bottomEnd:" + (parent.controlListYStart + parent.controlListHeight) + "xStart: " + parent.controlListXStart);
        this.parent = parent;
        this.fontRenderer = fontRenderer;
        textInputName = new GuiTextField(this.fontRenderer, 0, 0, 0, 0);
        textInputName.func_146189_e(false);
        this.joyBindKeys = new ArrayList<String>();
        this.descriptionStartX = parent.buttonXStart_top;
        if (this.parent.getCurrentControllerId() != -1) {
            this.updatejoyBindKeys();
        }
    }

    public void updatejoyBindKeys() {
        this.joyBindKeys.clear();
        Object[] akeybinding = (KeyBinding[])ArrayUtils.clone((Object[])JoypadControlList.mc.field_71474_y.field_74324_K);
        if (ModVersionHelper.getVersion() >= 172) {
            Arrays.sort(akeybinding);
        }
        ControllerSettings.setDefaultJoyBindingMap(this.parent.getCurrentControllerId(), true);
        String category = "joy.categories.ui";
        this.joyBindKeys.add(category);
        String thisCategory = "";
        for (Object key : akeybinding) {
            String joyTarget = McObfuscationHelper.getKeyDescription((KeyBinding)key).replace("key.", "joy.");
            String joyKey = "";
            if (ControllerSettings.joyBindingsMap.containsKey(joyTarget)) {
                joyKey = joyTarget;
                thisCategory = ControllerSettings.get(joyKey).getCategoryString();
            } else {
                joyKey = McObfuscationHelper.getKeyDescription((KeyBinding)key);
                thisCategory = McObfuscationHelper.getKeyCategory((KeyBinding)key).replace("key.", "joy.");
            }
            if (thisCategory.compareTo(category) != 0) {
                this.getBindingsWithCategory(category);
                this.joyBindKeys.add(thisCategory);
                category = thisCategory;
            }
            this.joyBindKeys.add(joyKey);
        }
        this.getBindingsWithCategory(thisCategory);
        this.sortBindKeys();
    }

    private void getBindingsWithCategory(String category) {
        List<String> otherBindings = ControllerSettings.getBindingsWithCategory(category);
        for (String bindingKeys : otherBindings) {
            if (this.joyBindKeys.contains(bindingKeys)) continue;
            this.joyBindKeys.add(bindingKeys);
        }
    }

    private void sortBindKeys() {
        int lastCategoryStart = -1;
        String[] list = this.joyBindKeys.toArray(new String[this.joyBindKeys.size()]);
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].contains("categories") && (i + 1 != list.length || i++ <= 0)) continue;
            if (lastCategoryStart != -1 && lastCategoryStart < i - 2) {
                Arrays.sort(list, lastCategoryStart + 1, i, new Comparator<String>(){

                    @Override
                    public int compare(String s1, String s2) {
                        return JoypadControlList.this.parent.sGet(s1).compareTo(JoypadControlList.this.parent.sGet(s2));
                    }
                });
            }
            lastCategoryStart = i;
        }
        this.joyBindKeys.clear();
        int longestWidthFound = 0;
        for (int i = 0; i < list.length; ++i) {
            this.joyBindKeys.add(list[i]);
            int thisWidth = this.parent.getFontRenderer().func_78256_a(this.parent.sGet(list[i]));
            if (thisWidth <= longestWidthFound) continue;
            longestWidthFound = thisWidth;
        }
        if (longestWidthFound > this.parent.controllerButtonWidth / 2 - this.controlButtonCenterOffset - 3) {
            this.descriptionStartX = this.parent.buttonXStart_top - (this.parent.controllerButtonWidth / 2 - longestWidthFound) - this.controlButtonCenterOffset - 5;
            if (this.descriptionStartX < 0) {
                this.descriptionStartX = 0;
            }
        }
    }

    protected int getSize() {
        return this.joyBindKeys.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
    }

    protected boolean isSelected(int index) {
        return false;
    }

    protected void drawBackground() {
        this.parent.func_146278_c(0);
    }

    protected void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5) {
        if (var1 >= this.joyBindKeys.size()) {
            return;
        }
        if (this.wheelDown-- > 0) {
            VirtualMouse.scrollWheel(-1);
        }
        if (this.lastListSize != this.getSize()) {
            if (this.lastListSize > 0 && this.getSize() > this.lastListSize) {
                this.wheelDown = 350;
                this.selectedIndex = this.getSize() - 1;
            } else {
                this.selectedIndex = Math.max(-1, this.selectedIndex - 1);
            }
            this.lastListSize = this.getSize();
        }
        int centerStart = this.parent.buttonXStart_top + this.parent.controllerButtonWidth / 2;
        if (this.joyBindKeys.get(var1).contains("categories.")) {
            String category = this.parent.sGet(this.joyBindKeys.get(var1));
            this.fontRenderer.func_78276_b(category, centerStart - this.fontRenderer.func_78256_a(category) / 2, var3 + 5, -1);
            return;
        }
        String controlDescription = this.parent.sGet(this.joyBindKeys.get(var1));
        boolean duplicate = ControllerSettings.checkIfDuplicateBinding(this.joyBindKeys.get(var1));
        this.fontRenderer.func_78276_b(controlDescription, this.descriptionStartX, var3 + 10 - this.fontRenderer.field_78288_b / 2, duplicate ? 0xFF5555 : -1);
        this.drawControlButtons(var1, centerStart - this.controlButtonCenterOffset, var3, this.joyBindKeys.get(var1), var1 == this.selectedIndex);
        if (this.bindingIndexToUpdate != -1 && (this.getControllerInput() || Minecraft.func_71386_F() - this.controllerTickStart > (long)this.controllerInputTimeout)) {
            this.bindingIndexToUpdate = -1;
            ControllerSettings.suspendControllerInput(false, 0L);
        }
    }

    private void drawControlButtons(int id, int x, int y, String bindingKey, boolean slotSelected) {
        if (bindingKey == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledResolution = ModVersionHelper.GetScaledResolution();
        int k = Mouse.getX() * scaledResolution.func_78326_a() / mc.field_71443_c;
        int i1 = scaledResolution.func_78328_b() - Mouse.getY() * scaledResolution.func_78328_b() / mc.field_71440_d - 1;
        this.checkButtonPressAction(id, x, y, bindingKey);
        ControllerBinding binding = ControllerSettings.get(bindingKey);
        String controlButtonStr = "NONE";
        if (this.parent.getCurrentControllerId() != -1) {
            if (this.bindingIndexToUpdate == id) {
                controlButtonStr = "> ?? <";
            } else if (binding != null) {
                controlButtonStr = ControllerSettings.controllerUtils.getHumanReadableInputName(Controllers.getController((int)this.parent.getCurrentControllerId()), binding.inputEvent);
            }
        }
        if (controlButtonStr.equals("NONE")) {
            if (binding != null) {
                if (binding.keyCodes != null && binding.keyCodes.length == 1 && binding.bindingOptions != null && binding.bindingOptions.contains((Object)ControllerBinding.BindingOptions.GAME_BINDING)) {
                    controlButtonStr = ControllerSettings.checkKeyCodeBound(this.parent.getCurrentControllerId(), binding.keyCodes[0], controlButtonStr);
                }
            } else {
                controlButtonStr = this.checkKeyCodeBound(bindingKey, controlButtonStr);
            }
            if (ControllerSettings.loggingLevel > 1 && !controlButtonStr.equals("NONE")) {
                LogHelper.Info(String.format("Found that binding %s has a ControllerBinding (%s) that activates same code. ", bindingKey, controlButtonStr));
            }
            if (id == this.inputIndexToUpdate && controlButtonStr.equals("NONE")) {
                this.inputIndexToUpdate = -1;
            }
        }
        if (this.inputIndexToUpdate == id) {
            int key = this.parent.lastKeyCode;
            if (key == 1 || key == 28) {
                String theKey;
                if (key == 28 && (theKey = binding.inputEvent.getDescription()) != "NONE") {
                    String newMapping = textInputName.func_146179_b().length() > 0 ? textInputName.func_146179_b() : binding.inputEvent.getDescription();
                    ControllerSettings.controllerUtils.updateCurrentJoypadMap(theKey, newMapping);
                }
                textInputName.func_146189_e(false);
                this.inputIndexToUpdate = -1;
            } else {
                String s = textInputName.func_146176_q() ? textInputName.func_146179_b() : controlButtonStr;
                textInputName = new GuiTextField(this.fontRenderer, x, y, this.controlButtonWidth, 20);
                textInputName.func_146180_a(s);
                textInputName.func_146189_e(true);
                textInputName.func_146194_f();
                textInputName.func_146195_b(true);
            }
            this.parent.lastKeyCode = -1;
        } else {
            controlButtonStr = this.fontRenderer.func_78269_a(controlButtonStr, this.controlButtonWidth - 2);
            GuiButton b = new GuiButton(10001, x, y, this.controlButtonWidth, 20, controlButtonStr);
            b.func_146112_a(mc, k, i1);
            if (binding == null) {
                return;
            }
            char optionRemove = McObfuscationHelper.symGet(McObfuscationHelper.JSyms.unbind);
            boolean enable = true;
            if (!binding.inputEvent.isValid()) {
                if (binding.inputString.contains("user.")) {
                    optionRemove = McObfuscationHelper.symGet(McObfuscationHelper.JSyms.remove);
                } else {
                    enable = false;
                }
            }
            if (enable) {
                b = new GuiButton(10002, x + this.controlButtonWidth, y, this.smallButtonWidth, 20, "" + optionRemove);
                b.func_146112_a(mc, k, i1);
                if (binding.inputEvent.getEventType() != ControllerInputEvent.EventType.AXIS && !binding.bindingOptions.contains((Object)ControllerBinding.BindingOptions.MENU_BINDING)) {
                    char toggle = McObfuscationHelper.symGet(McObfuscationHelper.JSyms.eCircle);
                    if (binding.bindingOptions.contains((Object)ControllerBinding.BindingOptions.IS_TOGGLE)) {
                        toggle = McObfuscationHelper.symGet(McObfuscationHelper.JSyms.fCircle);
                    }
                    b = new GuiButton(10003, x + this.controlButtonWidth + this.smallButtonWidth, y, this.smallButtonWidth, 20, "" + toggle);
                    b.func_146112_a(mc, k, i1);
                }
            }
        }
    }

    private String checkKeyCodeBound(String bindingKey, String defaultStr) {
        int keyCode;
        KeyBinding kb = McKeyBindHelper.getMinecraftKeyBind(bindingKey);
        if (kb != null && (keyCode = McObfuscationHelper.keyCode(kb)) != 0) {
            return ControllerSettings.checkKeyCodeBound(this.parent.getCurrentControllerId(), keyCode, defaultStr);
        }
        return defaultStr;
    }

    private boolean checkButtonPressAction(int id, int x, int y, String bindingKey) {
        boolean checkCancelInputWait;
        boolean bl = checkCancelInputWait = lastYClick > 0;
        if (lastYClick >= y && lastYClick <= y + 20 && lastXClick >= x) {
            lastYClick = 0;
            this.parent.lastKeyCode = -1;
            if (lastMouseButton == 1 && lastXClick <= x + this.controlButtonWidth) {
                if (this.bindingIndexToUpdate == -1) {
                    this.inputIndexToUpdate = id;
                    checkCancelInputWait = false;
                }
            } else if (lastMouseButton == 0) {
                if (!textInputName.func_146176_q()) {
                    ControllerBinding binding = ControllerSettings.get(bindingKey);
                    if (lastXClick <= x + this.controlButtonWidth) {
                        this.bindingIndexToUpdate = id;
                        this.controllerTickStart = Minecraft.func_71386_F();
                        ControllerSettings.suspendControllerInput(true, 10000L);
                        checkCancelInputWait = false;
                    } else if (binding != null) {
                        if (lastXClick <= x + this.controlButtonWidth + this.smallButtonWidth) {
                            if (binding.inputEvent.isValid()) {
                                ControllerSettings.unsetControllerBinding(this.parent.getCurrentControllerId(), binding.inputString);
                            } else if (binding.inputString.contains("user")) {
                                ControllerSettings.delete(binding.inputString);
                                this.joyBindKeys.remove(id);
                                return false;
                            }
                        } else if (lastXClick <= x + this.controlButtonWidth + this.smallButtonWidth * 2 && binding.inputEvent.getEventType() != ControllerInputEvent.EventType.AXIS && !binding.bindingOptions.contains((Object)ControllerBinding.BindingOptions.MENU_BINDING)) {
                            ControllerSettings.setToggle(this.parent.getCurrentControllerId(), binding.inputString, !binding.bindingOptions.contains((Object)ControllerBinding.BindingOptions.IS_TOGGLE));
                        }
                    }
                }
            }
        }
        if (checkCancelInputWait) {
            if (this.bindingIndexToUpdate != -1) {
                this.controllerTickStart = this.controllerInputTimeout + 1;
            }
            this.inputIndexToUpdate = -1;
            textInputName.func_146189_e(false);
        }
        return true;
    }

    private boolean getControllerInput() {
        try {
            while (Controllers.next()) {
                ControllerInputEvent inputEvent;
                if (Minecraft.func_71386_F() - this.controllerTickStart < 200L) {
                    LogHelper.Info("Discarding events that occured too soon after last button click");
                    continue;
                }
                if (Controllers.getEventSource() != Controllers.getController((int)this.parent.getCurrentControllerId()) || (inputEvent = ControllerSettings.controllerUtils.getLastEvent(Controllers.getController((int)this.parent.getCurrentControllerId()), Controllers.getEventControlIndex())) == null) continue;
                float threshold = inputEvent.getThreshold();
                LogHelper.Info("Received from controller: " + inputEvent.getName() + " threshold: " + threshold);
                threshold = inputEvent.getEventType() == ControllerInputEvent.EventType.AXIS ? 0.7f * (float)(threshold > 0.0f ? 1 : -1) : (inputEvent.getEventType() == ControllerInputEvent.EventType.POV ? 0.9f * (float)(threshold > 0.0f ? 1 : -1) : 1.0f);
                inputEvent.setThreshold(threshold);
                String bindingKey = this.joyBindKeys.get(this.bindingIndexToUpdate);
                ControllerBinding binding = this.findOrCreateBinding(bindingKey);
                binding.inputEvent = inputEvent;
                ControllerSettings.setControllerBinding(this.parent.getCurrentControllerId(), binding.inputString, binding);
                return true;
            }
        }
        catch (Exception ex) {
            LogHelper.Error("Caught exception while trying to set controller button! " + ex.toString());
        }
        return false;
    }

    private ControllerBinding findOrCreateBinding(String bindingKey) {
        KeyBinding kb;
        ControllerBinding b = ControllerSettings.get(bindingKey);
        if (b == null && (kb = McKeyBindHelper.getMinecraftKeyBind(bindingKey)) != null) {
            b = new ControllerBinding(bindingKey, bindingKey, new ButtonInputEvent(this.parent.getCurrentControllerId(), -1, 1.0f), new int[]{McObfuscationHelper.keyCode(kb)}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.RENDER_TICK, ControllerBinding.mapMinecraftCategory(McObfuscationHelper.getKeyCategory(kb))));
        }
        return b;
    }
}

