/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import doggytalents.DoggyTalentsMod;
import doggytalents.ModItems;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.IDogTreat;
import doggytalents.entity.CoordUtil;
import doggytalents.entity.LevelUtil;
import doggytalents.entity.ModeUtil;
import doggytalents.entity.TalentHelper;
import doggytalents.entity.TalentUtil;
import doggytalents.entity.ai.EntityAIDogBeg;
import doggytalents.entity.ai.EntityAIFetchBone;
import doggytalents.entity.ai.EntityAIFollowOwner;
import doggytalents.entity.ai.EntityAIModeAttackTarget;
import doggytalents.entity.ai.EntityAIOwnerHurtByTarget;
import doggytalents.entity.ai.EntityAIOwnerHurtTarget;
import doggytalents.entity.ai.EntityAIShepherdDog;
import doggytalents.lib.Constants;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import jline.internal.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDog
extends EntityTameable {
    public static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> BEGGING = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Byte> DOG_TEXTURE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> LEVEL_DIRE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> MODE = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> DOG_NAME = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> TALENTS = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> HUNGER = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> OBEY_OTHERS = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> RADAR_COLLAR = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Optional<BlockPos>> BOWL_POS = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187201_k);
    public static final DataParameter<Optional<BlockPos>> BED_POS = EntityDataManager.func_187226_a(EntityDog.class, (DataSerializer)DataSerializers.field_187201_k);
    private float headRotationCourse;
    private float headRotationCourseOld;
    private boolean isWet;
    public boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private int hungerTick;
    private int prevHungerTick;
    private int healingTick;
    private int prevHealingTick;
    private int regenerationTick;
    private int prevRegenerationTick;
    private float timeWolfIsHappy;
    private float prevTimeWolfIsHappy;
    private boolean isWolfHappy;
    public boolean hiyaMaster;
    private int reversionTime;
    private boolean hasBone;
    public EntityAIFetchBone aiFetchBone;
    public TalentUtil talents;
    public LevelUtil levels;
    public ModeUtil mode;
    public CoordUtil coords;
    public Map<String, Object> objects = new HashMap<String, Object>();

    public EntityDog(World word) {
        super(word);
        this.func_70105_a(0.6f, 0.85f);
        TalentHelper.onClassCreation(this);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.aiFetchBone = new EntityAIFetchBone(this, 1.0, 0.5f, 20.0f);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiFetchBone);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIDogBeg(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIModeAttackTarget(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityAnimal.class, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                return p_apply_1_ instanceof EntitySheep || p_apply_1_ instanceof EntityRabbit;
            }
        }));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAIShepherdDog(this, EntityAnimal.class, 0, false));
        this.func_70903_f(false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.updateEntityAttributes();
    }

    public void updateEntityAttributes() {
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0 + (this.effectiveLevel() + 1.0));
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public String func_70005_c_() {
        String name = this.getDogName();
        if (name != "") {
            return name;
        }
        return super.func_70005_c_();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_94059_bO() {
        return true;
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.talents = new TalentUtil(this);
        this.levels = new LevelUtil(this);
        this.mode = new ModeUtil(this);
        this.coords = new CoordUtil(this);
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(BEGGING, (Object)false);
        this.field_70180_af.func_187214_a(DOG_TEXTURE, (Object)0);
        this.field_70180_af.func_187214_a(DOG_NAME, (Object)"");
        this.field_70180_af.func_187214_a(TALENTS, (Object)"");
        this.field_70180_af.func_187214_a(HUNGER, (Object)60);
        this.field_70180_af.func_187214_a(OBEY_OTHERS, (Object)false);
        this.field_70180_af.func_187214_a(RADAR_COLLAR, (Object)false);
        this.field_70180_af.func_187214_a(MODE, (Object)0);
        this.field_70180_af.func_187214_a(LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(LEVEL_DIRE, (Object)0);
        this.field_70180_af.func_187214_a(BOWL_POS, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(BED_POS, (Object)Optional.absent());
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74778_a("version", "v1.10.1c");
        tagCompound.func_74768_a("doggyTex", this.getTameSkin());
        tagCompound.func_74778_a("dogName", this.getDogName());
        tagCompound.func_74768_a("dogHunger", this.getDogHunger());
        tagCompound.func_74757_a("willObey", this.willObeyOthers());
        tagCompound.func_74757_a("radioCollar", this.hasRadarCollar());
        this.talents.writeTalentsToNBT(tagCompound);
        this.levels.writeTalentsToNBT(tagCompound);
        this.mode.writeToNBT(tagCompound);
        this.coords.writeToNBT(tagCompound);
        TalentHelper.writeToNBT(this, tagCompound);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        String lastVersion = tagCompound.func_74779_i("version");
        this.setTameSkin(tagCompound.func_74762_e("doggyTex"));
        this.setDogName(tagCompound.func_74779_i("dogName"));
        this.setDogHunger(tagCompound.func_74762_e("dogHunger"));
        this.setWillObeyOthers(tagCompound.func_74767_n("willObey"));
        this.hasRadarCollar(tagCompound.func_74767_n("radioCollar"));
        this.talents.readTalentsFromNBT(tagCompound);
        this.levels.readTalentsFromNBT(tagCompound);
        this.mode.readFromNBT(tagCompound);
        this.coords.readFromNBT(tagCompound);
        TalentHelper.readFromNBT(this, tagCompound);
    }

    protected SoundEvent func_184639_G() {
        SoundEvent sound = TalentHelper.getLivingSound(this);
        if (sound != null) {
            return sound;
        }
        return this.field_70146_Z.nextInt(3) == 0 ? (this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < this.func_110138_aP() / 2.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI) : SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    public float func_70599_aP() {
        return 0.4f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186401_I;
    }

    public EntityAISit getSitAI() {
        return this.field_70911_d;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (Constants.IS_HUNGER_ON) {
            this.prevHungerTick = this.hungerTick++;
            if (this.func_184207_aI() || !this.func_70906_o()) {
                // empty if block
            }
            this.hungerTick += TalentHelper.onHungerTick(this, this.hungerTick - this.prevHungerTick);
            if (this.hungerTick > 400) {
                this.setDogHunger(this.getDogHunger() - 1);
                this.hungerTick -= 400;
            }
        }
        if (Constants.DOGS_IMMORTAL) {
            this.prevRegenerationTick = this.regenerationTick++;
            if (this.func_70906_o()) {
                this.regenerationTick += TalentHelper.onRegenerationTick(this, this.regenerationTick - this.prevRegenerationTick);
            } else if (!this.func_70906_o()) {
                this.regenerationTick = 0;
            }
            if (this.regenerationTick >= 2400 && this.isIncapacicated()) {
                this.func_70606_j(2.0f);
                this.setDogHunger(1);
            } else if (this.regenerationTick >= 2400 && !this.isIncapacicated() && this.regenerationTick >= 4400 && this.getDogHunger() < 60) {
                this.setDogHunger(this.getDogHunger() + 1);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                this.regenerationTick = 2400;
            }
        }
        if (this.func_110143_aJ() != 1.0f) {
            this.prevHealingTick = this.healingTick;
            this.healingTick += this.nourishment();
            if (this.healingTick >= 6000) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70606_j(this.func_110143_aJ() + 1.0f);
                }
                this.healingTick = 0;
            }
        }
        if (this.func_110143_aJ() <= 0.0f && this.isImmortal()) {
            this.field_70725_aQ = 0;
            this.func_70606_j(1.0f);
        }
        if (this.getDogHunger() == 0 && this.field_70170_p.func_72912_H().func_76073_f() % 100L == 0L && this.func_110143_aJ() > 1.0f) {
            this.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
        if (this.levels.isDireDog() && Constants.DIRE_PARTICLES) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (this.reversionTime > 0) {
            --this.reversionTime;
        }
        if (this.func_184187_bx() instanceof EntityPlayer && this.func_184187_bx().func_70093_af()) {
            this.func_184210_p();
        }
        TalentHelper.onLivingUpdate(this);
    }

    public void func_70071_h_() {
        float distanceToOwner;
        EntityPlayer player;
        super.func_70071_h_();
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                if (this.field_70146_Z.nextInt(15) < this.talents.getLevel("fisherdog") * 2) {
                    if (this.field_70146_Z.nextInt(15) < this.talents.getLevel("hellhound") * 2) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.func_145779_a(Items.field_179566_aV, 1);
                        }
                    } else if (!this.field_70170_p.field_72995_K) {
                        this.func_145779_a(Items.field_151115_aP, 1);
                    }
                }
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.hiyaMaster = true;
        }
        if ((this.isBegging() || this.hiyaMaster) && !this.isWolfHappy) {
            this.isWolfHappy = true;
            this.timeWolfIsHappy = 0.0f;
            this.prevTimeWolfIsHappy = 0.0f;
        } else {
            this.hiyaMaster = false;
        }
        if (this.isWolfHappy) {
            if (this.timeWolfIsHappy % 1.0f == 0.0f) {
                this.func_184185_a(SoundEvents.field_187865_gI, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsHappy = this.timeWolfIsHappy;
            this.timeWolfIsHappy += 0.05f;
            if (this.prevTimeWolfIsHappy >= 8.0f) {
                this.isWolfHappy = false;
                this.prevTimeWolfIsHappy = 0.0f;
                this.timeWolfIsHappy = 0.0f;
            }
        }
        if (this.func_70909_n() && (player = (EntityPlayer)this.func_70902_q()) != null && (distanceToOwner = player.func_70032_d((Entity)this)) <= 2.0f && this.hasBone()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(new ItemStack(ModItems.throwBone, 1, 1), 0.0f);
            }
            this.setHasBone(false);
        }
        TalentHelper.onUpdate(this);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean isControllingPassengerPlayer() {
        return this.func_184179_bs() instanceof EntityPlayer;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.isControllingPassengerPlayer()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.75f;
            forward = entitylivingbase.field_70701_bs;
            if (forward <= 0.0f) {
                forward *= 0.5f;
            }
            if (this.field_70122_E && forward > 0.0f) {
                float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                this.field_70159_w += (double)(-0.4f * f2 * 0.05f);
                this.field_70179_y += (double)(0.4f * f3 * 0.05f);
            }
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.4f;
            if (this.func_184186_bw()) {
                this.func_70659_e(this.func_70689_ay() * 0.4f);
                super.func_70612_e(strafe, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d0 = this.field_70165_t - this.field_70169_q;
            double d1 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public float func_70689_ay() {
        double speed = 0.3f;
        speed += TalentHelper.addToMoveSpeed(this);
        if ((!(this.func_70638_az() instanceof EntityDog) && !(this.func_70638_az() instanceof EntityPlayer) || this.isControllingPassengerPlayer()) && this.levels.isDireDog()) {
            speed += 0.05;
        }
        return (float)speed;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isDogWet() {
        return this.isWet;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileWet(float p_70915_1_) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70915_1_) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70923_1_ + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public boolean isImmortal() {
        return this.func_70909_n() && Constants.DOGS_IMMORTAL || this.levels.isDireDog();
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float p_70917_1_) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * p_70917_1_) * 0.15f * (float)Math.PI;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        PotionEffect potioneffect;
        float f2;
        int i;
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_180430_e(distance, damageMultiplier);
            }
        }
        if ((i = MathHelper.func_76123_f((float)((distance - 3.0f - (f2 = (potioneffect = this.func_70660_b(MobEffects.field_76430_j)) != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f) - (float)TalentHelper.fallProtection(this)) * damageMultiplier))) > 0 && !TalentHelper.isImmuneToFalls(this)) {
            this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
            this.func_70097_a(DamageSource.field_76379_h, i);
            int j = MathHelper.func_76128_c((double)this.field_70165_t);
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int l = MathHelper.func_76128_c((double)this.field_70161_v);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(j, k, l));
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                SoundType soundtype = iblockstate.func_177230_c().func_185467_w();
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (!TalentHelper.attackEntityFrom(this, damageSource, damage)) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            damage = (damage + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damageSource, damage);
    }

    public boolean func_70652_k(Entity entity) {
        if (!TalentHelper.shouldDamageMob(this, entity)) {
            return false;
        }
        int damage = 4 + (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1) / 2;
        damage = TalentHelper.attackEntityAsMob(this, entity, damage);
        if (entity instanceof EntityZombie) {
            ((EntityZombie)entity).func_70624_b((EntityLivingBase)this);
        }
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)damage);
    }

    public void func_70903_f(boolean p_70903_1_) {
        super.func_70903_f(p_70903_1_);
        if (p_70903_1_) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public void mountTo(EntityLivingBase entityLiving) {
        entityLiving.field_70177_z = this.field_70177_z;
        entityLiving.field_70125_A = this.field_70125_A;
        if (!this.field_70170_p.field_72995_K) {
            entityLiving.func_184220_m((Entity)this);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (TalentHelper.interactWithPlayer(this, player)) {
            return true;
        }
        if (this.func_70909_n()) {
            if (stack != null) {
                int foodValue = this.foodValue(stack);
                if (foodValue != 0 && this.getDogHunger() < 120 && this.canInteract(player) && !this.isIncapacicated()) {
                    if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                    this.setDogHunger(this.getDogHunger() + foodValue);
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151103_aS && this.canInteract(player)) {
                    this.func_184220_m((Entity)player);
                    if (this.field_70911_d != null) {
                        this.field_70911_d.func_75270_a(true);
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151055_y && this.canInteract(player) && !this.isIncapacicated()) {
                    player.openGui((Object)DoggyTalentsMod.instance, 1, this.field_70170_p, this.func_145782_y(), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
                    return true;
                }
                if (stack.func_77973_b() == ModItems.radioCollar && this.canInteract(player) && !this.hasRadarCollar() && !this.isIncapacicated()) {
                    if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                    this.hasRadarCollar(true);
                    return true;
                }
                if (stack.func_77973_b() instanceof IDogTreat && this.canInteract(player) && !this.isIncapacicated()) {
                    IDogTreat treat = (IDogTreat)stack.func_77973_b();
                    IDogTreat.EnumFeedBack type = treat.canGiveToDog(player, this, this.levels.getLevel(), this.levels.getDireLevel());
                    treat.giveTreat(type, player, stack, this);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.collarShears && this.func_152114_e((EntityLivingBase)player)) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70903_f(false);
                        this.field_70699_by.func_75499_g();
                        this.func_70904_g(false);
                        this.func_70606_j(8.0f);
                        this.talents.resetTalents();
                        this.func_184754_b(null);
                        this.setWillObeyOthers(false);
                        this.mode.setMode(ModeUtil.EnumMode.DOCILE);
                        if (this.hasRadarCollar()) {
                            this.func_145779_a(ModItems.radioCollar, 1);
                        }
                        this.hasRadarCollar(false);
                        this.reversionTime = 40;
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151105_aU && this.canInteract(player) && this.isIncapacicated()) {
                    if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70911_d.func_75270_a(true);
                        this.func_70606_j(this.func_110138_aP());
                        this.setDogHunger(120);
                        this.regenerationTick = 0;
                        this.func_70624_b(null);
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    }
                    return true;
                }
            }
            if (!this.field_70170_p.field_72995_K && !this.func_70877_b(stack) && this.canInteract(player)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else {
            if (stack != null && stack.func_77973_b() == ModItems.collarShears && this.reversionTime < 1 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                EntityWolf wolf = new EntityWolf(this.field_70170_p);
                wolf.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
                this.field_70170_p.func_72838_d((Entity)wolf);
                return true;
            }
            if (stack != null && stack.func_77973_b() == Items.field_151103_aS) {
                if (!player.field_71075_bZ.field_75098_d && --stack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        this.func_70903_f(true);
                        this.field_70699_by.func_75499_g();
                        this.func_70624_b(null);
                        this.field_70911_d.func_75270_a(true);
                        this.func_70606_j(20.0f);
                        this.func_184754_b(player.func_110124_au());
                        this.func_70908_e(true);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.func_70908_e(false);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand, stack);
    }

    protected boolean func_70610_aX() {
        return this.func_70608_bn() || super.func_70610_aX();
    }

    public double func_70033_W() {
        return this.func_184187_bx() instanceof EntityPlayer ? 0.5 : 0.0;
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        if (this.isIncapacicated()) {
            return false;
        }
        return TalentHelper.isPostionApplicable(this, potionEffect);
    }

    public void func_70015_d(int amount) {
        if (TalentHelper.setFire(this, amount)) {
            super.func_70015_d(amount);
        }
    }

    public int foodValue(ItemStack stack) {
        ItemFood itemfood;
        if (stack == null || stack.func_77973_b() == null) {
            return 0;
        }
        int foodValue = 0;
        Item item = stack.func_77973_b();
        if (stack.func_77973_b() != Items.field_151078_bh && item instanceof ItemFood && (itemfood = (ItemFood)item).func_77845_h()) {
            foodValue = 40;
        }
        foodValue = TalentHelper.changeFoodValue(this, stack, foodValue);
        return foodValue;
    }

    public int masterOrder() {
        int order = 0;
        EntityPlayer player = (EntityPlayer)this.func_70902_q();
        if (player != null) {
            float distanceAway = player.func_70032_d((Entity)this);
            ItemStack itemstack = player.field_71071_by.func_70448_g();
            if (itemstack != null && itemstack.func_77973_b() instanceof ItemTool && distanceAway <= 20.0f) {
                order = 1;
            }
            if (itemstack != null && (itemstack.func_77973_b() instanceof ItemSword || itemstack.func_77973_b() instanceof ItemBow)) {
                order = 2;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151015_O) {
                order = 3;
            }
        }
        return order;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public float getWagAngle(float f, float f1) {
        float f2 = (this.prevTimeWolfIsHappy + (this.timeWolfIsHappy - this.prevTimeWolfIsHappy) * f + f1) / 2.0f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 2.0f) {
            f2 %= 2.0f;
        }
        return MathHelper.func_76126_a((float)(f2 * (float)Math.PI * 11.0f)) * 0.3f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - this.func_110143_aJ()) / (this.func_110138_aP() / 20.0f) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack != null && DoggyTalentsAPI.BREED_WHITELIST.containsItem(stack);
    }

    public boolean func_70608_bn() {
        return false;
    }

    public boolean func_70648_aU() {
        return TalentHelper.canBreatheUnderwater(this);
    }

    public boolean canInteract(EntityPlayer player) {
        return this.func_152114_e((EntityLivingBase)player) || this.willObeyOthers();
    }

    public int nourishment() {
        int amount = 0;
        if (this.getDogHunger() > 0) {
            amount = 40 + 4 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            if (this.func_70906_o() && this.talents.getLevel("quickhealer") == 5) {
                amount += 20 + 2 * (MathHelper.func_76128_c((double)this.effectiveLevel()) + 1);
            }
            if (!this.func_70906_o()) {
                amount *= 5 + this.talents.getLevel("quickhealer");
                amount /= 10;
            }
        }
        return amount;
    }

    public void func_70908_e(boolean successful) {
        super.func_70908_e(successful);
    }

    public double effectiveLevel() {
        return (double)(this.levels.getLevel() + this.levels.getDireLevel()) / 10.0;
    }

    public int getTameSkin() {
        return ((Byte)this.field_70180_af.func_187225_a(DOG_TEXTURE)).byteValue();
    }

    public void setTameSkin(int index) {
        this.field_70180_af.func_187227_b(DOG_TEXTURE, (Object)((byte)index));
    }

    public String getDogName() {
        return (String)this.field_70180_af.func_187225_a(DOG_NAME);
    }

    public void setDogName(String var1) {
        this.field_70180_af.func_187227_b(DOG_NAME, (Object)var1);
    }

    public void setWillObeyOthers(boolean flag) {
        this.field_70180_af.func_187227_b(OBEY_OTHERS, (Object)flag);
    }

    public boolean willObeyOthers() {
        return (Boolean)this.field_70180_af.func_187225_a(OBEY_OTHERS);
    }

    public int points() {
        return this.levels.getLevel() + this.levels.getDireLevel() + (this.levels.isDireDog() ? 15 : 0) + (this.func_70874_b() < 0 ? 0 : 15);
    }

    public int spendablePoints() {
        return this.points() - this.usedPoints();
    }

    public int usedPoints() {
        return TalentHelper.getUsedPoints(this);
    }

    public int deductive(int par1) {
        boolean byte0 = false;
        switch (par1) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    public EntityDog createChild(EntityAgeable entityAgeable) {
        EntityDog entitydog = new EntityDog(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            entitydog.func_184754_b(uuid);
            entitydog.func_70903_f(true);
        }
        entitydog.func_70873_a(-24000 * (Constants.TEN_DAY_PUPS ? 10 : 1));
        return entitydog;
    }

    public boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(BEGGING);
    }

    public void setBegging(boolean beg) {
        this.field_70180_af.func_187227_b(BEGGING, (Object)beg);
    }

    public int getDogHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER);
    }

    public void setDogHunger(int par1) {
        this.field_70180_af.func_187227_b(HUNGER, (Object)par1);
    }

    public void hasRadarCollar(boolean flag) {
        this.field_70180_af.func_187227_b(RADAR_COLLAR, (Object)flag);
    }

    public boolean hasRadarCollar() {
        return (Boolean)this.field_70180_af.func_187225_a(RADAR_COLLAR);
    }

    public void setHasBone(boolean hasBone) {
        this.hasBone = hasBone;
    }

    public boolean hasBone() {
        return this.hasBone;
    }

    public boolean func_70878_b(EntityAnimal entityAnimal) {
        if (entityAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(entityAnimal instanceof EntityDog)) {
            return false;
        }
        EntityDog entityDog = (EntityDog)entityAnimal;
        return !entityDog.func_70909_n() ? false : (entityDog.func_70906_o() ? false : this.func_70880_s() && entityDog.func_70880_s());
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_142018_a(EntityLivingBase entityToAttack, EntityLivingBase owner) {
        if (TalentHelper.canAttackEntity(this, (Entity)entityToAttack)) {
            return true;
        }
        if (!(entityToAttack instanceof EntityCreeper) && !(entityToAttack instanceof EntityGhast)) {
            EntityDog entityDog;
            if (entityToAttack instanceof EntityDog && (entityDog = (EntityDog)entityToAttack).func_70909_n() && entityDog.func_70902_q() == owner) {
                return false;
            }
            return entityToAttack instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)entityToAttack) ? false : !(entityToAttack instanceof EntityHorse) || !((EntityHorse)entityToAttack).func_110248_bS();
        }
        return false;
    }

    public boolean func_70686_a(Class p_70686_1_) {
        if (TalentHelper.canAttackClass(this, p_70686_1_)) {
            return true;
        }
        return super.func_70686_a(p_70686_1_);
    }

    public boolean isIncapacicated() {
        return Constants.DOGS_IMMORTAL && this.func_110143_aJ() <= 1.0f;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldDismountInWater(Entity rider) {
        if (!TalentHelper.shouldDismountInWater(this, rider)) {
            return false;
        }
        return super.shouldDismountInWater(rider);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
    }

    public boolean func_82171_bF() {
        return true;
    }

    public void func_70645_a(DamageSource cause) {
    }
}

