/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.handler;

import doggytalents.lib.Constants;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration config;
    public static final String CATEGORY_DOGGYSETTINGS = "doggySettings";
    public static final String CATEGORY_DT_GENERAL = "general";

    public static void init(Configuration configuration) {
        config = configuration;
        ConfigurationHandler.loadConfig();
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationHandler());
    }

    public static void loadConfig() {
        config.addCustomCategoryComment(CATEGORY_DOGGYSETTINGS, "Here you can change details about your dog.");
        config.addCustomCategoryComment(CATEGORY_DT_GENERAL, "Other settings");
        ArrayList<String> orderDSetting = new ArrayList<String>();
        Constants.DOGS_IMMORTAL = config.get(CATEGORY_DOGGYSETTINGS, "isDogImmortal", true, "Determines if dogs die when their health reaches zero. If true, dogs will not die, and will instead become incapacitated.").setRequiresMcRestart(true).getBoolean(true);
        Constants.TEN_DAY_PUPS = config.get(CATEGORY_DOGGYSETTINGS, "tenDayPuppies", true, "Determines if pups take 10 days to mature.").getBoolean(true);
        Constants.IS_HUNGER_ON = config.get(CATEGORY_DOGGYSETTINGS, "isHungerOn", true, "Enables hunger mode for the dog").getBoolean(true);
        Constants.DIRE_PARTICLES = config.get(CATEGORY_DOGGYSETTINGS, "direParticles", true, "Enables the particle effect on Dire Level 30 dogs.").getBoolean(true);
        Constants.STARTING_ITEMS = config.get(CATEGORY_DOGGYSETTINGS, "isStartingItemsEnabled", true, "When enabled you will spawn with a guide, Doggy Charm and Command Emblem.").getBoolean(true);
        Constants.RENDER_BLOOD = config.get(CATEGORY_DOGGYSETTINGS, "bloodWhenIncapacitated", true, "When enabled, Dogs will bleed while incapacitated.").getBoolean(true);
        orderDSetting.add("isDogImmortal");
        orderDSetting.add("tenDayPuppies");
        orderDSetting.add("isHungerOn");
        orderDSetting.add("direParticles");
        orderDSetting.add("isStartingItemsEnabled");
        orderDSetting.add("bloodWhenIncapacitated");
        config.setCategoryPropertyOrder(CATEGORY_DOGGYSETTINGS, orderDSetting);
        ArrayList orderDTGeneral = new ArrayList();
        config.setCategoryPropertyOrder(CATEGORY_DT_GENERAL, orderDTGeneral);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("doggytalents")) {
            ConfigurationHandler.loadConfig();
        }
    }
}

