/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.block;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.DogBedRegistry;
import doggytalents.block.PropertyString;
import doggytalents.tileentity.TileEntityDogBed;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDogBed
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyString CASING = PropertyString.create("casing");
    public static final PropertyString BEDDING = PropertyString.create("bedding");
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6, 1.0);

    public BlockDogBed() {
        super(Material.field_151575_d);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(DoggyTalentsAPI.CREATIVE_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDogBed();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("doggytalents")) {
            String beddingId;
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("doggytalents");
            String casingId = tag.func_74779_i("casingId");
            if (DogBedRegistry.CASINGS.isValidId(casingId)) {
                ((TileEntityDogBed)worldIn.func_175625_s(pos)).setCasingId(casingId);
            }
            if (DogBedRegistry.BEDDINGS.isValidId(beddingId = tag.func_74779_i("beddingId"))) {
                ((TileEntityDogBed)worldIn.func_175625_s(pos)).setBeddingId(beddingId);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FACING}, new IUnlistedProperty[]{CASING, BEDDING});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityDogBed && state instanceof IExtendedBlockState) {
            IExtendedBlockState stateExtended = (IExtendedBlockState)state;
            TileEntityDogBed dogBed = (TileEntityDogBed)te;
            return stateExtended.withProperty((IUnlistedProperty)CASING, (Object)dogBed.getCasingId()).withProperty((IUnlistedProperty)BEDDING, (Object)dogBed.getBeddingId());
        }
        return super.getExtendedState(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int getMixedBrightnessForBlock(IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        int i = worldIn.func_175626_b(pos, 0);
        return i;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityDogBed) {
            TileEntityDogBed dogBed = (TileEntityDogBed)tileentity;
            BlockDogBed.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityDogBed)) {
            return null;
        }
        TileEntityDogBed dogBed = (TileEntityDogBed)tile;
        return DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile;
        if (!this.canBlockStay((World)world, pos) && (tile = world.func_175625_s(pos)) instanceof TileEntityDogBed) {
            TileEntityDogBed dogBed = (TileEntityDogBed)tile;
            BlockDogBed.func_180635_a((World)((World)world), (BlockPos)pos, (ItemStack)DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
            ((World)world).func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
        return blockstate.func_177230_c().isSideSolid(blockstate, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List stackList) {
        for (String casingId : DogBedRegistry.CASINGS.getKeys()) {
            stackList.add(DogBedRegistry.createItemStack(casingId, Block.field_149771_c.func_177774_c((Object)Blocks.field_150325_L) + ".0"));
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

