/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.event;

import baubles.api.IBauble;
import baubles.common.Baubles;
import baubles.common.container.InventoryBaubles;
import baubles.common.event.EventHandlerNetwork;
import baubles.common.lib.PlayerHandler;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerEntity {
    static HashSet<Integer> syncSchedule = new HashSet();

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!syncSchedule.isEmpty() && syncSchedule.contains(player.func_145782_y())) {
                EventHandlerNetwork.syncBaubles(player);
                syncSchedule.remove(player.func_145782_y());
            }
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles(player);
            for (int a = 0; a < baubles.func_70302_i_(); ++a) {
                if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof IBauble)) continue;
                ((IBauble)baubles.func_70301_a(a).func_77973_b()).onWornTick(baubles.func_70301_a(a), (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void playerDeath(PlayerDropsEvent event) {
        if (event.entity instanceof EntityPlayer && !event.entity.field_70170_p.field_72995_K && !event.entity.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            PlayerHandler.getPlayerBaubles(event.entityPlayer).dropItemsAt(event.drops, (Entity)event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void playerLoad(PlayerEvent.LoadFromFile event) {
        PlayerHandler.clearPlayerBaubles(event.entityPlayer);
        File file1 = this.getPlayerFile("baub", event.playerDirectory, event.entityPlayer.getDisplayNameString());
        if (!file1.exists()) {
            File filep = event.getPlayerFile("baub");
            if (filep.exists()) {
                try {
                    Files.copy((File)filep, (File)file1);
                    Baubles.log.info("Using and converting UUID Baubles savefile for " + event.entityPlayer.getDisplayNameString());
                    filep.delete();
                    File fb = event.getPlayerFile("baubback");
                    if (fb.exists()) {
                        fb.delete();
                    }
                }
                catch (IOException e) {}
            } else {
                File fileq = this.getLegacy1110FileFromPlayer("baub", event.playerDirectory, event.entityPlayer.getDisplayNameString());
                if (fileq.exists()) {
                    try {
                        Files.copy((File)fileq, (File)file1);
                        fileq.deleteOnExit();
                        Baubles.log.info("Using pre 1.1.1.1 Baubles savefile for " + event.entityPlayer.getDisplayNameString());
                    }
                    catch (IOException e) {}
                } else {
                    File filet = EventHandlerEntity.getLegacy1710FileFromPlayer(event.entityPlayer);
                    if (filet.exists()) {
                        try {
                            Files.copy((File)filet, (File)file1);
                            filet.deleteOnExit();
                            Baubles.log.info("Using pre MC 1.7.10 Baubles savefile for " + event.entityPlayer.getDisplayNameString());
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        PlayerHandler.loadPlayerBaubles(event.entityPlayer, file1, this.getPlayerFile("baubback", event.playerDirectory, event.entityPlayer.getDisplayNameString()));
        syncSchedule.add(event.entityPlayer.func_145782_y());
    }

    public File getPlayerFile(String suffix, File playerDirectory, String playername) {
        if ("dat".equals(suffix)) {
            throw new IllegalArgumentException("The suffix 'dat' is reserved");
        }
        return new File(playerDirectory, "_" + playername + "." + suffix);
    }

    public static File getLegacy1710FileFromPlayer(EntityPlayer player) {
        try {
            File playersDirectory = new File(player.field_70170_p.func_72860_G().func_75765_b(), "players");
            return new File(playersDirectory, player.getDisplayNameString() + ".baub");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public File getLegacy1110FileFromPlayer(String suffix, File playerDirectory, String playername) {
        if ("dat".equals(suffix)) {
            throw new IllegalArgumentException("The suffix 'dat' is reserved");
        }
        return new File(playerDirectory, playername + "." + suffix);
    }

    @SubscribeEvent
    public void playerSave(PlayerEvent.SaveToFile event) {
        PlayerHandler.savePlayerBaubles(event.entityPlayer, this.getPlayerFile("baub", event.playerDirectory, event.entityPlayer.getDisplayNameString()), this.getPlayerFile("baubback", event.playerDirectory, event.entityPlayer.getDisplayNameString()));
    }
}

