/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.event;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.BaublesContainer;
import baubles.api.cap.BaublesContainerProvider;
import baubles.api.cap.IBaublesItemHandler;
import baubles.common.Baubles;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketSync;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHandlerEntity {
    private HashMap<String, String[]> syncCheck = new HashMap();

    @SubscribeEvent
    public void cloneCapabilitiesEvent(PlayerEvent.Clone event) {
        try {
            BaublesContainer bco = (BaublesContainer)BaublesApi.getBaublesHandler(event.getOriginal());
            NBTTagCompound nbt = bco.serializeNBT();
            BaublesContainer bcn = (BaublesContainer)BaublesApi.getBaublesHandler(event.getEntityPlayer());
            bcn.deserializeNBT(nbt);
        }
        catch (Exception e) {
            Baubles.log.error("Could not clone player [" + event.getOriginal().func_70005_c_() + "] baubles when changing dimensions");
        }
    }

    @SubscribeEvent
    public void attachCapabilitiesPlayer(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("baubles", "container"), (ICapabilityProvider)new BaublesContainerProvider(new BaublesContainer()));
        }
    }

    @SubscribeEvent
    public void playerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)event.getEntity());
            for (int a = 0; a < baubles.getSlots(); ++a) {
                baubles.setChanged(a, true);
            }
            for (EntityPlayer p : event.getEntity().func_130014_f_().field_73010_i) {
                if (p.func_145782_y() == event.getEntity().func_145782_y()) continue;
                IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler(p);
                for (int a = 0; a < baubles2.getSlots(); ++a) {
                    baubles2.setChanged(a, true);
                }
            }
            Object[] ia = new String[baubles.getSlots()];
            Arrays.fill(ia, "");
            this.syncCheck.put(event.getEntity().func_70005_c_(), (String[])ia);
        }
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler(player);
            String[] hashOld = this.syncCheck.get(player.func_70005_c_());
            boolean syncTick = player.field_70173_aa % 10 == 0;
            for (int a = 0; a < baubles.getSlots(); ++a) {
                ItemStack bauble = baubles.getStackInSlot(a);
                if (bauble != null && !bauble.func_190926_b() && bauble.func_77973_b() instanceof IBauble) {
                    ((IBauble)bauble.func_77973_b()).onWornTick(bauble, (EntityLivingBase)player);
                    if (!player.func_130014_f_().field_72995_K && syncTick && !baubles.isChanged(a) && ((IBauble)bauble.func_77973_b()).willAutoSync(bauble, (EntityLivingBase)player)) {
                        String s = bauble.toString();
                        if (bauble.func_77942_o()) {
                            s = s + bauble.func_77978_p().toString();
                        }
                        if (!s.equals(hashOld[a])) {
                            baubles.setChanged(a, true);
                        }
                        hashOld[a] = s;
                    }
                }
                if (!baubles.isChanged(a) || player.func_130014_f_().field_72995_K) continue;
                try {
                    PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketSync(player, a), player.func_130014_f_().field_73011_w.getDimension());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent
    public void playerDeath(PlayerDropsEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().field_70170_p.field_72995_K && !event.getEntity().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            this.dropItemsAt(event.getEntityPlayer(), event.getDrops(), (Entity)event.getEntityPlayer());
        }
    }

    public void dropItemsAt(EntityPlayer player, List<EntityItem> drops, Entity e) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler(player);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            if (baubles.getStackInSlot(i) == null || baubles.getStackInSlot(i).func_190926_b()) continue;
            EntityItem ei = new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v, baubles.getStackInSlot(i).func_77946_l());
            ei.func_174867_a(40);
            float f1 = e.field_70170_p.field_73012_v.nextFloat() * 0.5f;
            float f2 = e.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            ei.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            ei.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            ei.field_70181_x = 0.2f;
            drops.add(ei);
            baubles.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public void tooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack() != null && !event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof IBauble) {
            BaubleType bt = ((IBauble)event.getItemStack().func_77973_b()).getBaubleType(event.getItemStack());
            event.getToolTip().add(TextFormatting.GOLD + I18n.func_74838_a((String)("name." + (Object)((Object)bt))));
        }
    }
}

