/*
 * Decompiled with CFR 0.152.
 */
package me.timbleonetv.sethome;

import java.util.ArrayList;
import me.timbleonetv.sethome.Messages;
import me.timbleonetv.sethome.MoveListener;
import me.timbleonetv.sethome.Prefix;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SetHome
extends JavaPlugin {
    public static SetHome instance;
    public static ArrayList<Player> mwt;

    static {
        mwt = new ArrayList();
    }

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)new MoveListener(), (Plugin)this);
        instance = this;
        this.loadConfig();
    }

    public void onDisable() {
    }

    public void loadConfig() {
        this.getConfig().addDefault("prefix", (Object)"&7[&6SetHome&7]");
        this.getConfig().addDefault("delay-to-teleport", (Object)3);
        this.getConfig().addDefault("no-permission-message", (Object)"&4Sorry but you are not allowed to use this command!");
        this.getConfig().addDefault("message-when-moved-while-teleport", (Object)"&4Sorry but you moved during the teleport!");
        this.getConfig().addDefault("message-when-already-typed-home", (Object)"&4Sorry but you have already typed /home!");
        this.getConfig().addDefault("message-when-executes-home-but-no-home-has-been-set", (Object)"&4Sorry but you haven't set your home yet! Type /sethome to set your home!");
        this.getConfig().addDefault("message-when-executes-home", (Object)"&7You will be teleorted in 3 seconds. Do not move until you have been teleported!");
        this.getConfig().addDefault("message-when-player-teleported-to-home", (Object)"&aYou are back at your home.");
        this.getConfig().addDefault("message-when-player-set-home", (Object)"&aYou have set your home. Type /home to get back to your home");
        this.getConfig().addDefault("message-when-too-much-arguments-at-command", (Object)"&4Too much arguments!");
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    public static SetHome getInstance() {
        return instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(Prefix.send()) + "You are not allowed to set/go the home!");
            return true;
        }
        final Player p = (Player)sender;
        if (cmd.getName().equalsIgnoreCase("sethome")) {
            if (args.length >= 1) {
                Messages.sendMessage(p, Messages.ERR_TOO_MUCH_ARGS);
                return true;
            }
            if (!p.hasPermission("home.sety")) {
                Messages.sendMessage(p, Messages.NO_PERM);
                return true;
            }
            String w = p.getWorld().getName();
            this.getConfig().set(p.getUniqueId() + ".world", (Object)w);
            this.getConfig().set(p.getUniqueId() + ".x", (Object)p.getLocation().getX());
            this.getConfig().set(p.getUniqueId() + ".y", (Object)p.getLocation().getY());
            this.getConfig().set(p.getUniqueId() + ".z", (Object)p.getLocation().getZ());
            this.getConfig().set(p.getUniqueId() + ".yaw", (Object)p.getLocation().getYaw());
            this.getConfig().set(p.getUniqueId() + ".pitch", (Object)p.getLocation().getPitch());
            this.saveConfig();
            Messages.sendMessage(p, Messages.MSG_SET_HOME);
        }
        if (cmd.getName().equalsIgnoreCase("home")) {
            if (args.length >= 1) {
                Messages.sendMessage(p, Messages.ERR_TOO_MUCH_ARGS);
                return true;
            }
            if (args.length == 0) {
                if (!p.hasPermission("home.use")) {
                    Messages.sendMessage(p, Messages.NO_PERM);
                    return true;
                }
                if (SetHome.getInstance().getConfig().getString(p.getUniqueId() + ".world") == null || SetHome.getInstance().getConfig().getString(p.getUniqueId() + ".x") == null || SetHome.getInstance().getConfig().getString(p.getUniqueId() + ".y") == null || SetHome.getInstance().getConfig().getString(p.getUniqueId() + ".z") == null || SetHome.getInstance().getConfig().getString(p.getUniqueId() + ".yaw") == null || SetHome.getInstance().getConfig().getString(p.getUniqueId() + ".pitch") == null) {
                    Messages.sendMessage(p, Messages.NO_WORLD_SET);
                    return true;
                }
                if (mwt.contains(p)) {
                    Messages.sendMessage(p, Messages.MSG_WATH);
                    return true;
                }
                mwt.add(p);
                Messages.sendMessage(p, Messages.MSG_WTP);
                Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        if (!mwt.contains(p)) {
                            return;
                        }
                        String w = SetHome.getInstance().getConfig().getString(p.getUniqueId() + ".world");
                        double x = SetHome.getInstance().getConfig().getDouble(p.getUniqueId() + ".x");
                        double y = SetHome.getInstance().getConfig().getDouble(p.getUniqueId() + ".y");
                        double z = SetHome.getInstance().getConfig().getDouble(p.getUniqueId() + ".z");
                        double yaw = SetHome.getInstance().getConfig().getDouble(p.getUniqueId() + ".yaw");
                        double pitch = SetHome.getInstance().getConfig().getDouble(p.getUniqueId() + ".pitch");
                        Location loc = new Location(Bukkit.getWorld((String)w), x, y, z);
                        loc.setYaw((float)yaw);
                        loc.setPitch((float)pitch);
                        p.teleport(loc);
                        SetHome.getInstance();
                        mwt.remove(p);
                        Messages.sendMessage(p, Messages.MSG_STP);
                    }
                }, (long)(this.getConfig().getInt("delay-to-teleport") * 20));
            }
        }
        return true;
    }
}

